# Good CLAUDE.md Example

This is an example of a well-structured CLAUDE.md file.

```markdown
# CLAUDE.md

This file provides guidance to Claude Code when working with this repository.

## Repository Overview

Gastos is a personal finance tracking application built with Next.js 14, TypeScript, and Supabase. It helps users track expenses, categorize spending, and visualize financial trends through interactive dashboards.

## Why This Exists

This app solves the problem of scattered expense tracking across multiple apps and spreadsheets. Target users are individuals who want a simple, self-hosted solution for personal finance management without sharing data with third parties.

## Quick Start & Commands

```bash
bun install          # Install dependencies (we use bun, not npm)
bun run dev          # Start dev server at localhost:3000
bun run check        # Run lint + typecheck + tests + build
bun run test         # Run Vitest tests
bun run db:migrate   # Apply Supabase migrations
```

> **Note**: Copy `.env.example` to `.env.local` and fill in Supabase credentials before starting.

## Architecture Overview

- `/app` - Next.js App Router pages and layouts
- `/components` - React components (atoms, molecules, organisms)
- `/lib` - Business logic, API clients, utilities
- `/supabase` - Database migrations and types

State management uses Zustand stores in `/lib/stores/`.

## Key Development Rules

- **CRITICAL**: NEVER commit `.env.local` or any file with credentials
- **CRITICAL**: Always use TypeScript types (no `any` allowed)
- **IMPORTANT**: Run `bun run check` before every commit
- **IMPORTANT**: Create components in the appropriate atomic design folder
- Use `bun` instead of `npm` for all package operations
- Tests go next to the file being tested (`Component.test.tsx`)

## References

- `/docs/architecture.md` - Detailed architecture documentation
- `/docs/database-schema.md` - Supabase schema and relationships
- `README.md` - Setup instructions and deployment guide
```

## Why This Example is Good

1. **Concise** - Under 80 lines, focused
2. **Three dimensions** - WHAT (overview), WHY (purpose), HOW (commands)
3. **Emphasis** - CRITICAL and IMPORTANT for key rules
4. **Actionable** - Clear commands with descriptions
5. **References** - Links to detailed docs instead of inline content
6. **Project-specific** - Mentions bun, Supabase, specific patterns
