# Python Guidelines

Reglas especificas para proyectos Python.

## Configuracion

### pyproject.toml
```toml
[tool.mypy]
strict = true
warn_return_any = true
warn_unused_ignores = true

[tool.ruff]
line-length = 100
select = ["E", "F", "I", "N", "W", "UP", "B", "A", "C4", "SIM"]
```

### Package Manager
Preferir `uv` sobre pip/poetry:
```bash
uv pip install -r requirements.txt
uv venv
```

## Type Hints

### Obligatorios
```python
def process_user(user_id: str, options: dict[str, Any] | None = None) -> User:
    ...

# Usar | en vez de Union
# Usar list, dict en vez de List, Dict (Python 3.9+)
```

### Prohibido
```python
# NO: sin tipos
def get_data(id):
    return fetch(id)

# NO: type: ignore sin explicacion
result = something()  # type: ignore
```

## Estructura

### Archivos
- Maximo 200 lineas por archivo
- Un modulo por archivo
- Imports ordenados: stdlib, third-party, local

### Formato
```python
# Line length: 100 caracteres
# Usar ruff format (compatible con black)
```

## Testing

### Framework
Preferir `pytest` sobre unittest:
```python
# tests/test_user.py
def test_create_user_success():
    user = create_user("test@example.com")
    assert user.email == "test@example.com"

def test_create_user_invalid_email():
    with pytest.raises(ValidationError):
        create_user("invalid")
```

### Ubicacion
```
src/
  users/
    service.py
tests/
  users/
    test_service.py
```

O alternativamente al lado:
```
src/
  users/
    service.py
    service_test.py
```

## Validaciones Pre-commit

```bash
ruff check .
ruff format --check .
mypy .
pytest
```
