# TypeScript Guidelines

Reglas especificas para proyectos TypeScript.

## Configuracion

### tsconfig.json
```json
{
  "compilerOptions": {
    "strict": true,
    "noUncheckedIndexedAccess": true,
    "noImplicitReturns": true,
    "exactOptionalPropertyTypes": true
  }
}
```

### Prohibido
- `any` - usar `unknown` y narrowing
- `@ts-ignore` - arreglar el tipo
- `as` type assertions - usar type guards
- `!` non-null assertion - manejar el null case

## Estructura

### Archivos
- Maximo 200 lineas por archivo
- Un componente/modulo por archivo
- Usar `type` en vez de `interface`

### Exports
```typescript
// Preferir named exports
export function processData() {}
export type Config = { ... }

// Evitar default exports
// export default function() {} // NO
```

## Testing

### Ubicacion
Tests al lado del archivo que testean:
```
src/
  utils/
    format.ts
    format.test.ts
  components/
    Button.tsx
    Button.test.tsx
```

### Cobertura
- Happy path + edge cases
- Correr tests antes de commit
- No mockear todo - preferir integracion ligera

## Git

### Branch naming
```
feature/add-user-auth
fix/login-redirect-bug
refactor/simplify-api-client
```

### Conventional commits
```
feat(auth): add login with OAuth
fix(api): handle timeout errors
refactor(utils): simplify date formatting
```

## Validaciones Pre-commit

Siempre correr antes de commitear:
```bash
npm run lint
npm run typecheck
npm run test
npm run build  # solo si no hay dev server corriendo
```
