# User Authentication - Specification

## Overview

Sistema de autenticacion de usuarios que soporta login con email/password y OAuth providers (Google, GitHub).

## Requirements

- [ ] Login con email y password
- [ ] Registro de nuevos usuarios con validacion de email
- [ ] Recuperacion de password via email
- [ ] OAuth con Google
- [ ] OAuth con GitHub
- [ ] Sesiones con JWT (access + refresh tokens)
- [ ] Rate limiting en endpoints de auth

## Technical Approach

### Stack

- Backend: Node.js con Express
- Base de datos: PostgreSQL para usuarios
- Cache: Redis para sesiones y rate limiting
- Email: SendGrid para envio de correos

### Flujo de autenticacion

1. Usuario envia credenciales a `/api/auth/login`
2. Backend valida contra DB
3. Si es valido, genera JWT pair (access: 15min, refresh: 7d)
4. Access token va en header, refresh en httpOnly cookie

### Seguridad

- Passwords hasheados con bcrypt (cost factor 12)
- Tokens firmados con RS256
- CORS configurado solo para dominios permitidos

## Dependencies

- `bcrypt` - Hashing de passwords
- `jsonwebtoken` - Manejo de JWT
- `passport` - OAuth strategies
- `ioredis` - Cliente Redis

## Open Questions

- Implementar MFA desde el inicio o dejarlo para fase 2?
- Usar magic links como alternativa al password?
- Cuanto tiempo mantener sesiones activas sin actividad?
