# Feature Plan Template

Use esta plantilla para documentar el plan de implementación de una nueva funcionalidad.

---

```markdown
# <Feature Name> - Plan de Implementación

## Estado

- [ ] BORRADOR
- [ ] ESPECIFICADO
- [ ] EN PROGRESO
- [ ] COMPLETADO

**Fecha de creación**: YYYY-MM-DD
**Última actualización**: YYYY-MM-DD

---

## Resumen Ejecutivo

<1-2 párrafos describiendo qué es el feature, por qué se necesita, y el valor que aporta>

---

## Especificación Funcional

### Descripción

<Descripción detallada de la funcionalidad>

### Comportamiento Esperado

| Acción del Usuario | Resultado Esperado |
|-------------------|-------------------|
| <acción 1> | <resultado 1> |
| <acción 2> | <resultado 2> |

### Fuera de Alcance

- <Lo que explícitamente NO se implementará>
- <Funcionalidades para futuras iteraciones>

---

## Diseño Técnico

### Componentes Afectados

| Componente | Tipo de Cambio | Descripción |
|------------|---------------|-------------|
| <componente> | nuevo/modificar/eliminar | <descripción> |

### Modelo de Datos

<Nuevas estructuras de datos, tipos, o cambios al schema>

```typescript
// Ejemplo de tipos nuevos
type NewType = {
  field: string
}
```

### APIs / Endpoints

| Método | Endpoint | Descripción |
|--------|----------|-------------|
| GET/POST/etc | /path | <descripción> |

### Dependencias Externas

- <Librerías nuevas necesarias>
- <APIs externas a integrar>
- <Servicios requeridos>

---

## UI/UX

### Wireframes / Mockups

<Descripción textual o referencia a archivos de diseño>

### Flujo de Usuario

1. Usuario <hace X>
2. Sistema <responde Y>
3. Usuario <hace Z>
4. ...

### Accesibilidad

- <Consideraciones de a11y>
- <Keyboard navigation>
- <Screen reader support>

---

## Casos Edge y Manejo de Errores

| Escenario | Comportamiento |
|-----------|---------------|
| <caso edge 1> | <cómo manejarlo> |
| <caso edge 2> | <cómo manejarlo> |
| <error posible> | <mensaje/acción> |

---

## Testing

### Tests Unitarios

- [ ] <test 1>
- [ ] <test 2>

### Tests de Integración

- [ ] <test 1>
- [ ] <test 2>

### Tests E2E (si aplica)

- [ ] <flujo 1>
- [ ] <flujo 2>

---

## Plan de Implementación

### Tareas (en orden)

1. **<Tarea 1>** - <descripción breve>
   - Archivos: `path/to/file.ts`
   - Estimado: pequeño/mediano/grande

2. **<Tarea 2>** - <descripción breve>
   - Archivos: `path/to/file.ts`
   - Dependencias: Tarea 1
   - Estimado: pequeño/mediano/grande

3. ...

### Criterios de Aceptación

- [ ] <criterio 1>
- [ ] <criterio 2>
- [ ] Tests pasan
- [ ] Linting sin errores
- [ ] Build exitoso

---

## Consideraciones Adicionales

### Performance

<Impacto en rendimiento y optimizaciones necesarias>

### Seguridad

<Consideraciones de seguridad si aplican>

### Migración / Retrocompatibilidad

<Pasos de migración si hay cambios breaking>

---

## Decisiones y Justificaciones

| Decisión | Alternativas Consideradas | Justificación |
|----------|--------------------------|---------------|
| <decisión 1> | <opción A, opción B> | <por qué elegimos esto> |

---

## Referencias

- <Links a documentación relevante>
- <Issues o tickets relacionados>
- <PRs anteriores relacionados>

---

## Notas de la Entrevista

<Resumen de puntos clave discutidos durante la entrevista de planificación>
```
