# Conceptos Básicos de Inversión

Guía educativa para explicar durante la entrevista si el usuario es principiante.

---

## El Triángulo de la Inversión

Todo instrumento financiero tiene 3 características que compiten entre sí:

```
        Rentabilidad
           /\
          /  \
         /    \
        /______\
   Seguridad  Liquidez
```

**No podés maximizar las tres a la vez:**

- Alta rentabilidad + Alta seguridad = Baja liquidez
- Alta rentabilidad + Alta liquidez = Baja seguridad
- Alta seguridad + Alta liquidez = Baja rentabilidad

### Ejemplos

| Instrumento | Rentabilidad | Seguridad | Liquidez |
|-------------|:------------:|:---------:|:--------:|
| Cuenta corriente | ⭐ | ⭐⭐⭐ | ⭐⭐⭐ |
| Plazo fijo | ⭐⭐ | ⭐⭐⭐ | ⭐ |
| Bonos soberanos | ⭐⭐ | ⭐⭐ | ⭐⭐ |
| Acciones | ⭐⭐⭐ | ⭐ | ⭐⭐ |
| Inmuebles | ⭐⭐ | ⭐⭐⭐ | ⭐ |

---

## Renta Fija vs Renta Variable

### Renta Fija

**Qué es**: Instrumento donde conocés de antemano el rendimiento (o la forma de calcularlo).

**Ejemplos**:
- Plazo fijo
- Bonos
- Obligaciones Negociables
- Letras del Tesoro

**Características**:
- ✅ Retorno predecible
- ✅ Menor volatilidad
- ❌ Retorno generalmente menor
- ❌ Riesgo de default del emisor

### Renta Variable

**Qué es**: Instrumento donde el retorno depende del mercado y no está garantizado.

**Ejemplos**:
- Acciones
- ETFs de acciones
- Fondos de renta variable
- CEDEARs

**Características**:
- ✅ Potencial de mayor retorno
- ✅ Participás del crecimiento de empresas
- ❌ Volatilidad alta
- ❌ Podés perder capital

### Comparativa

| Aspecto | Renta Fija | Renta Variable |
|---------|------------|----------------|
| Retorno | Conocido/predecible | Desconocido |
| Riesgo | Menor | Mayor |
| Volatilidad | Baja | Alta |
| Para qué sirve | Estabilidad | Crecimiento |

---

## Volatilidad

**Qué es**: La variación del precio de un activo en el tiempo.

**Alta volatilidad** = Precio sube y baja mucho
**Baja volatilidad** = Precio se mantiene estable

### Por qué importa

- No es lo mismo que riesgo, pero están relacionados
- Un activo puede tener alta volatilidad y ser buena inversión a largo plazo
- El problema es si necesitás vender en un momento de caída

### Ejemplo Visual

```
Activo A (baja volatilidad):  ___/‾‾‾\___/‾‾‾
Activo B (alta volatilidad):  _/\/\__/\  /\/\_
                              tiempo →
```

Ambos pueden terminar en el mismo punto, pero el camino es muy diferente.

---

## Diversificación

**Qué es**: No poner todos los huevos en la misma canasta.

**Por qué funciona**: Diferentes activos reaccionan diferente a los mismos eventos. Cuando uno baja, otro puede subir o mantenerse.

### Tipos de Diversificación

1. **Por tipo de activo**: Acciones + Bonos + Efectivo
2. **Por geografía**: Argentina + USA + Europa
3. **Por sector**: Tecnología + Salud + Finanzas + Consumo
4. **Por capitalización**: Grandes + Medianas + Pequeñas empresas

### Beneficio

Una cartera diversificada tiene **menor volatilidad** que sus componentes individuales, sin necesariamente sacrificar retorno.

---

## Inflación y Retorno Real

### Retorno Nominal vs Real

- **Retorno nominal**: Lo que ves que ganaste (ej: 10%)
- **Retorno real**: Lo que ganaste ajustado por inflación

```
Retorno Real ≈ Retorno Nominal - Inflación
```

### Ejemplo

Si ganás 10% y la inflación es 8%:
- Retorno nominal: 10%
- Retorno real: ~2%

### Por qué importa

El objetivo es **ganar poder adquisitivo**, no solo ganar números. Si ganás menos que la inflación, estás perdiendo plata en términos reales.

---

## Interés Compuesto

**La fuerza más poderosa de las inversiones.**

### Qué es

Ganar intereses sobre los intereses que ya ganaste.

### Ejemplo

$10.000 a 10% anual:
- Año 1: $11.000 (+$1.000)
- Año 5: $16.105 (+$5.105)
- Año 10: $25.937 (+$15.937)
- Año 20: $67.275 (+$57.275)
- Año 30: $174.494 (+$164.494)

### Regla del 72

Para saber en cuántos años duplicás tu dinero:

```
Años para duplicar ≈ 72 / Tasa de interés
```

- Al 6%: ~12 años
- Al 8%: ~9 años
- Al 10%: ~7 años
- Al 12%: ~6 años

---

## Riesgo vs Retorno

### Relación Fundamental

**A mayor retorno esperado, mayor riesgo.**

No existe inversión de alto retorno sin riesgo. Si alguien te promete eso, es una estafa.

### Frontera Eficiente

Para cada nivel de riesgo, hay un retorno máximo alcanzable. El objetivo es estar en esa frontera, no debajo.

```
Retorno ↑
         │    ⭐ Óptimo
         │   /
         │  /
         │ /
         │/
         └──────────→ Riesgo
```

---

## Horizonte Temporal

**Cuánto tiempo podés mantener la inversión sin necesitar el dinero.**

### Por qué es crucial

- **Corto plazo (<3 años)**: No podés esperar a que el mercado se recupere de una caída. Necesitás seguridad.
- **Largo plazo (>7 años)**: Podés tolerar caídas temporales porque tenés tiempo para recuperarte.

### Dato Histórico

El S&P 500 (mercado de USA):
- En cualquier año: Probabilidad de pérdida ~25%
- En cualquier período de 10 años: Probabilidad de pérdida ~5%
- En cualquier período de 20 años: Nunca perdió (históricamente)

---

## Costos de Inversión

### Tipos de Costos

1. **Comisiones de compra/venta**: Cada vez que operás
2. **Gastos de administración (expense ratio)**: Anuales en fondos/ETFs
3. **Spread**: Diferencia entre precio de compra y venta
4. **Impuestos**: Sobre ganancias

### Por qué importan

Los costos se restan de tu retorno. Un fondo con 2% de gastos anuales vs uno con 0.2% hace ENORME diferencia a largo plazo.

**Ejemplo a 30 años con $10.000 inicial y 8% de retorno:**
- Fondo A (0.2% gastos): $93.000
- Fondo B (2% gastos): $57.000

¡$36.000 de diferencia por los costos!

---

## Resumen para Principiantes

1. **Entendé tus objetivos y horizonte** antes de elegir instrumentos
2. **Diversificá** - nunca pongas todo en un solo activo
3. **Pensá en retorno real** - descontá la inflación
4. **El tiempo es tu aliado** - el interés compuesto hace magia
5. **Costos importan** - especialmente a largo plazo
6. **Riesgo y retorno van juntos** - no hay almuerzo gratis
7. **Conocete** - tu tolerancia real al riesgo se prueba en las caídas
