# Errores Comunes por Perfil de Inversor

Trampas típicas según el perfil y cómo evitarlas.

---

## Errores Generales (Todos los Perfiles)

### 1. Invertir sin Fondo de Emergencia

**El error**: Poner todos los ahorros en inversiones sin reserva líquida.

**Por qué es problema**: Si surge un imprevisto, tenés que vender inversiones (posiblemente en pérdida) para cubrir gastos.

**Solución**: Siempre mantener 3-6 meses de gastos en instrumentos líquidos y seguros ANTES de invertir.

---

### 2. Timing del Mercado

**El error**: Intentar predecir cuándo comprar y vender.

**Por qué es problema**: Nadie puede predecir el mercado consistentemente. Esperar "el momento perfecto" suele significar nunca invertir o vender en el peor momento.

**Solución**: Invertir regularmente (DCA - Dollar Cost Averaging) sin importar el precio actual.

---

### 3. No Revisar Costos

**El error**: Ignorar comisiones, gastos de administración y spreads.

**Por qué es problema**: Los costos se comen el retorno. 1-2% extra de costos puede significar perder 30-40% de tu ganancia a largo plazo.

**Solución**: Comparar costos antes de elegir. Preferir instrumentos de bajo costo.

---

### 4. Invertir en lo que No Entendés

**El error**: Comprar instrumentos complejos porque "rinden más" o alguien los recomendó.

**Por qué es problema**: Si no entendés cómo funciona, no podés evaluar el riesgo real.

**Solución**: Empezar con instrumentos simples. Aprender antes de complicar.

---

### 5. Dejarse Llevar por las Emociones

**El error**: Comprar en euforia (cuando todo sube) y vender en pánico (cuando todo baja).

**Por qué es problema**: Es exactamente lo opuesto a "comprar barato, vender caro".

**Solución**: Tener un plan y seguirlo. Automatizar las inversiones si es posible.

---

## Errores del Perfil Conservador

### 1. Ser DEMASIADO Conservador

**El error**: Tener todo en efectivo o plazo fijo por miedo a perder.

**Por qué es problema**: La inflación te come el capital. Un retorno del 5% con inflación del 8% es una pérdida del 3% real.

**Cómo evitarlo**:
- Entender que el riesgo de NO invertir también existe
- Aceptar una pequeña porción en renta variable (10-20%)
- Horizonte corto no significa 0% renta variable

---

### 2. Reaccionar Exageradamente a Pequeñas Caídas

**El error**: Vender todo porque tu cartera cayó 5%.

**Por qué es problema**: Cristalizás pérdidas que podrían recuperarse. Pagás comisiones. Perdés la oportunidad de recuperación.

**Cómo evitarlo**:
- Recordar que tu cartera ya está diseñada para baja volatilidad
- Una caída del 5% es normal incluso para carteras conservadoras
- Revisar máximo 1 vez por mes

---

### 3. Ignorar la Inflación

**El error**: Felicitarte porque "no perdiste plata" en términos nominales.

**Por qué es problema**: Si ganaste 5% y la inflación fue 8%, perdiste 3% de poder adquisitivo.

**Cómo evitarlo**:
- Siempre calcular retorno REAL (nominal - inflación)
- Buscar instrumentos que al menos empaten inflación

---

### 4. No Rebalancear por Miedo

**El error**: La renta variable subió del 20% al 28% de tu cartera y no vendés para volver al 20%.

**Por qué es problema**: Tenés más riesgo del que querés sin darte cuenta.

**Cómo evitarlo**:
- Establecer fechas de revisión (ej: cada 6 meses)
- Rebalancear mecánicamente, sin decisiones emocionales

---

## Errores del Perfil Moderado

### 1. No Definir Realmente qué es "Moderado"

**El error**: Decir "soy moderado" pero no saber qué significa en números.

**Por qué es problema**: Cuando venga una caída del 15%, vas a descubrir si realmente lo eras.

**Cómo evitarlo**:
- Definir exactamente tu asset allocation objetivo
- Escribirlo y no olvidarlo cuando las cosas se pongan feas
- Ejemplo: "50% renta fija, 45% renta variable, 5% liquidez"

---

### 2. Deslizarse hacia los Extremos

**El error**: En mercado alcista, ir agregando más renta variable. En mercado bajista, volver todo a renta fija.

**Por qué es problema**: Terminás comprando caro y vendiendo barato.

**Cómo evitarlo**:
- Mantener la disciplina de tu asset allocation original
- Rebalancear en la dirección opuesta a la tendencia

---

### 3. Compararse con Perfiles Agresivos

**El error**: "Mi amigo ganó 40% con crypto y yo solo gané 8%".

**Por qué es problema**: Estás comparando manzanas con naranjas. Tu amigo también podría haber perdido 60%.

**Cómo evitarlo**:
- Compararte solo con tu objetivo
- Recordar que tu amigo no te cuenta las pérdidas

---

### 4. Subanalizar

**El error**: Pasar más tiempo investigando inversiones que trabajando.

**Por qué es problema**: La diferencia entre la inversión "perfecta" y una "buena" suele ser pequeña. Tu tiempo vale dinero.

**Cómo evitarlo**:
- Elegir instrumentos simples y diversificados (ETFs, FCI)
- Dedicar tiempo fijo limitado (ej: 2 horas/mes máximo)

---

## Errores del Perfil Agresivo

### 1. Confundir Agresivo con Imprudente

**El error**: "Soy agresivo, puedo poner 100% en una sola acción que va a explotar".

**Por qué es problema**: Agresivo significa tolerar volatilidad, no eliminar diversificación.

**Cómo evitarlo**:
- Mantener diversificación incluso con alta exposición a renta variable
- Agresivo = 75% renta variable diversificada, NO = 100% en un solo activo

---

### 2. Overtrading

**El error**: Operar constantemente buscando pequeñas ganancias.

**Por qué es problema**: Las comisiones se comen las ganancias. Generás eventos impositivos. Estadísticamente, más operaciones = peor resultado.

**Cómo evitarlo**:
- Definir frecuencia máxima de operaciones
- Recordar que los mejores inversores operan POCO

---

### 3. Exceso de Confianza

**El error**: "Entiendo el mercado, puedo predecir qué va a pasar".

**Por qué es problema**: Profesionales con décadas de experiencia no pueden predecir consistentemente. Vos tampoco.

**Cómo evitarlo**:
- Mantener humildad
- Documentar tus predicciones y revisarlas después
- Spoiler: vas a acertar ~50% (como tirar una moneda)

---

### 4. Ignorar el Cambio de Horizonte

**El error**: Tener 55 años y seguir con cartera de 25 años.

**Por qué es problema**: Ya no tenés tiempo para recuperarte de una caída grande.

**Cómo evitarlo**:
- Revisar asset allocation cada 5-10 años
- Ir reduciendo renta variable a medida que se acerca el momento de usar el dinero

---

### 5. FOMO (Fear Of Missing Out)

**El error**: Comprar algo porque "está subiendo mucho" o "todos están comprando".

**Por qué es problema**: Suele indicar que ya subió demasiado. Comprás en el pico.

**Cómo evitarlo**:
- Si el taxista te da tips de inversión, es momento de vender
- Las mejores oportunidades están cuando nadie quiere comprar

---

### 6. Apalancamiento Excesivo

**El error**: Usar dinero prestado para invertir más.

**Por qué es problema**: Multiplica las ganancias, pero también las pérdidas. Podés perder más del 100%.

**Cómo evitarlo**:
- Nunca invertir dinero que no es tuyo
- Si usás apalancamiento, que sea mínimo y entendiendo completamente el riesgo

---

## Checklist Anti-Errores

### Antes de Invertir
- [ ] ¿Tengo fondo de emergencia completo?
- [ ] ¿Entiendo en qué estoy invirtiendo?
- [ ] ¿Revisé los costos?
- [ ] ¿Este monto es dinero que no voy a necesitar?

### Durante la Inversión
- [ ] ¿Estoy siguiendo mi plan original?
- [ ] ¿Estoy tomando decisiones por análisis o por emociones?
- [ ] ¿Mi cartera sigue balanceada?
- [ ] ¿Mis circunstancias cambiaron?

### Red Flags - Señales de que Estás por Cometer un Error
- 🚩 "Esta vez es diferente"
- 🚩 "Voy a recuperar lo perdido apostando más fuerte"
- 🚩 "Todos están ganando plata con esto"
- 🚩 "Esta inversión no puede fallar"
- 🚩 "Necesito decidir AHORA"
