# Mercado Argentino - Instrumentos de Inversión

Guía de instrumentos disponibles para inversores en Argentina.

---

## Contexto del Mercado Argentino

### Características Particulares

- **Alta inflación**: Históricamente alta, requiere instrumentos que la superen
- **Volatilidad cambiaria**: Múltiples tipos de cambio (oficial, MEP, CCL, blue)
- **Regulación CNV**: Comisión Nacional de Valores regula el mercado
- **Cepo cambiario**: Restricciones para comprar dólares oficiales

### Consideraciones Especiales

- Pensar siempre en **retorno real** (descontando inflación)
- El peso se deprecia, considerar dolarización parcial
- Riesgo soberano: bonos argentinos tienen historial de defaults
- Volatilidad política afecta mercados

---

## Instrumentos de Renta Fija

### Plazos Fijos

**Qué es**: Depósito a término en banco con tasa fija.

**Tipos**:
- **Tradicional**: Tasa fija, se conoce el rendimiento al inicio
- **UVA**: Ajusta por inflación + spread pequeño
- **Precancelable**: Permite rescate anticipado (menor tasa)

**Para quién**: Conservadores, corto plazo, liquidez en pesos.

**Consideraciones**:
- Garantía SEDESA hasta cierto monto
- Tasa suele estar debajo de inflación
- Plazo mínimo 30 días

---

### FCI Money Market

**Qué es**: Fondo Común de Inversión que invierte en plazos fijos y cauciones.

**Ventajas**:
- Liquidez inmediata (T+0 o T+1)
- Diversificación automática
- Sin monto mínimo significativo

**Para quién**: Fondo de emergencia, liquidez, esperar oportunidades.

**Ejemplos de categorías**:
- Money Market pesos
- Money Market dólar linked (ajusta por tipo de cambio oficial)

---

### Lecaps / Lecer / Boncap

**Lecaps (Letras Capitalizables)**:
- Corto plazo (meses)
- Tasa fija capitalizable
- Emitidas por el Tesoro

**Lecer (Letras ajustadas por CER)**:
- Ajustan por inflación (CER)
- Protección contra inflación
- Riesgo de tasa real negativa si inflación baja

**Boncap**:
- Plazo más largo que Lecaps
- Tasa fija
- Mayor duration = más sensibilidad a cambios de tasa

---

### Bonos Soberanos en Pesos

**Bonos CER**:
- Ajustan por inflación
- Diferentes plazos (corto a largo)
- Riesgo de reestructuración

**Bonos Tasa Fija**:
- Rendimiento conocido
- Riesgo si inflación sube más de lo esperado

**Para quién**: Moderados que buscan ganarle a inflación.

---

### Obligaciones Negociables (ON)

**Qué es**: Bonos emitidos por empresas privadas.

**Tipos**:
- ON en pesos (tasa fija o CER)
- ON dólar linked (ajusta por TC oficial)
- ON hard dollar (pagan en dólares)

**Ventajas**:
- Suelen pagar mejor que bonos soberanos
- Diversificación de riesgo emisor

**Riesgos**:
- Riesgo de crédito de la empresa
- Menor liquidez que bonos soberanos

**Para quién**: Moderados/Agresivos buscando yield.

---

### Cauciones Bursátiles

**Qué es**: Préstamos de corto plazo garantizados con títulos.

**Tipos**:
- Caución colocadora: prestás dinero
- Caución tomadora: tomás dinero prestado

**Características**:
- Plazos muy cortos (1 a 120 días)
- Alta seguridad (garantizado)
- Buena tasa para plazos cortos

**Para quién**: Conservadores, excedentes de muy corto plazo.

---

## Instrumentos de Renta Variable

### Acciones Argentinas

**Qué es**: Participación en empresas que cotizan en BYMA (Bolsa argentina).

**Índice de referencia**: Merval

**Características**:
- Alta volatilidad
- Correlación con riesgo país y política
- Liquidez variable según empresa

**Sectores principales**:
- Bancos (GGAL, BMA, SUPV)
- Energía (YPF, PAMP, TRAN)
- Consumo (MIRG)
- Servicios públicos (CEPU, TGSU)

**Para quién**: Agresivos con horizonte largo.

---

### CEDEARs

**Qué es**: Certificados de Depósito Argentinos - representan acciones extranjeras que cotizan en BYMA.

**Ventajas**:
- Invertir en empresas globales desde Argentina
- Operás en pesos pero el subyacente es en dólares
- Cobertura cambiaria implícita
- Sin límite de compra

**Populares**:
- Tech: AAPL, GOOGL, MSFT, AMZN, META
- ETFs: SPY (S&P 500), QQQ (Nasdaq)
- Otros: KO, PG, JNJ, JPM

**Consideraciones**:
- Cotizan en pesos pero siguen al CCL
- Ratio de conversión (no siempre 1:1)
- Spread mayor que operar directo en USA

**Para quién**: Todos los perfiles (ajustar porcentaje según perfil).

---

### FCI de Renta Variable

**Tipos**:
- **Renta Variable Argentina**: Invierten en acciones locales
- **Renta Variable Latam**: Acciones de la región
- **Renta Variable Internacional**: Acciones globales (vía CEDEARs)

**Ventajas**:
- Diversificación automática
- Gestión profesional
- Sin necesidad de elegir acciones individuales

**Desventajas**:
- Costos de administración
- Menor control sobre posiciones

---

## Instrumentos Mixtos

### FCI Renta Mixta

**Qué es**: Fondos que combinan renta fija y variable.

**Tipos**:
- Mixtos conservadores (más renta fija)
- Mixtos moderados (balance)
- Mixtos agresivos (más renta variable)

**Ventaja**: Rebalanceo automático incluido.

---

### FCI Dólar Linked

**Qué es**: Fondos que ajustan por el tipo de cambio oficial.

**Para qué sirve**: Cobertura contra devaluación del oficial.

**Riesgo**: Si el dólar oficial no se mueve, rendís poco.

---

## Instrumentos en Dólares

### Bonos en Dólares (Hard Dollar)

**Bonos Soberanos**:
- Globales (ley extranjera): GD30, GD35, GD38, etc.
- Bonares (ley argentina): AL30, AL35, etc.

**Características**:
- Pagan cupón y capital en dólares
- Riesgo de default/reestructuración
- Ley extranjera ofrece más protección legal

**Para quién**: Agresivos que buscan yield en dólares.

---

### Dólar MEP

**Qué es**: Compra de dólares vía mercado de capitales.

**Cómo funciona**:
1. Comprás un bono en pesos (ej: AL30)
2. Vendés el mismo bono en dólares (AL30D)
3. Obtenés dólares en tu cuenta comitente

**Consideraciones**:
- Parking: tiempo mínimo entre compra y venta
- Spread entre compra y venta
- Legal y dentro del sistema financiero

---

## Brokers/ALYCs en Argentina

### Principales Plataformas

| Broker | Características |
|--------|-----------------|
| **IOL (InvertirOnline)** | Popular, buena interfaz, comisiones medias |
| **PPI (Portfolio Personal)** | Fuerte en research, buenas herramientas |
| **Balanz** | Buenas tasas money market, interfaz moderna |
| **Cocos Capital** | Enfoque en cedears, comisiones competitivas |
| **Bull Market** | Tradicional, buena atención |

### Qué Evaluar

- Comisiones de compra/venta
- Costos de mantenimiento
- Plataforma/app
- Atención al cliente
- Instrumentos disponibles

**Nota**: Todas las ALYCs están reguladas por CNV.

---

## Asset Allocation Sugerida por Perfil (Argentina)

### Conservador

| Instrumento | % |
|-------------|---|
| FCI Money Market / Cauciones | 30% |
| Lecaps / Bonos corto plazo | 40% |
| ON Dólar Linked / Hard Dollar | 20% |
| CEDEARs (ETFs tipo SPY) | 10% |

### Moderado

| Instrumento | % |
|-------------|---|
| FCI Money Market | 10% |
| Bonos CER / Lecaps | 25% |
| ON / Bonos corporativos | 20% |
| CEDEARs | 35% |
| Acciones argentinas | 10% |

### Agresivo

| Instrumento | % |
|-------------|---|
| Liquidez / Money Market | 5% |
| Bonos (mix) | 15% |
| CEDEARs (diversificados) | 50% |
| Acciones argentinas | 20% |
| ON High Yield | 10% |

---

## Consideraciones Fiscales

### Impuestos Principales

- **Ganancias**: Hay exenciones según instrumento y plazo
- **Bienes Personales**: Aplica sobre patrimonio total
- **ITI (Impuesto a las Transferencias de Inmuebles)**: No aplica a títulos valores

### Recomendación

Consultar con contador para optimización fiscal. Las leyes cambian frecuentemente en Argentina.

---

## Advertencias Específicas Argentina

⚠️ **Riesgo soberano**: Argentina tiene historial de defaults. No poner todo en bonos soberanos.

⚠️ **Regulación cambiante**: Las reglas pueden cambiar de un día para otro.

⚠️ **Inflación**: Siempre pensar en términos reales.

⚠️ **Tipo de cambio**: Múltiples tipos de cambio complican los cálculos.

⚠️ **Parking**: Respetar plazos de parking para operar dólar MEP/CCL.
