# Mercado Internacional - Instrumentos de Inversión

Guía de instrumentos genéricos para inversión global.

---

## Conceptos Generales

### Mercados Principales

- **USA**: NYSE, NASDAQ - Los más grandes y líquidos del mundo
- **Europa**: Londres, Frankfurt, París
- **Asia**: Tokio, Hong Kong, Shanghai
- **Emergentes**: Brasil, India, México, etc.

### Monedas

- **USD (Dólar)**: Moneda de referencia global
- **EUR (Euro)**: Segunda más importante
- Considerar exposición cambiaria en tus inversiones

---

## Renta Fija

### Bonos del Tesoro (Treasury Bonds)

**Qué es**: Deuda emitida por el gobierno de USA.

**Tipos por plazo**:
- T-Bills: <1 año
- T-Notes: 2-10 años
- T-Bonds: 10-30 años

**Características**:
- Considerados "libres de riesgo" (riesgo de default casi nulo)
- Benchmark para tasas globales
- Muy líquidos

**Para quién**: Conservadores buscando seguridad máxima.

---

### Bonos Corporativos

**Investment Grade**:
- Empresas con alta calificación crediticia (BBB o superior)
- Menor riesgo, menor rendimiento
- Ejemplos: Apple, Microsoft, Johnson & Johnson

**High Yield (Junk Bonds)**:
- Empresas con menor calificación (BB o inferior)
- Mayor rendimiento, mayor riesgo de default
- Más volátiles

**Para quién**:
- Investment Grade: Conservadores/Moderados
- High Yield: Agresivos

---

### Bonos Municipales

**Qué es**: Deuda de gobiernos locales (estados, ciudades).

**Características**:
- A veces exentos de impuestos (en USA)
- Riesgo variable según emisor
- Menor liquidez

---

### ETFs de Renta Fija

| ETF | Qué sigue | Perfil |
|-----|-----------|--------|
| BND | Bonos USA total market | Conservador |
| AGG | Bonos investment grade | Conservador |
| TLT | Bonos Tesoro largo plazo | Conservador (sensible a tasas) |
| LQD | Bonos corporativos IG | Moderado |
| HYG | Bonos high yield | Agresivo |
| BNDX | Bonos internacionales | Diversificación |

---

## Renta Variable

### Acciones Individuales

**Large Cap (Gran capitalización)**:
- Empresas más grandes y establecidas
- Ejemplos: Apple, Microsoft, Amazon, Google
- Más estables, menos crecimiento potencial

**Mid Cap (Mediana capitalización)**:
- Empresas en crecimiento
- Más volatilidad que large caps
- Mayor potencial

**Small Cap (Pequeña capitalización)**:
- Empresas pequeñas
- Alta volatilidad
- Mayor potencial (y mayor riesgo)

---

### ETFs de Acciones

**Mercado Total USA**:
| ETF | Qué sigue | Expense Ratio |
|-----|-----------|---------------|
| VTI | Total Stock Market USA | 0.03% |
| ITOT | Total Stock Market USA | 0.03% |

**S&P 500 (500 empresas más grandes USA)**:
| ETF | Qué sigue | Expense Ratio |
|-----|-----------|---------------|
| SPY | S&P 500 | 0.09% |
| VOO | S&P 500 | 0.03% |
| IVV | S&P 500 | 0.03% |

**NASDAQ (Tech heavy)**:
| ETF | Qué sigue | Expense Ratio |
|-----|-----------|---------------|
| QQQ | Nasdaq 100 | 0.20% |

**Internacional (ex-USA)**:
| ETF | Qué sigue | Expense Ratio |
|-----|-----------|---------------|
| VXUS | Total International | 0.07% |
| VEA | Developed Markets | 0.05% |
| VWO | Emerging Markets | 0.08% |
| EEM | Emerging Markets | 0.68% |

**Global (USA + Internacional)**:
| ETF | Qué sigue | Expense Ratio |
|-----|-----------|---------------|
| VT | Total World Stock | 0.07% |

---

### Fondos Indexados

**Qué es**: Fondos que replican un índice sin gestión activa.

**Ventajas**:
- Costos muy bajos
- Diversificación automática
- Históricamente superan a la mayoría de fondos activos

**Ejemplos (Vanguard)**:
- VTSAX: Total Stock Market Index Fund
- VTIAX: Total International Stock Index Fund
- VBTLX: Total Bond Market Index Fund

---

## Estrategias de Inversión Pasiva

### Three-Fund Portfolio

Estrategia simple y efectiva:

1. **Total Stock Market USA** (ej: VTI) - 40-60%
2. **Total International Stock** (ej: VXUS) - 20-30%
3. **Total Bond Market** (ej: BND) - 20-40%

Ajustar porcentajes según perfil de riesgo.

---

### Target Date Funds

**Qué es**: Fondos que ajustan automáticamente su asset allocation según la fecha objetivo de retiro.

**Cómo funciona**:
- Elegís un fondo según el año en que pensás usar el dinero
- El fondo se vuelve más conservador automáticamente con el tiempo

**Ejemplos**:
- Vanguard Target Retirement 2040 (VFORX)
- Fidelity Freedom 2040 (FFFFX)

**Ventaja**: Set it and forget it.

**Para quién**: Inversores que quieren simplicidad total.

---

## REITs (Real Estate Investment Trusts)

**Qué es**: Empresas que invierten en inmuebles y distribuyen la mayoría de ganancias como dividendos.

**Tipos**:
- Residenciales
- Comerciales (oficinas, shoppings)
- Industrial (warehouses)
- Infraestructura

**ETFs de REITs**:
| ETF | Qué sigue |
|-----|-----------|
| VNQ | REITs USA |
| VNQI | REITs Internacional |

**Para quién**: Moderados/Agresivos buscando diversificación e ingresos.

---

## Commodities

### Oro

**Por qué invertir**:
- Cobertura contra inflación
- Refugio en crisis
- Diversificación

**Formas de invertir**:
- ETFs: GLD, IAU
- Mineras de oro: acciones de empresas como Barrick Gold

### Otros Commodities

ETFs de commodities diversificados:
- DJP: Diversified Commodity Index
- GSG: S&P GSCI Commodity Index

**Para quién**: Pequeña porción (5-10%) para diversificación.

---

## Asset Allocation por Perfil

### Conservador (70% Fija / 20% Variable / 10% Liquidez)

| Categoría | Instrumento | % |
|-----------|-------------|---|
| Renta Fija | BND (Bonos USA) | 40% |
| Renta Fija | BNDX (Bonos Int'l) | 20% |
| Renta Fija | Cash / Money Market | 10% |
| Renta Variable | VTI (USA) | 15% |
| Renta Variable | VXUS (Int'l) | 5% |
| Liquidez | Savings account | 10% |

### Moderado (50% Fija / 45% Variable / 5% Liquidez)

| Categoría | Instrumento | % |
|-----------|-------------|---|
| Renta Fija | BND | 30% |
| Renta Fija | BNDX | 15% |
| Renta Fija | LQD (Corp IG) | 5% |
| Renta Variable | VTI | 25% |
| Renta Variable | VXUS | 15% |
| Renta Variable | VNQ (REITs) | 5% |
| Liquidez | Cash | 5% |

### Agresivo (20% Fija / 75% Variable / 5% Liquidez)

| Categoría | Instrumento | % |
|-----------|-------------|---|
| Renta Fija | BND | 15% |
| Renta Fija | HYG (High Yield) | 5% |
| Renta Variable | VTI | 40% |
| Renta Variable | VXUS | 20% |
| Renta Variable | VWO (Emergentes) | 10% |
| Renta Variable | VNQ (REITs) | 5% |
| Liquidez | Cash | 5% |

---

## Costos a Considerar

### Tipos de Costos

1. **Expense Ratio**: Costo anual del fondo/ETF (ej: 0.03% VTI)
2. **Comisiones de trading**: Por compra/venta (muchos brokers ya no cobran)
3. **Spread bid/ask**: Diferencia entre precio compra y venta
4. **Foreign transaction fees**: Si operás en moneda extranjera
5. **Advisory fees**: Si usás un asesor

### Impacto a Largo Plazo

| Expense Ratio | Valor a 30 años ($10k, 7% retorno) |
|---------------|------------------------------------|
| 0.03% | $74,700 |
| 0.20% | $71,800 |
| 1.00% | $57,400 |
| 2.00% | $44,700 |

**Moraleja**: Los costos importan MUCHO a largo plazo.

---

## Plataformas Internacionales

### Brokers Populares

| Broker | Características |
|--------|-----------------|
| **Interactive Brokers** | Completo, acceso global, más complejo |
| **Fidelity** | Sin comisiones, buenos fondos propios |
| **Charles Schwab** | Sin comisiones, buen servicio |
| **Vanguard** | Mejores fondos indexados, interfaz básica |
| **TD Ameritrade** | Buenas herramientas, ahora parte de Schwab |

### Qué Evaluar

- Acceso desde tu país
- Mínimos de inversión
- Costos de transferencia
- Formularios fiscales

---

## Consideraciones Fiscales Generales

### Conceptos Básicos

- **Capital Gains**: Ganancias al vender (corto vs largo plazo)
- **Dividendos**: Qualified vs Non-qualified (tratamiento fiscal diferente)
- **Tax-Loss Harvesting**: Vender a pérdida para compensar ganancias

### Por País

Las reglas fiscales varían MUCHO por país. Consultar con contador local para:
- Cómo reportar inversiones extranjeras
- Tratados de doble imposición
- Retenciones en origen

---

## Principios de Inversión Pasiva

### La Evidencia Dice...

1. **La mayoría de gestores activos no superan al índice** a largo plazo
2. **Los costos son el mejor predictor** de retornos futuros (menores costos = mejores retornos)
3. **El tiempo en el mercado** supera a intentar timing del mercado
4. **Diversificación** reduce riesgo sin sacrificar retorno esperado

### Reglas de Oro

- Invertir regularmente (DCA)
- Mantener costos bajos
- Diversificar globalmente
- Rebalancear anualmente
- Ignorar el ruido del mercado
- Mantener el horizonte largo

---

## Advertencias

⚠️ **Riesgo cambiario**: Si invertís en otra moneda, las fluctuaciones te afectan.

⚠️ **Impuestos**: Las reglas fiscales son complejas. Consultá profesional.

⚠️ **Acceso**: Algunos brokers/instrumentos no están disponibles en todos los países.

⚠️ **Inflación local**: Aunque inviertas en USD, tu costo de vida está en moneda local.
