# Perfiles de Inversor - Detalle

Descripción completa de cada perfil con asset allocation recomendada.

---

## Perfil Conservador

### Características

- **Prioridad**: Preservar capital, minimizar pérdidas
- **Tolerancia a pérdidas**: Baja (0-10%)
- **Horizonte típico**: Corto plazo (<3 años)
- **Volatilidad aceptable**: Mínima

### Quién es Conservador

- Personas cerca de necesitar el dinero
- Inversores con poca experiencia
- Quienes no pueden dormir si ven números rojos
- Personas con ingresos inestables
- Quienes priorizan seguridad sobre crecimiento

### Asset Allocation Recomendada

| Categoría | Rango | Target |
|-----------|-------|--------|
| **Renta Fija** | 60-80% | 70% |
| **Renta Variable** | 10-30% | 20% |
| **Liquidez** | 5-15% | 10% |

### Distribución Detallada (Target 70/20/10)

**Renta Fija (70%)**
- 40% - Instrumentos corto plazo / Money Market
- 30% - Bonos soberanos o corporativos investment grade

**Renta Variable (20%)**
- 15% - Acciones/ETFs de grandes empresas (blue chips)
- 5% - Diversificación internacional

**Liquidez (10%)**
- 10% - Cuenta remunerada / FCI Money Market inmediato

### Expectativas de Retorno

- **Objetivo**: Superar inflación + 1-3% real
- **Volatilidad esperada**: 3-8% anual
- **Peor caída probable**: -5% a -10%

### Cuándo Revisar el Perfil

- Cuando el horizonte temporal aumente significativamente
- Si la situación financiera se estabiliza/mejora
- Después de experimentar volatilidad y manejarla bien

---

## Perfil Moderado

### Características

- **Prioridad**: Balance entre crecimiento y seguridad
- **Tolerancia a pérdidas**: Media (10-20%)
- **Horizonte típico**: Mediano plazo (3-7 años)
- **Volatilidad aceptable**: Moderada

### Quién es Moderado

- La mayoría de inversores
- Personas con horizonte de 3-7 años
- Quienes entienden que hay que tolerar volatilidad para crecer
- Inversores con experiencia básica
- Quienes buscan balance riesgo/retorno

### Asset Allocation Recomendada

| Categoría | Rango | Target |
|-----------|-------|--------|
| **Renta Fija** | 40-60% | 50% |
| **Renta Variable** | 35-55% | 45% |
| **Liquidez** | 5-10% | 5% |

### Distribución Detallada (Target 50/45/5)

**Renta Fija (50%)**
- 25% - Bonos soberanos / corporativos
- 15% - Instrumentos corto/mediano plazo
- 10% - Bonos de mayor rendimiento

**Renta Variable (45%)**
- 25% - Acciones/ETFs mercado desarrollado
- 10% - Mercados emergentes
- 10% - Sector específico o temático

**Liquidez (5%)**
- 5% - Disponible para oportunidades o emergencias

### Expectativas de Retorno

- **Objetivo**: Inflación + 4-6% real
- **Volatilidad esperada**: 8-15% anual
- **Peor caída probable**: -15% a -25%

### Cuándo Revisar el Perfil

- A medida que el horizonte se acorta (ir hacia conservador)
- Si aumenta significativamente el patrimonio (puede subir exposición)
- Cambios en situación laboral/familiar

---

## Perfil Agresivo

### Características

- **Prioridad**: Maximizar crecimiento a largo plazo
- **Tolerancia a pérdidas**: Alta (20-40%)
- **Horizonte típico**: Largo plazo (>7 años)
- **Volatilidad aceptable**: Alta

### Quién es Agresivo

- Inversores jóvenes con largo horizonte
- Personas con experiencia en mercados
- Quienes tienen otra fuente de ingresos estable
- Inversores que no necesitan el dinero en muchos años
- Quienes entienden y aceptan la volatilidad

### Asset Allocation Recomendada

| Categoría | Rango | Target |
|-----------|-------|--------|
| **Renta Variable** | 60-80% | 75% |
| **Renta Fija** | 15-35% | 20% |
| **Liquidez** | 3-10% | 5% |

### Distribución Detallada (Target 75/20/5)

**Renta Variable (75%)**
- 40% - Acciones/ETFs mercado desarrollado (S&P 500, global)
- 20% - Mercados emergentes
- 10% - Small caps / Growth
- 5% - Sectores temáticos (tech, clean energy, etc.)

**Renta Fija (20%)**
- 15% - Bonos para estabilidad
- 5% - High yield para retorno extra

**Liquidez (5%)**
- 5% - Oportunidades y rebalanceo

### Expectativas de Retorno

- **Objetivo**: Inflación + 6-10% real
- **Volatilidad esperada**: 15-25% anual
- **Peor caída probable**: -30% a -50%

### Cuándo Revisar el Perfil

- Cuando el horizonte baje de 5 años
- Cambios importantes en situación financiera
- Si descubrís que no tolerás las caídas como pensabas

---

## Comparativa Rápida

| Aspecto | Conservador | Moderado | Agresivo |
|---------|-------------|----------|----------|
| Renta Variable | 20% | 45% | 75% |
| Renta Fija | 70% | 50% | 20% |
| Liquidez | 10% | 5% | 5% |
| Retorno esperado | Inflación +2% | Inflación +5% | Inflación +8% |
| Volatilidad | 3-8% | 8-15% | 15-25% |
| Peor caída | -10% | -25% | -50% |
| Horizonte ideal | <3 años | 3-7 años | >7 años |

---

## Reglas de Ajuste por Edad (Opcional)

Regla tradicional: **Renta Variable = 100 - Edad**

Ejemplo:
- 25 años: 75% renta variable
- 40 años: 60% renta variable
- 55 años: 45% renta variable

**Nota**: Esta es una guía, no una regla absoluta. El horizonte temporal específico y la tolerancia al riesgo individual importan más que la edad.

---

## Rebalanceo

### Frecuencia Recomendada

- **Conservador**: Semestral o anual
- **Moderado**: Semestral
- **Agresivo**: Trimestral o por bandas

### Método por Bandas

Rebalancear cuando una categoría se desvíe más de:
- **Conservador**: ±5%
- **Moderado**: ±7%
- **Agresivo**: ±10%

Ejemplo Moderado (45% RV target):
- Rebalancear si RV < 38% o > 52%
