# Anti-patrones en Wide Events

## Misconceptions Comunes

### "Ya tengo structured logging, es lo mismo"

**NO.** Structured logging (JSON logs) no es Wide Events.

```json
// Esto es structured logging - MUCHOS logs por request
{"msg": "User authenticated", "user_id": "123"}
{"msg": "Fetching orders", "user_id": "123"}
{"msg": "Found 5 orders", "count": 5}
{"msg": "Returning response", "status": 200}

// Esto es Wide Event - UN log por request
{
  "user": {"id": "123"},
  "business": {"action": "list_orders", "count": 5},
  "request": {"status": 200, "duration_ms": 45}
}
```

### "OpenTelemetry ya me da todo"

**NO.** OTel es excelente para tracing distribuido, pero:
- Los traces son difíciles de queryar para análisis
- No tienen contexto de negocio estructurado
- El sampling de OTel pierde información

Wide Events **complementan** OTel. Usá el `trace_id` de OTel en tu wide event.

### "Puedo correlacionar logs después"

**NO.** Correlacionar logs dispersos es:
- Lento (múltiples queries)
- Frágil (logs pueden perderse)
- Incompleto (no todos los logs tienen el mismo contexto)

## Qué NO Hacer

### Múltiples logs por request

```typescript
// MAL
console.log('Starting request');
console.log('User authenticated:', userId);
console.log('Processing order:', orderId);
console.log('Request completed');

// BIEN
// Solo enriquecer el wide event, que se loggea al final
enrichUser({ id: userId });
enrichBusiness({ order_id: orderId });
```

### Loggear sin contexto de negocio

```typescript
// MAL - solo datos técnicos
{
  "method": "POST",
  "path": "/api/orders",
  "status": 201,
  "duration_ms": 234
}

// BIEN - incluye contexto de negocio
{
  "request": { "method": "POST", "path": "/api/orders", "status": 201 },
  "business": {
    "action": "create_order",
    "order_id": "ord_123",
    "total": 150.00,
    "items_count": 3
  }
}
```

### Ignorar el tail sampling

```typescript
// MAL - loggear todo
console.log(JSON.stringify(wideEvent));

// BIEN - sampling inteligente
if (shouldLog(wideEvent)) {
  console.log(JSON.stringify(wideEvent));
}
```

### Datos sensibles en logs

```typescript
// MAL
enrichUser({
  id: userId,
  email: user.email,      // PII
  password: user.password // NUNCA
});

// BIEN
enrichUser({
  id: userId,
  plan: user.plan
});
```

### Niveles de log incorrectos

```typescript
// MAL - todo es "info"
wideEvent.level = 'info';

// BIEN - niveles significativos
if (statusCode >= 500) level = 'error';
else if (statusCode >= 400) level = 'warn';
else if (durationMs > 1000) level = 'warn';
else level = 'info';
```

### No trackear dependencias

```typescript
// MAL - ignorar infraestructura
const data = await db.query('SELECT ...');

// BIEN - trackear cada query
const start = Date.now();
const data = await db.query('SELECT ...');
trackDbQuery(Date.now() - start);
```
