# Wide Event Schema

Esquema completo de campos recomendados para un Wide Event.

## Campos Base (Siempre Presentes)

```json
{
  "timestamp": "ISO8601",
  "level": "debug|info|warn|error",
  "service": "nombre-del-servicio",
  "version": "1.0.0",
  "environment": "production|staging|development",
  "trace_id": "uuid-para-correlación",
  "span_id": "uuid-del-span-actual"
}
```

## Deployment Context

Información del deployment para correlacionar con releases y troubleshooting.

```json
{
  "deploy": {
    "commit_hash": "abc1234567890def",
    "branch": "main",
    "region": "us-east-1",
    "instance_id": "i-1234567890abcdef0",
    "container_id": "abc123def456",
    "k8s_pod": "api-deployment-7d8f9-xyz",
    "k8s_namespace": "production",
    "deployed_at": "2024-01-15T08:00:00Z"
  }
}
```

**Campos mínimos recomendados:**
- `commit_hash` - Correlacionar bugs con releases específicas
- `region` - Identificar problemas regionales
- `instance_id` - Debug de instancias problemáticas

## Request Context

Información del HTTP request.

```json
{
  "request": {
    "id": "req_unique_id",
    "method": "GET|POST|PUT|DELETE|PATCH",
    "path": "/api/resource",
    "route": "/api/resource/:id",
    "query": { "page": "1", "limit": "10" },
    "headers": {
      "user_agent": "Mozilla/5.0...",
      "content_type": "application/json",
      "accept_language": "es-AR"
    },
    "ip": "192.168.1.1",
    "status": 200,
    "duration_ms": 245,
    "body_size_bytes": 1024
  }
}
```

## User Context

Información del usuario autenticado.

```json
{
  "user": {
    "id": "user_789",
    "email": "user@example.com",
    "plan": "free|premium|enterprise",
    "roles": ["admin", "editor"],
    "org_id": "org_123",
    "session_id": "sess_abc",
    "auth_method": "jwt|oauth|api_key"
  }
}
```

## Business Context

Datos específicos del dominio de negocio.

```json
{
  "business": {
    "action": "create_order|update_profile|process_payment",
    "entity_type": "order|user|product",
    "entity_id": "ord_456",

    "order": {
      "total": 150.00,
      "currency": "USD",
      "items_count": 3,
      "payment_method": "credit_card"
    },

    "feature_flags": {
      "new_checkout": true,
      "beta_features": false
    }
  }
}
```

## Infrastructure Context

Métricas de infraestructura y dependencias.

```json
{
  "infra": {
    "db": {
      "queries_count": 4,
      "total_time_ms": 120,
      "slowest_query_ms": 45,
      "pool_size": 10,
      "pool_available": 8
    },
    "cache": {
      "hits": 5,
      "misses": 1,
      "total_time_ms": 15
    },
    "external_calls": [
      {
        "service": "payment-api",
        "method": "POST",
        "path": "/charge",
        "status": 200,
        "duration_ms": 340
      }
    ],
    "queue": {
      "messages_published": 2,
      "queue_names": ["notifications", "analytics"]
    }
  }
}
```

## Error Context

Presente solo cuando hay error.

```json
{
  "error": {
    "code": "VALIDATION_ERROR",
    "message": "Invalid email format",
    "type": "ValidationError",
    "stack": "Error: Invalid email...\n    at validate (/app/src/validators.ts:45:11)...",
    "cause": {
      "code": "REGEX_MISMATCH",
      "field": "email"
    },
    "http_status": 400,
    "retryable": false
  }
}
```

## Performance Context

Métricas de performance internas.

```json
{
  "performance": {
    "memory_mb": 128.5,
    "cpu_percent": 25.3,
    "gc_pause_ms": 5,
    "event_loop_lag_ms": 2,
    "active_handles": 45
  }
}
```

## Ejemplo Completo

```json
{
  "timestamp": "2024-01-15T10:30:00.000Z",
  "level": "info",
  "service": "order-api",
  "version": "2.1.0",
  "environment": "production",
  "trace_id": "550e8400-e29b-41d4-a716-446655440000",
  "span_id": "7c9e6679-7425-40de-944b-e07fc1f90ae7",

  "deploy": {
    "commit_hash": "a1b2c3d4e5f6",
    "region": "us-east-1",
    "instance_id": "i-0123456789"
  },

  "request": {
    "id": "req_abc123",
    "method": "POST",
    "path": "/api/orders",
    "route": "/api/orders",
    "status": 201,
    "duration_ms": 567,
    "ip": "203.0.113.45"
  },

  "user": {
    "id": "user_789",
    "plan": "premium",
    "org_id": "org_acme"
  },

  "business": {
    "action": "create_order",
    "entity_type": "order",
    "entity_id": "ord_456",
    "order": {
      "total": 299.99,
      "currency": "USD",
      "items_count": 5
    }
  },

  "infra": {
    "db": {
      "queries_count": 6,
      "total_time_ms": 180
    },
    "cache": {
      "hits": 3,
      "misses": 1
    },
    "external_calls": [
      {
        "service": "inventory-api",
        "status": 200,
        "duration_ms": 89
      },
      {
        "service": "payment-gateway",
        "status": 200,
        "duration_ms": 234
      }
    ]
  },

  "error": null
}
```

## Campos por Tipo de Aplicación

### API REST
- Todos los campos de request
- Headers relevantes (Authorization type, API version)
- Rate limit info si aplica

### GraphQL
- `request.operation_name`
- `request.operation_type` (query/mutation/subscription)
- `request.complexity_score`

### Event-Driven / Workers
- `event.type`
- `event.source`
- `event.retry_count`
- `event.original_timestamp`

### Scheduled Jobs / Cron
- `job.name`
- `job.schedule`
- `job.items_processed`
- `job.next_run`
