# CLI Detection Reference

## CLI Detection Commands

Usar estos comandos para detectar CLIs instalados:

```bash
# Verificar un CLI específico
which <cli> && echo "installed" || echo "not installed"

# Versión (si está instalado)
<cli> --version 2>/dev/null
```

## CLIs Comunes

| CLI | Comando Detección | Propósito |
|-----|-------------------|-----------|
| `gh` | `which gh` | GitHub CLI (issues, PRs, releases) |
| `supabase` | `which supabase` | Supabase local dev, DB management |
| `vercel` | `which vercel` | Vercel deployments, serverless |
| `wrangler` | `which wrangler` | Cloudflare Workers |
| `turso` | `which turso` | Turso edge database |
| `bun` | `which bun` | Fast JS runtime, bundler |
| `pnpm` | `which pnpm` | Efficient package manager |
| `docker` | `which docker` | Container runtime |

## Instalación por CLI

| CLI | Instalación |
|-----|-------------|
| gh | `brew install gh` |
| supabase | `brew install supabase/tap/supabase` |
| vercel | `npm i -g vercel` |
| wrangler | `npm i -g wrangler` |
| turso | `brew install tursodatabase/tap/turso` |
| bun | `curl -fsSL https://bun.sh/install \| bash` |
| pnpm | `npm i -g pnpm` |
| docker | `brew install --cask docker` |

## Output Esperado

### Detección Exitosa

```
CLI Detection Results
=====================

| Status | CLI | Description |
|--------|-----|-------------|
| ✓ | gh | GitHub CLI |
| ✓ | bun | Bun runtime |
| ✓ | pnpm | Fast package manager |
| ✗ | supabase | Supabase CLI |
| ✗ | vercel | Vercel CLI |
| ✗ | wrangler | Cloudflare Workers CLI |
| ✗ | turso | Turso database CLI |
| ✗ | docker | Docker container runtime |
```

### CLIs Faltantes con Comandos

```
Missing CLIs Installation Commands
==================================

| CLI | Command |
|-----|---------|
| supabase | brew install supabase/tap/supabase |
| vercel | npm i -g vercel |
```

## Detección de Package Manager

Orden de prioridad para Node.js:

1. `bun.lockb` → Bun
2. `pnpm-lock.yaml` → pnpm
3. `package-lock.json` → npm
4. Sin lockfile → npm (default)

```bash
# Script de detección
if [ -f bun.lockb ]; then
  echo "BUN"
elif [ -f pnpm-lock.yaml ]; then
  echo "PNPM"
else
  echo "NPM"
fi
```

## Detección de Tipo de Proyecto

| Archivo | Tipo | Check Script Base |
|---------|------|-------------------|
| `package.json` | Node.js | `npm run lint && npm run test` |
| `pyproject.toml` | Python (modern) | `ruff check . && pytest` |
| `requirements.txt` | Python (legacy) | `pytest` |
| `go.mod` | Go | `go vet ./... && go test ./...` |
| `Cargo.toml` | Rust | `cargo check && cargo test` |
