# รายงานวิจัย: [หัวข้อ]

<!-- =============================================================================
PROGRESSIVE FILE ASSEMBLY STRATEGY:

รายงานนี้สร้างทีละส่วนแบบ Progressive Assembly
แต่ละส่วนจะถูกสร้างและเขียนลงไฟล์ทันทีด้วย Write/Edit tools

WORKFLOW:
1. สร้าง สรุปผู้บริหาร → Write to file
2. สร้าง บทนำ → Edit/append
3. สร้าง Finding 1 → Edit/append
4. สร้าง Finding 2 → Edit/append
5. ดำเนินการต่อสำหรับทุก findings
6. สร้าง การสังเคราะห์ → Edit/append
7. สร้าง ข้อจำกัด → Edit/append
8. สร้าง ข้อเสนอแนะ → Edit/append
9. สร้าง บรรณานุกรม (ทุก citation) → Edit/append
10. สร้าง วิธีการวิจัย → Edit/append

CITATION TRACKING:
- เก็บรายการ citations ในหน่วยความจำ: citations_used = [1, 2, 3, ...]
- หลังแต่ละส่วน: เพิ่ม citations ใหม่เข้ารายการ
- ใน บรรณานุกรม: สร้าง entry สำหรับทุก citation ในรายการ
- ไม่มี gaps, ไม่มี ranges, ไม่มี placeholders

============================================================================= -->

<!-- WRITING STANDARDS: -->
<!-- - PRECISION: เลือกคำอย่างตั้งใจ ทุกคำมีความหมาย -->
<!-- - ECONOMY: ไม่มีคำฟุ่มเฟือย ตัดคำที่ไม่จำเป็น -->
<!-- - CLARITY: ใช้ตัวเลขที่แม่นยำ ข้อมูลเฉพาะเจาะจง -->
<!-- - DIRECTNESS: บอกสิ่งที่พบโดยไม่ต้องประดิษฐ์คำ -->

<!-- SOURCE ATTRIBUTION (CRITICAL): -->
<!-- ทุกข้อเท็จจริงต้องมี [N] citation ในประโยคเดียวกัน -->
<!-- ใช้ "ตาม [1]..." หรือ "[1] รายงานว่า..." -->
<!-- แยกความแตกต่างระหว่าง FACT กับ SYNTHESIS -->
<!-- ยอมรับความไม่แน่นอน: "ไม่พบแหล่งข้อมูลสำหรับ X" -->

<!-- ANTI-TRUNCATION: -->
<!-- ห้าม: "เนื้อหาต่อไป...", "เนื่องจากความยาว...", "[ส่วนที่ X-Y...]" -->
<!-- ต้อง: สร้างแต่ละส่วนให้สมบูรณ์ก่อนไปส่วนถัดไป -->

---

## สรุปผู้บริหาร

[เขียน 3-5 bullet points, รวม 50-250 คำ]

- **สิ่งที่ค้นพบหลัก 1:** [การค้นพบสำคัญพร้อมข้อมูล/ตัวเลขเฉพาะ]
- **สิ่งที่ค้นพบหลัก 2:** [ข้อมูลเชิงลึกสำคัญพร้อมหลักฐาน]
- **สิ่งที่ค้นพบหลัก 3:** [ข้อสรุปที่สำคัญพร้อมผลกระทบ]

**ข้อเสนอแนะหลัก:** [หนึ่งประโยคชัดเจนระบุข้อเสนอแนะหลัก]

**ระดับความเชื่อมั่น:** [สูง/กลาง/ต่ำ พร้อมเหตุผลสั้นๆ]

---

## ผลลัพธ์สมมติฐาน

<!-- แสดงว่าสมมติฐานที่ตั้งไว้ถูกยืนยันหรือหักล้าง -->

| สมมติฐาน | Prior | Posterior | สถานะ | หลักฐานหลัก |
|----------|-------|-----------|-------|-------------|
| [สมมติฐาน 1] | [60%] | [85%] | ✅ ยืนยัน | [1], [2] |
| [สมมติฐาน 2] | [70%] | [30%] | ❌ หักล้าง | [3], [4] |
| [สมมติฐาน 3] | [50%] | [55%] | ⚠️ ไม่แน่ชัด | [5] |

**สมมติฐาน Contrarian:** [ระบุสมมติฐานที่ท้าทายความเชื่อทั่วไป และผลลัพธ์]

---

## บทนำ

### คำถามวิจัย
[ระบุคำถามเดิมอย่างชัดเจนและครบถ้วน]

[เพิ่ม 1-2 ประโยคให้บริบทว่าทำไมคำถามนี้สำคัญ]

### ขอบเขตและวิธีการ
[2-3 ย่อหน้าอธิบาย:]
- ด้านใดที่ถูกสำรวจโดยเฉพาะ
- อะไรรวมอยู่ vs ไม่รวมอยู่ในขอบเขต
- วิธีวิจัยที่ใช้ (web search, แหล่งวิชาการ, รายงานอุตสาหกรรม ฯลฯ)
- จำนวนแหล่งข้อมูลที่ปรึกษา
- ช่วงเวลาที่ครอบคลุม

### สมมติฐานสำคัญ
[รายการ 3-5 สมมติฐานสำคัญที่ทำระหว่างการวิจัย]
- สมมติฐาน 1: [คำอธิบายและทำไมมันสำคัญ]
- สมมติฐาน 2: [คำอธิบายและทำไมมันสำคัญ]

---

## การวิเคราะห์หลัก

<!-- CRITICAL: เขียน 4-8 findings โดยละเอียด แต่ละ 300-500 คำ -->
<!-- แต่ละ finding ควรมีหลายย่อหน้าพร้อมหลักฐาน -->
<!-- รวมข้อมูลเฉพาะ quotes สถิติ ไม่ใช่คำพูดกว้างๆ -->

### Finding 1: [ชื่อที่อธิบายจุดสำคัญ]

[ย่อหน้าเปิด: ระบุการค้นพบอย่างชัดเจนและทำไมมันสำคัญ]

[ย่อหน้าเนื้อหา:
- นำเสนอหลักฐานโดยละเอียด
- รวมข้อมูลเฉพาะ สถิติ วันที่ ตัวเลข
- อธิบายกลไก สาเหตุ หรือความสัมพันธ์
- หารือเกี่ยวกับผลกระทบ
- กล่าวถึงความละเอียดอ่อนหรือข้อยกเว้น
]

**หลักฐานสำคัญ:**
- จุดข้อมูล 1 จากแหล่ง A [1]
- จุดข้อมูล 2 จากแหล่ง B [2]
- มุมมองที่ขัดแย้งจากแหล่ง C [3] และวิธีแก้ไข

**ผลกระทบ:**
[1-2 ย่อหน้าเกี่ยวกับความหมายของการค้นพบนี้]

**แหล่งข้อมูล:** [1], [2], [3], [4]

---

### Finding 2: [ชื่อที่อธิบาย]

[ทำตามโครงสร้างเดียวกับ Finding 1]
[ขั้นต่ำ 300 คำต่อ finding]
[รวมหลายย่อหน้าพร้อมหลักฐาน]

**แหล่งข้อมูล:** [5], [6], [7], [8]

---

### Finding 3: [ชื่อที่อธิบาย]

[ดำเนินการต่อด้วยระดับรายละเอียดเดียวกัน]

**แหล่งข้อมูล:** [9], [10], [11]

---

[ดำเนินการต่อสำหรับ findings เพิ่มเติมตามต้องการ]

---

## การสังเคราะห์และข้อมูลเชิงลึก

<!-- ส่วนนี้ควร 500-1000 คำ -->
<!-- ไปไกลกว่าการสรุป - สร้างข้อมูลเชิงลึกใหม่ -->

### รูปแบบที่ระบุ

[2-3 ย่อหน้าระบุรูปแบบสำคัญจากการค้นพบ]

**รูปแบบ 1: [ชื่อ]**
[อธิบายรูปแบบโดยละเอียด อ้างว่า findings ใดสนับสนุน]

**รูปแบบ 2: [ชื่อ]**
[ดำเนินการต่อ...]

### ข้อมูลเชิงลึกใหม่

[2-3 ย่อหน้าของข้อมูลเชิงลึกที่ไปไกลกว่าที่แหล่งข้อมูลระบุชัดเจน]

**ข้อมูลเชิงลึก 1: [ชื่อ]**
[สิ่งที่ค้นพบโดยการเชื่อมโยงข้อมูลจากหลายแหล่ง]
[ทำไมมันสำคัญแม้ว่าไม่มีแหล่งใดพูดชัดเจน]

### ผลกระทบ

[2-3 ย่อหน้าเกี่ยวกับความหมายทั้งหมด]

**สำหรับ [บริบทผู้ใช้]:**
[ผลกระทบเฉพาะสำหรับสถานการณ์/การตัดสินใจของผู้ใช้]

**ผลกระทบในวงกว้าง:**
[ความสำคัญที่กว้างขึ้นของการค้นพบเหล่านี้]

---

## สมมติฐานที่ซ่อนอยู่

<!-- จาก THINK-N: Notice Assumptions - สิ่งที่ถือว่าเป็นจริงโดยไม่ได้ตั้งคำถาม -->

### สมมติฐานของนักวิจัย

| สมมติฐาน | หลักฐานสนับสนุน | หลักฐานขัดแย้ง | ถ้าผิด จะกระทบอะไร |
|----------|-----------------|----------------|-------------------|
| [สมมติฐาน 1] | [หลักฐาน] | [หลักฐาน] | [ผลกระทบต่อข้อสรุป] |
| [สมมติฐาน 2] | [หลักฐาน] | [หลักฐาน] | [ผลกระทบต่อข้อสรุป] |
| [สมมติฐาน 3] | [หลักฐาน] | [หลักฐาน] | [ผลกระทบต่อข้อสรุป] |

### สมมติฐานของแหล่งข้อมูล

[แหล่งข้อมูลที่ใช้มีสมมติฐานอะไรที่อาจไม่ใช่ความจริงเสมอ]

- **แหล่ง [X]** สมมติว่า: [สมมติฐาน] — ถูกต้องหรือไม่: [ใช่/ไม่/ไม่แน่ใจ]
- **แหล่ง [Y]** สมมติว่า: [สมมติฐาน] — ถูกต้องหรือไม่: [ใช่/ไม่/ไม่แน่ใจ]

### มุมมองที่ขาดหายไป

[เสียงของใครที่ไม่ได้ยินในงานวิจัยนี้]

- **กลุ่ม [A]:** [ทำไมสำคัญ และมีผลอย่างไรต่อข้อสรุป]
- **กลุ่ม [B]:** [ทำไมสำคัญ และมีผลอย่างไรต่อข้อสรุป]

---

## ข้อจำกัดและข้อควรระวัง

<!-- ซื่อสัตย์และครอบคลุมเกี่ยวกับสิ่งที่ไม่แน่นอน -->

### หลักฐานที่ขัดแย้ง

[2-3 ย่อหน้าอธิบายหลักฐานที่ขัดแย้งที่พบระหว่างการวิจัย]

**การค้นพบที่ขัดแย้ง 1:** [คำอธิบาย]
- แหล่ง: [Citation]
- ทำไมมันขัดแย้ง: [คำอธิบาย]
- วิธีแก้ไข/ตีความ: [การวิเคราะห์]
- ผลกระทบต่อข้อสรุป: [น้อย/ปานกลาง/มาก]

### ช่องว่างที่รู้

[2-3 ย่อหน้าอธิบาย:]
- ข้อมูลอะไรไม่มี
- คำถามอะไรยังไม่ได้คำตอบ
- อะไรจะเสริมการวิจัยนี้

### พื้นที่ของความไม่แน่นอน

[2-3 ย่อหน้าเกี่ยวกับ:]
- ที่ไหนแหล่งข้อมูลไม่เห็นด้วย
- ที่ไหนหลักฐานบาง
- อะไรอาจเปลี่ยนข้อสรุป

### สิ่งที่อาจผิดพลาด

<!-- จาก THINK-K: Know Limits - ความถ่อมตนทางญาณวิทยา -->

**ข้อสรุปที่มีโอกาสผิดมากที่สุด:**

| ข้อสรุป | ทำไมอาจผิด | หลักฐานที่จะเปลี่ยนใจ |
|---------|-----------|----------------------|
| [ข้อสรุป 1] | [เหตุผล] | [ถ้าเห็นหลักฐานแบบนี้ จะต้องทบทวน] |
| [ข้อสรุป 2] | [เหตุผล] | [ถ้าเห็นหลักฐานแบบนี้ จะต้องทบทวน] |
| [ข้อสรุป 3] | [เหตุผล] | [ถ้าเห็นหลักฐานแบบนี้ จะต้องทบทวน] |

**การประเมินความมั่นใจโดยรวม:**

- **ความมั่นใจโดยรวม:** [สูง / กลาง / ต่ำ]
- **มั่นใจที่สุดเรื่อง:** [ข้อสรุป X] — เพราะ: [หลักฐานแข็งแรง, หลายแหล่งยืนยัน]
- **มั่นใจน้อยที่สุดเรื่อง:** [ข้อสรุป Y] — เพราะ: [ข้อมูลจำกัด, แหล่งขัดแย้ง]

**สิ่งที่ต้องการเพิ่มเติมเพื่อเพิ่มความมั่นใจ:**
- [ข้อมูลประเภท X]
- [การยืนยันจากผู้เชี่ยวชาญด้าน Y]
- [การทดสอบในสถานการณ์จริง Z]

---

## ข้อเสนอแนะ

<!-- ทำให้สามารถดำเนินการได้และเฉพาะเจาะจง -->

### สิ่งที่ควรทำทันที

[3-5 การกระทำเฉพาะที่ผู้ใช้ควรทำตอนนี้]

1. **[ชื่อการกระทำ]**
   - อะไร: [การกระทำเฉพาะ]
   - ทำไม: [เหตุผลจากการค้นพบ]
   - อย่างไร: [ขั้นตอนการดำเนินการ]

2. **[ดำเนินการต่อด้วยรายละเอียดที่คล้ายกัน...]**

### ขั้นตอนถัดไป

[3-5 การกระทำสำหรับอนาคตอันใกล้ (1-3 เดือน)]

### การวิจัยเพิ่มเติมที่ต้องการ

[3-5 พื้นที่ที่การวิจัยเพิ่มเติมจะมีคุณค่า]

1. **[หัวข้อวิจัย]**
   - สิ่งที่ต้องสำรวจ: [คำถามเฉพาะ]
   - ทำไมมันสำคัญ: [การเชื่อมโยงกับการค้นพบปัจจุบัน]
   - แนวทางที่แนะนำ: [วิธีวิจัย]

---

## บรรณานุกรม

<!-- ============================================================================ -->
<!-- CRITICAL: สร้างบรรณานุกรมครบถ้วนพร้อมทุกแหล่งที่อ้างในรายงาน -->
<!-- ห้ามใช้ placeholders เช่น "[8-75] Additional citations" หรือ "etc." -->
<!-- ห้ามใช้ "...ต่อ..." หรือ "[ดำเนินการต่อด้วยทุกแหล่ง...]" -->
<!-- ทุก citation [N] ในเนื้อหารายงานต้องมี entry ที่สอดคล้องกันที่นี่ -->
<!-- ถ้ารายงานอ้าง [1]-[25] บรรณานุกรมต้องมีทั้ง 25 entries ครบถ้วน -->
<!-- ============================================================================ -->

[1] ผู้แต่ง หรือ องค์กร (2025). "ชื่อบทความหรือเอกสารฉบับเต็ม". ชื่อสิ่งพิมพ์หรือเว็บไซต์. https://full-url.com (สืบค้นเมื่อ: 2025-12-26)

[2] ผู้แต่งที่สอง (2024). "ชื่อบทความที่สอง". ชื่อวารสาร, เล่ม(ฉบับ), หน้า. https://doi-or-url.com (สืบค้นเมื่อ: 2025-12-26)

<!-- เพิ่มทุก citations ที่เหลือ [3] ถึง [N] ที่นี่ -->
<!-- รายงานมาตรฐาน: 10-20 แหล่ง | Deep: 20-30 แหล่ง -->
<!-- เขียนแต่ละ entry อย่างครบถ้วน - ไม่มี ranges, ไม่มี "etc.", ไม่มี placeholders -->

---

## ภาคผนวก: วิธีการวิจัย

### กระบวนการวิจัย

[2-3 ย่อหน้าอธิบายกระบวนการวิจัยโดยละเอียด]

**การดำเนินการตามเฟส:**
- เฟส 1 (SCOPE): [สิ่งที่ทำ]
- เฟส 2 (PLAN): [สิ่งที่ทำ]
- เฟส 3 (RETRIEVE): [สิ่งที่ทำ]
- [ดำเนินการต่อสำหรับทุกเฟสที่ดำเนินการ]

### แหล่งข้อมูลที่ปรึกษา

**แหล่งทั้งหมด:** [จำนวน]

**ประเภทแหล่ง:**
- วารสารวิชาการ: [จำนวน]
- รายงานอุตสาหกรรม: [จำนวน]
- บทความข่าว: [จำนวน]
- เอกสารราชการ/กำกับดูแล: [จำนวน]
- เอกสารทางเทคนิค: [จำนวน]

### วิธีการตรวจสอบ

**การ Triangulation:**
- วิธีตรวจสอบข้อเท็จจริงจากหลายแหล่ง
- แหล่งขั้นต่ำที่ต้องการต่อข้อเท็จจริงหลัก: 3
- วิธีจัดการกับความขัดแย้ง

**การประเมินความน่าเชื่อถือ:**
- วิธีประเมินคุณภาพแหล่ง (ความเชี่ยวชาญ, ความเป็นกลาง, ความทันสมัย)
- เกณฑ์การคัดเลือกแหล่งหลัก vs รอง

### ตารางข้อเท็จจริง-หลักฐาน

| ID | ข้อเท็จจริงหลัก | ประเภทหลักฐาน | แหล่งสนับสนุน | ความเชื่อมั่น |
|----|-----------------|---------------|---------------|---------------|
| C1 | [ข้อเท็จจริงหลักแรก] | [ข้อมูลปฐมภูมิ / Meta-analysis] | [1], [2], [3] | สูง / กลาง / ต่ำ |
| C2 | [ข้อเท็จจริงที่สอง] | [ประเภทหลักฐาน] | [4], [5], [6] | สูง / กลาง / ต่ำ |

**ระดับความเชื่อมั่น:**
- **สูง**: 3+ แหล่งอิสระ, การค้นพบสอดคล้อง, วิธีการแข็งแกร่ง
- **กลาง**: 2 แหล่ง หรือ แหล่งคุณภาพสูงเดียวพร้อมความขัดแย้งเล็กน้อย
- **ต่ำ**: แหล่งเดียว หรือ ความขัดแย้งมากในหลักฐาน

---

## ข้อมูลรายงาน

**โหมดวิจัย:** [Quick/Standard/Deep]
**แหล่งทั้งหมด:** [จำนวน]
**จำนวนคำ:** [จำนวนโดยประมาณ]
**สร้างเมื่อ:** [วันที่และเวลา]
**สถานะการตรวจสอบ:** [ผ่าน พร้อม X warnings / ผ่านโดยไม่มี warnings]

---

<!-- END OF TEMPLATE -->
