# COMPASS Checklist: Perspective Coverage Audit

A framework for ensuring comprehensive multi-perspective coverage in research.

## Overview

**COMPASS** ensures you've explored all important angles before drawing conclusions.

| Letter | Perspective | Question |
|--------|-------------|----------|
| **C** | Contrast | Have I seen both sides? |
| **O** | Outlook | Have I covered past, present, and future? |
| **M** | Modes | Have I checked theory AND practice? |
| **P** | Perspectives | Have I heard mainstream AND alternative views? |
| **A** | Arena | Have I considered local AND global contexts? |
| **S** | Scale | Have I looked at individual, org, and systemic levels? |
| **S** | Sources | Have I used diverse source types? |

**When to use:** Phase 3.5: GAP ANALYSIS, after initial retrieval

---

## C - Contrast (Pro/Con Analysis)

Every topic has multiple sides. Verify you've captured:

| Aspect | Description | Check |
|--------|-------------|-------|
| **Benefits** | Advantages, positive outcomes, success stories | [ ] |
| **Risks** | Downsides, negative outcomes, failure cases | [ ] |
| **Trade-offs** | What must be sacrificed for gains | [ ] |
| **Costs** | Financial, time, opportunity costs | [ ] |

### Questions to Ask
- "What are the main arguments FOR this?"
- "What are the main arguments AGAINST this?"
- "What do supporters gain? What do critics fear?"
- "What trade-offs does this involve?"

### Gap Indicator
If you only have positive OR only negative sources → **Critical Gap**

---

## O - Outlook (Temporal Coverage)

Understanding requires historical context and future trajectory:

| Timeframe | Focus | Check |
|-----------|-------|-------|
| **Historical** | How did we get here? Origins, evolution | [ ] |
| **Current** | What's the state of the art? Latest developments | [ ] |
| **Future** | Where is this heading? Predictions, trends | [ ] |
| **Milestones** | Key turning points, breakthroughs | [ ] |

### Questions to Ask
- "What's the backstory?"
- "What's happening RIGHT NOW (this year)?"
- "What do experts predict for the next 2-5 years?"
- "What changed between then and now?"

### Gap Indicator
If all sources are from same year → **Temporal Gap**

---

## M - Modes (Theory vs Practice)

Academic knowledge often differs from real-world application:

| Mode | Focus | Check |
|------|-------|-------|
| **Theoretical** | What research/academics say, ideal models | [ ] |
| **Practical** | What happens in implementation, real cases | [ ] |
| **Gap Analysis** | Difference between ideal and reality | [ ] |
| **Best Practices** | What works in practice, lessons learned | [ ] |

### Questions to Ask
- "What does the research say?"
- "What happens when people actually try this?"
- "Why does practice sometimes differ from theory?"
- "What are the proven best practices?"

### Gap Indicator
If only academic OR only anecdotal sources → **Mode Gap**

---

## P - Perspectives (Viewpoint Diversity)

Avoid echo chambers by seeking diverse viewpoints:

| Perspective | Focus | Check |
|-------------|-------|-------|
| **Mainstream** | Conventional wisdom, dominant narrative | [ ] |
| **Alternative** | Contrarian, minority, emerging views | [ ] |
| **Expert** | Academic, professional, specialist views | [ ] |
| **Popular** | Public understanding, common perceptions | [ ] |
| **Affected Parties** | Those directly impacted | [ ] |

### Questions to Ask
- "What's the consensus view?"
- "Who disagrees with the consensus? Why?"
- "What do experts say vs what does the public think?"
- "What do people actually affected by this say?"

### Gap Indicator
If all sources agree → **Perspective Gap** (seek dissent)

---

## A - Arena (Scope Coverage)

Context matters - what's true locally may differ globally:

| Scope | Focus | Check |
|-------|-------|-------|
| **Local** | Country/region-specific considerations | [ ] |
| **Global** | International, cross-border patterns | [ ] |
| **Industry** | Sector-specific variations | [ ] |
| **Cultural** | Cultural/social context factors | [ ] |

### Questions to Ask
- "Is this different in [specific region]?"
- "What are the global patterns?"
- "Does this vary by industry?"
- "What cultural factors might affect this?"

### Gap Indicator
If all sources from one country/context → **Arena Gap**

---

## S - Scale (Impact Levels)

Effects differ at different scales:

| Scale | Focus | Check |
|-------|-------|-------|
| **Individual** | Personal impact, micro-level effects | [ ] |
| **Organizational** | Company/team level implications | [ ] |
| **Systemic** | Industry/society-wide effects | [ ] |
| **Cascading** | How effects at one level affect others | [ ] |

### Questions to Ask
- "How does this affect individuals?"
- "How does this affect organizations?"
- "What are the broader societal implications?"
- "How do effects at different levels interact?"

### Gap Indicator
If only one scale covered → **Scale Gap**

---

## S - Sources (Source Diversity)

Quality research uses diverse source types:

| Source Type | Characteristics | Check |
|-------------|-----------------|-------|
| **Primary** | Original data, official reports, direct sources | [ ] |
| **Secondary** | Analysis, commentary, synthesis | [ ] |
| **Academic** | Peer-reviewed, rigorous methodology | [ ] |
| **Industry** | Practical, current, insider knowledge | [ ] |
| **News** | Current events, accessible | [ ] |
| **User-Generated** | Real experiences, ground truth | [ ] |

### Questions to Ask
- "Do I have any primary/original sources?"
- "Do I have academic AND practical sources?"
- "Are my sources all from the same type?"

### Gap Indicator
If all sources same type → **Source Diversity Gap**

---

## COMPASS Audit Template

Use after Phase 3: RETRIEVE to assess coverage:

```markdown
## COMPASS Audit for "[TOPIC]"

### Coverage Assessment

| Category | Fully Covered | Partially Covered | Missing |
|----------|---------------|-------------------|---------|
| **C** - Contrast | [ ] | [ ] | [ ] |
| **O** - Outlook | [ ] | [ ] | [ ] |
| **M** - Modes | [ ] | [ ] | [ ] |
| **P** - Perspectives | [ ] | [ ] | [ ] |
| **A** - Arena | [ ] | [ ] | [ ] |
| **S** - Scale | [ ] | [ ] | [ ] |
| **S** - Sources | [ ] | [ ] | [ ] |

### Gap Details

**Critical Gaps (Must Address):**
1. [Gap] → Follow-up query: "[query]"
2. [Gap] → Follow-up query: "[query]"

**Minor Gaps (Address if Time Permits):**
1. [Gap] → Follow-up query: "[query]"

### Coverage Score
- Fully Covered: X/7
- Partially Covered: Y/7
- Missing: Z/7

**Recommendation:** [Proceed / Need More Research]
```

---

## Example: AI Coding Assistants

### COMPASS Audit

| Category | Status | Notes |
|----------|--------|-------|
| **C** - Contrast | Fully | Have benefits AND limitations/risks |
| **O** - Outlook | Partial | Have current (2025), need history |
| **M** - Modes | Fully | Have research AND practitioner views |
| **P** - Perspectives | Partial | Have mainstream, need skeptic view |
| **A** - Arena | Missing | Only US sources, need global |
| **S** - Scale | Partial | Have individual, need enterprise |
| **S** - Sources | Fully | Academic, industry, user reviews |

### Priority Gaps
1. **Historical context** → "AI coding assistants history evolution timeline"
2. **Skeptic perspective** → "AI coding criticism skeptic developer"
3. **Global context** → "AI coding adoption Europe Asia"
4. **Enterprise scale** → "AI coding enterprise large team adoption"

---

## Integration with Standard Mode

**When:** Phase 3.5: GAP ANALYSIS

**Process:**
1. Complete initial RETRIEVE phase
2. Run COMPASS audit
3. Identify gaps with "Missing" or "Partial" status
4. Generate follow-up queries for critical gaps
5. Execute follow-up searches
6. Re-audit until minimum coverage achieved

**Minimum Coverage by Tier:**
| Tier | Min "Fully Covered" | Max "Missing" |
|------|---------------------|---------------|
| Quick | 3/7 | 3/7 |
| Standard | 4/7 | 2/7 |
| Deep | 5/7 | 1/7 |
| Exhaustive | 6/7 | 0/7 |
