# Business Model Canvas (BMC)

Created by Alexander Osterwalder and Yves Pigneur, published in "Business Model Generation" (2010).

## The Nine Building Blocks

```
┌─────────────┬────────────┬────────────┬────────────┬─────────────┐
│      8      │      7     │      2     │      4     │      1      │
│    Key      │    Key     │   Value    │  Customer  │   Customer  │
│  Partners   │ Activities │Proposition │Relationships│  Segments   │
│             │            │            │            │             │
│             ├────────────┤            ├────────────┤             │
│             │      6     │            │      3     │             │
│             │    Key     │            │  Channels  │             │
│             │ Resources  │            │            │             │
│             │            │            │            │             │
├─────────────┴────────────┴────────────┴────────────┴─────────────┤
│            9             │              5                         │
│       Cost Structure     │         Revenue Streams                │
│                          │                                        │
└──────────────────────────┴────────────────────────────────────────┘
```

### Fill Order

Start from the right side (customers) and work left:

1. Customer Segments → 2. Value Propositions → 3. Channels → 4. Customer Relationships → 5. Revenue Streams → 6. Key Resources → 7. Key Activities → 8. Key Partners → 9. Cost Structure

---

## Block Definitions

### 1. Customer Segments

**Who are you creating value for?**

| Segment Type | Description |
|--------------|-------------|
| **Mass Market** | Large group, similar needs |
| **Niche Market** | Specialized segment |
| **Segmented** | Slightly different needs |
| **Diversified** | Unrelated segments |
| **Multi-sided** | Two+ interdependent segments (e.g., platform) |

**Questions:**
- Who are our most important customers?
- What are their common characteristics?
- What are their distinct needs?

---

### 2. Value Propositions

**What value do you deliver to the customer?**

| Value Type | Examples |
|------------|----------|
| **Newness** | First to offer, innovation |
| **Performance** | Better, faster, stronger |
| **Customization** | Tailored to needs |
| **Getting the job done** | Helps complete a task |
| **Design** | Aesthetics, user experience |
| **Brand/Status** | Prestige, social signaling |
| **Price** | Lower cost, better value |
| **Cost Reduction** | Helps save money |
| **Risk Reduction** | Warranties, guarantees |
| **Accessibility** | Available to new customers |
| **Convenience** | Easier to use/buy |

**Questions:**
- What bundle of products/services do we offer?
- Which customer needs are we satisfying?
- What problems are we helping solve?

---

### 3. Channels

**How do you reach customers and deliver value?**

| Phase | Channel Examples |
|-------|-----------------|
| **Awareness** | Advertising, PR, social media |
| **Evaluation** | Website, reviews, trials |
| **Purchase** | Online store, sales team, retail |
| **Delivery** | Digital download, shipping, service |
| **After Sales** | Support, community, updates |

**Questions:**
- How do customers want to be reached?
- Which channels work best?
- Which are most cost-efficient?

---

### 4. Customer Relationships

**What type of relationship does each segment expect?**

| Relationship Type | Description |
|-------------------|-------------|
| **Personal Assistance** | Human interaction |
| **Dedicated Personal** | Assigned representative |
| **Self-Service** | No direct relationship |
| **Automated Services** | Personalized self-service |
| **Communities** | User communities |
| **Co-creation** | Customers help create value |

**Questions:**
- What relationship does each segment expect?
- How do we acquire, retain, grow customers?
- How costly is each relationship type?

---

### 5. Revenue Streams

**How do you capture value?**

| Revenue Type | Examples |
|--------------|----------|
| **Asset Sale** | One-time product sale |
| **Usage Fee** | Pay per use |
| **Subscription** | Recurring fee |
| **Lending/Leasing** | Temporary access |
| **Licensing** | Permission to use IP |
| **Brokerage** | Commission on transactions |
| **Advertising** | Fees for ads |

**Pricing Mechanisms:**
- Fixed: List price, feature-dependent, volume-dependent
- Dynamic: Negotiation, yield management, real-time market

**Questions:**
- What are customers willing to pay for?
- How do they prefer to pay?
- What's each stream's contribution?

---

### 6. Key Resources

**What assets are required?**

| Resource Type | Examples |
|---------------|----------|
| **Physical** | Facilities, equipment, inventory |
| **Intellectual** | Patents, brands, data, copyrights |
| **Human** | Experts, skilled team |
| **Financial** | Cash, credit, stock options |

**Questions:**
- What resources does our value proposition require?
- Our channels? Relationships? Revenue streams?

---

### 7. Key Activities

**What must you do to make the model work?**

| Activity Type | Examples |
|---------------|----------|
| **Production** | Design, make, deliver |
| **Problem Solving** | Consulting, solutions |
| **Platform/Network** | Managing, promoting, developing |

**Questions:**
- What activities does our value proposition require?
- Our channels? Relationships? Revenue streams?

---

### 8. Key Partners

**Who helps you operate?**

| Partnership Type | Motivation |
|------------------|------------|
| **Strategic Alliance** | Non-competitors working together |
| **Coopetition** | Competitors partnering |
| **Joint Venture** | Developing new business |
| **Buyer-Supplier** | Reliable supply |

**Questions:**
- Who are key partners and suppliers?
- What activities do partners perform?
- What resources come from partners?

---

### 9. Cost Structure

**What are the most important costs?**

| Cost Type | Characteristics |
|-----------|-----------------|
| **Cost-Driven** | Minimize costs wherever possible |
| **Value-Driven** | Focus on value creation |

| Cost Categories | Description |
|-----------------|-------------|
| **Fixed Costs** | Same regardless of volume (rent, salaries) |
| **Variable Costs** | Vary with volume (materials, commissions) |
| **Economies of Scale** | Cost per unit decreases with volume |
| **Economies of Scope** | Cost advantages from breadth |

---

## Example: ThepExcel BMC

```markdown
### Customer Segments
- Thai office workers wanting Excel/data skills
- Managers needing team training
- Corporate HR for employee development

### Value Proposition
- Practical Thai-language Excel/Power BI training
- Job-focused, immediately applicable
- Self-paced with expert support

### Channels
- Website (thepexcel.com)
- YouTube (awareness)
- Facebook/Line (community)
- Corporate sales

### Customer Relationships
- Self-service courses
- Community support (Facebook group)
- Dedicated support for corporate

### Revenue Streams
- Course sales (one-time)
- Subscription (potential)
- Corporate training (contracts)

### Key Resources
- Course content library
- ThepExcel brand
- Instructor expertise

### Key Activities
- Content creation
- Platform maintenance
- Marketing/sales
- Customer support

### Key Partners
- Payment processors
- Hosting providers
- Corporate HR networks

### Cost Structure
- Content production
- Platform costs
- Marketing spend
- Support team
```

---

## Tips for Filling

1. **Use sticky notes** - One idea per note, easy to move
2. **Be specific** - Avoid vague statements
3. **Customer language** - Use words they would use
4. **Multiple canvases** - One per segment if needed
5. **Iterate** - First draft won't be perfect
6. **Test assumptions** - Validate with customers
