# Lean Canvas

Created by Ash Maurya, adapted from Business Model Canvas for startups. Published in "Running Lean" (2012).

## Canvas Structure

```
┌─────────────┬────────────┬────────────┬────────────┬─────────────┐
│      2      │      4     │      3     │      9     │      1      │
│   Problem   │  Solution  │  Unique    │   Unfair   │  Customer   │
│             │            │   Value    │  Advantage │  Segments   │
│  List top 3 │ Top 3      │Proposition │            │             │
│  problems   │ features   │            │ Can't be   │  Target     │
│             │            │ Single,    │ easily     │  customers  │
│             │            │ clear,     │ copied or  │             │
│             │            │ compelling │ bought     │  Early      │
│  Existing   ├────────────┤ message    ├────────────┤  Adopters   │
│  alternatives│     8     │            │      5     │             │
│             │    Key     │            │  Channels  │             │
│             │  Metrics   │            │            │             │
│             │            │            │ Path to    │             │
│             │            │            │ customers  │             │
├─────────────┴────────────┴────────────┴────────────┴─────────────┤
│            7             │              6                         │
│       Cost Structure     │         Revenue Streams                │
│                          │                                        │
│   Customer acquisition   │   Revenue model                        │
│   Distribution costs     │   Lifetime value                       │
│   Hosting, people, etc   │   Gross margin                         │
└──────────────────────────┴────────────────────────────────────────┘
```

### Fill Order

1. Customer Segments → 2. Problem → 3. Unique Value Proposition → 4. Solution → 5. Channels → 6. Revenue Streams → 7. Cost Structure → 8. Key Metrics → 9. Unfair Advantage

---

## Block Definitions

### 1. Customer Segments

**Who has the problem?**

| Element | Description |
|---------|-------------|
| **Target Customers** | Who you're building for |
| **Early Adopters** | Who will buy first, most pain |

**Tips:**
- Be specific (not "everyone")
- Define early adopters separately
- One segment per canvas initially

**Example:**
```
Target: Thai office workers aged 25-40
Early Adopters: Executive assistants drowning in Excel reports
```

---

### 2. Problem

**What are the top 3 problems?**

List the 3 most important problems your customers face.

**Also capture:**
- **Existing Alternatives** - How do they solve it today?

**Tips:**
- Rank by importance
- Problems should be worth solving
- Validate through interviews

**Example:**
```
1. Spend hours on repetitive data tasks
2. Can't create reports boss wants
3. Don't know Excel exists beyond basics

Existing Alternatives:
- YouTube tutorials (scattered, no structure)
- Expensive classroom courses
- Asking colleagues
```

---

### 3. Unique Value Proposition (UVP)

**Why are you different and worth attention?**

A single, clear, compelling message that states why you are different and worth buying.

**Formula:**
```
[End result customer wants] + [Time period] + [Address objections]
```

**Tips:**
- Target early adopters, not everyone
- Focus on finished story, not features
- Pick words carefully

**Examples:**
```
Bad: "Online Excel training platform"
Good: "Excel mastery in 30 days—in Thai, for Thai offices"

Bad: "AI-powered analytics"
Good: "Turn 8 hours of Excel work into 8 minutes"
```

---

### 4. Solution

**Top 3 features that solve the problems**

Match features to problems. Don't overbuild.

| Problem | Solution |
|---------|----------|
| Problem 1 | Feature that solves it |
| Problem 2 | Feature that solves it |
| Problem 3 | Feature that solves it |

**Tips:**
- Minimum viable features
- Bind to specific problems
- Demo > Description

**Example:**
```
Problem: Hours on repetitive tasks
Solution: Pre-built templates + Power Query automation

Problem: Can't create reports
Solution: Step-by-step dashboard course

Problem: Don't know Excel capabilities
Solution: Structured learning path with assessments
```

---

### 5. Channels

**Path to customers**

| Phase | Free/Inbound | Paid/Outbound |
|-------|--------------|---------------|
| **Awareness** | SEO, content, social | Ads, PR |
| **Acquisition** | Website, landing pages | Sales, events |
| **Activation** | Free trial, demo | Onboarding call |

**Tips:**
- Focus on free channels first
- Build for channel (not just product)
- Early adopter channels may differ

---

### 6. Revenue Streams

**How you make money**

| Element | Description |
|---------|-------------|
| **Revenue Model** | How you charge (subscription, one-time, etc.) |
| **Lifetime Value (LTV)** | Total revenue per customer |
| **Gross Margin** | Revenue - Cost of Goods Sold |

**Tips:**
- Price based on value, not cost
- Test pricing early
- Multiple streams add complexity

---

### 7. Cost Structure

**What it costs to operate**

| Cost Type | Examples |
|-----------|----------|
| **Fixed** | Salaries, rent, hosting |
| **Variable** | CAC, payment processing |

**Key Metrics:**
- **Customer Acquisition Cost (CAC)** - Cost to acquire one customer
- **Burn Rate** - Monthly cash spend

---

### 8. Key Metrics

**How you measure success**

Use pirate metrics (AARRR):

| Metric | Question |
|--------|----------|
| **Acquisition** | How do users find you? |
| **Activation** | Do they have a great first experience? |
| **Retention** | Do they come back? |
| **Revenue** | Do they pay? |
| **Referral** | Do they tell others? |

**Tips:**
- Focus on 1-2 metrics at each stage
- Actionable > Vanity metrics

---

### 9. Unfair Advantage

**Something that can't be easily copied or bought**

| True Unfair Advantage | Not Unfair Advantage |
|----------------------|---------------------|
| Insider information | First mover (easily copied) |
| Unique expertise | Features (can be built) |
| Personal authority | Low price (can be matched) |
| Network effects | Passion (not defensible) |
| Community | Domain knowledge (can be hired) |
| Existing customers | |

**Tips:**
- Most startups start with "none" here
- Build toward it
- Be honest—this is hard

---

## Example: ThepExcel Lean Canvas

```markdown
### Customer Segments
Target: Thai office workers wanting data skills
Early Adopters: Executive assistants, junior analysts

### Problem
1. Hours wasted on manual data tasks
2. Boss asks for reports they can't create
3. No structured Thai-language learning path
Alternatives: YouTube, expensive classroom, asking colleagues

### Unique Value Proposition
"Excel mastery in 30 days—in Thai, for Thai offices"

### Solution
1. Power Query automation course
2. Dashboard building workshop
3. Structured learning path with projects

### Channels
- YouTube (awareness)
- SEO/Content (acquisition)
- Facebook ads (scaling)

### Revenue Streams
- Course sales: ฿2,990/course
- LTV: ฿6,000 (avg 2 courses)
- Gross Margin: 85%

### Cost Structure
- Content production: ฿50,000/course
- CAC: ฿300 (target)
- Hosting/tools: ฿10,000/month

### Key Metrics
- Acquisition: Website visitors, signups
- Activation: Course starts, lesson completion
- Retention: Course completion, repeat purchase
- Revenue: MRR, ARPU

### Unfair Advantage
- 15+ years Excel expertise
- Existing audience (YouTube + Facebook)
- Thai business context examples
```

---

## Lean Canvas vs BMC

| Lean Canvas | Business Model Canvas |
|-------------|----------------------|
| Problem | (not explicit) |
| Solution | Value Proposition (partial) |
| Key Metrics | (not explicit) |
| Unfair Advantage | (not explicit) |
| (not explicit) | Key Partners |
| (not explicit) | Key Activities |
| (not explicit) | Key Resources |
| (not explicit) | Customer Relationships |
