# Value Proposition Canvas (VPC)

Created by Alexander Osterwalder, an extension of the Business Model Canvas. Published in "Value Proposition Design" (2014).

## Canvas Structure

The VPC zooms into two blocks of the Business Model Canvas:
- Customer Segments → **Customer Profile**
- Value Propositions → **Value Map**

```
┌─────────────────────────────────────────────────────────────────────┐
│                                                                     │
│     VALUE MAP                              CUSTOMER PROFILE         │
│                                                                     │
│    ┌─────────────┐                        ┌─────────────┐          │
│    │  Products   │                        │    Gains    │          │
│    │     &       │                        │             │          │
│    │  Services   │                        │  Benefits   │          │
│    │             │                        │  customers  │          │
│    │             │                        │    want     │          │
│    ├─────────────┤       ══════           ├─────────────┤          │
│    │    Gain     │       ══FIT══          │    Jobs     │          │
│    │  Creators   │       ══════           │             │          │
│    │             │                        │  Tasks to   │          │
│    │   How we    │                        │  complete   │          │
│    │   create    │                        │             │          │
│    │   gains     │                        │             │          │
│    ├─────────────┤                        ├─────────────┤          │
│    │    Pain     │                        │    Pains    │          │
│    │  Relievers  │                        │             │          │
│    │             │                        │ Frustrations│          │
│    │   How we    │                        │   risks     │          │
│    │   relieve   │                        │  obstacles  │          │
│    │   pains     │                        │             │          │
│    └─────────────┘                        └─────────────┘          │
│                                                                     │
└─────────────────────────────────────────────────────────────────────┘
```

---

## Customer Profile (Right Side)

### Jobs to Be Done

**What is the customer trying to accomplish?**

| Job Type | Description | Examples |
|----------|-------------|----------|
| **Functional** | Practical tasks | "Analyze sales data", "Create report" |
| **Social** | How they want to be perceived | "Look competent", "Be the expert" |
| **Emotional** | How they want to feel | "Feel confident", "Reduce stress" |
| **Supporting** | Buying, co-creating, transferring | "Compare options", "Learn to use" |

**Questions:**
- What tasks are they trying to complete?
- What problems are they trying to solve?
- What needs are they trying to satisfy?

**Tips:**
- Use customer's words, not yours
- Distinguish between main job and related jobs
- Consider context and constraints

---

### Pains

**What annoys customers or prevents success?**

| Pain Type | Description | Examples |
|-----------|-------------|----------|
| **Undesired outcomes** | Problems and bad results | "Report has errors", "Wastes time" |
| **Obstacles** | Things preventing the job | "Too complex", "No training" |
| **Risks** | Potential negative outcomes | "Might look incompetent", "Could lose data" |

**Questions:**
- What's too costly? (time, money, effort)
- What makes them feel bad?
- What common mistakes do they make?
- What barriers prevent adoption?

**Rank pains:** Extreme → Moderate

---

### Gains

**What outcomes and benefits do customers want?**

| Gain Type | Description | Examples |
|-----------|-------------|----------|
| **Required** | Basic expectations | "It works", "It's accurate" |
| **Expected** | Standard expectations | "Easy to use", "Good support" |
| **Desired** | Would love to have | "Saves 50% time", "Looks professional" |
| **Unexpected** | Beyond expectations | "Makes me look like expert", "Fun to use" |

**Questions:**
- What would make their life easier?
- What would delight them?
- What do they dream about?
- How do they measure success?

**Rank gains:** Essential → Nice to have

---

## Value Map (Left Side)

### Products & Services

**What do you offer?**

List all products and services your value proposition is built around.

| Category | Examples |
|----------|----------|
| **Physical** | Products, goods |
| **Intangible** | Services, support |
| **Digital** | Software, apps, content |
| **Financial** | Insurance, financing |

**Rank:** Essential → Nice to have

---

### Pain Relievers

**How do you alleviate customer pains?**

Map each pain reliever to specific customer pains.

| Pain | Pain Reliever |
|------|---------------|
| "Takes too long" | "Automates 80% of work" |
| "Too complex" | "Step-by-step guidance" |
| "Might make mistakes" | "Built-in error checking" |

**Questions:**
- How do you save time, money, effort?
- How do you eliminate/reduce fears?
- How do you fix underperformance?
- How do you eliminate risks?

---

### Gain Creators

**How do you create customer gains?**

Map each gain creator to specific customer gains.

| Gain | Gain Creator |
|------|--------------|
| "Save time" | "Templates reduce work by 50%" |
| "Look competent" | "Professional output" |
| "Feel confident" | "Certification included" |

**Questions:**
- How do you create outcomes they expect/desire?
- How do you exceed expectations?
- How do you make their life easier?
- How do you create positive social consequences?

---

## Achieving FIT

FIT happens when customers get excited about your value proposition.

### Three Levels of Fit

| Level | Description | Evidence |
|-------|-------------|----------|
| **Problem-Solution Fit** | Evidence that jobs, pains, gains matter | Customer interviews confirm problems |
| **Product-Market Fit** | Evidence customers want your solution | Customers pay, return, refer |
| **Business Model Fit** | Evidence of scalable, profitable model | Unit economics work |

### Fit Checklist

- [ ] Value proposition addresses most important jobs
- [ ] Value proposition addresses most severe pains
- [ ] Value proposition creates essential gains
- [ ] Customers willing to pay for the value
- [ ] Value is differentiated from alternatives

---

## Example: ThepExcel VPC

### Customer Profile: Executive Assistant "Nida"

```markdown
### Jobs to Be Done
**Functional:**
- Create monthly reports for management
- Consolidate data from multiple sources
- Analyze sales trends

**Social:**
- Be seen as the "Excel expert" in the office
- Get recognized for efficiency

**Emotional:**
- Feel confident when presenting data
- Reduce stress from tight deadlines

### Pains
**Extreme:**
- Spends 8+ hours on monthly reports
- Errors in formulas embarrass her
- Boss asks for things she doesn't know how to do

**Moderate:**
- Boring, repetitive work
- No one to ask for help

### Gains
**Required:**
- Accurate reports
- Meet deadlines

**Desired:**
- Finish reports in 2 hours, not 8
- Create professional dashboards
- Understand data, not just copy it

**Unexpected:**
- Become the trainer for colleagues
- Get promoted based on skills
```

### Value Map: ThepExcel Power Query Course

```markdown
### Products & Services
- Power Query automation course (10 hours)
- 50+ downloadable templates
- Facebook community access
- Certificate of completion

### Pain Relievers
| Pain | How We Relieve |
|------|----------------|
| 8+ hours on reports | Automation reduces to 30 min |
| Formula errors | Template-based, tested solutions |
| Don't know how | Step-by-step Thai instruction |
| No one to ask | Community support |

### Gain Creators
| Gain | How We Create |
|------|---------------|
| Finish faster | Power Query automates 90% |
| Professional dashboards | Ready-to-use templates |
| Become trainer | Certification + shareable skills |
| Get promoted | Portfolio of projects |
```

### FIT Assessment

```
✅ Addresses #1 job: Create reports efficiently
✅ Relieves #1 pain: 8 hours → 30 minutes
✅ Creates desired gain: Professional output
✅ Differentiated: Thai language, Thai business context
⚠️ To validate: Willingness to pay ฿2,990
```

---

## Tips for Using VPC

1. **One segment at a time** - Create separate canvas for each segment
2. **Customer interviews first** - Don't guess, ask
3. **Rank everything** - Not all jobs/pains/gains are equal
4. **Focus on important** - Address top 3, not all
5. **Iterate** - Update based on feedback
6. **Connect to BMC** - VPC feeds into value proposition block
