# Sources & Attribution

## Methodology Influences

### Teaching & Learning Theory
| Concept | Source |
|---------|--------|
| Feynman Technique | Richard Feynman - "Learn by teaching" approach |
| Socratic Method | Classical philosophy, dialogue-based learning |
| Scaffolding | Vygotsky's Zone of Proximal Development |
| Analogical Reasoning | Cognitive science research |

### Explanation Strategies
| Strategy | Source |
|----------|--------|
| ELI5 (Explain Like I'm 5) | Reddit community, simplified explanations |
| Concrete → Abstract | Educational psychology best practices |
| Multiple Representations | Howard Gardner's Multiple Intelligences |
| Visual Learning | Dual Coding Theory (Allan Paivio) |

### Visualization Integration
| Tool | Purpose |
|------|---------|
| Manim | Mathematical animations (3Blue1Brown) |
| Diagrams | Conceptual relationships |
| Examples | Concrete understanding |

## Key References

- Feynman, R. - Teaching methodology
- [3Blue1Brown](https://www.3blue1brown.com/) - Visual math explanations
- Cognitive Load Theory - John Sweller
- Universal Design for Learning (UDL)

## Developed by ThepExcel

- Master teaching persona and voice
- Thai language adaptations
- Integration with create-visualization skill
- Session summary generation
- Adaptive difficulty levels

---

*This skill synthesizes best practices from education, cognitive science, and visual communication.*
