# Content Creator Ideation

Systematic ideation workflows for bloggers, YouTubers, course creators, and trainers.

---

## Content Pillars

Define 3-5 core themes reflecting expertise + audience needs.

**Choosing pillars:**
- Audience needs and search intent
- Your unique expertise and insights
- Cluster potential (can branch into subtopics)
- Evergreen relevance over short-term trends

**Content type matrix** (apply to each pillar):
- **Inspire** -- motivate your audience
- **Educate** -- teach something valuable
- **Engage** -- start conversations
- **Promote** -- sell products/services

---

## Audience-First Research

### Sources of Audience Data

| Source | What it reveals |
|--------|----------------|
| Comments & DMs | Real language, specific frustrations |
| Forum discussions | Recurring questions, knowledge gaps |
| Course/product reviews | What's missing, what's confusing |
| Support tickets | Common problems, edge cases |
| Search queries | Demand signals, intent |
| Sales call objections | Barriers to purchase |

### Pain Point Discovery Questions

1. What are their biggest frustrations?
2. What questions do they repeatedly ask?
3. What do they wish existed but doesn't?
4. What mistakes do they commonly make?
5. What would save them the most time/money?

---

## Blog Post Ideation

### Headline Formulas

| Type | Formula |
|------|---------|
| How-to | "How to [Achieve Outcome] in [Timeframe]" |
| Listicle | "[Number] Ways to [Solve Problem]" |
| Comparison | "[A] vs [B]: Which is Better for [Use Case]?" |
| Case study | "How [Person] Achieved [Result] with [Method]" |
| Question | "Why Does [Problem] Happen? (And How to Fix It)" |

### Topic Cluster Approach

1. Choose broad pillar topic
2. Identify 4-8 cluster subtopics per pillar
3. Create content for each cluster topic
4. Connect with internal links back to pillar page

---

## YouTube / Video Ideation

### Title + Thumbnail First

Design title and thumbnail BEFORE filming:

1. Draft 2-3 title options
2. Sketch thumbnail concepts that reinforce each title's promise
3. Write hook script to validate the tension
4. Test alignment: Do title, thumbnail, and hook tell the same story?

### The "Would I Click This?" Test

- Would YOU click on this title + thumbnail?
- Does it create a clear curiosity gap?
- Would you feel satisfied (not deceived) after watching?
- Is there a clear payoff promise?

### Thumbnail Best Practices

- Maximum 3-5 high-impact words (hook, not summary)
- Power words: "Secret," "Warning," "Biggest," "Finally"
- Don't repeat the title -- add new information
- Use contrast elements (before/after)

### Video Pillars

Pick 3-5 types: Tutorials, Behind-the-scenes, Deep-dives, Storytelling, FAQs, Success breakdowns

---

## Course / Training Ideation

### From Pain Points to Curriculum

1. **Discover needs:** Survey, interviews, social listening
2. **Identify struggles:** What do students struggle with most?
3. **Set SMART objectives:** Transform pain points into measurable outcomes
4. **Design experience:** Full learner journey, not just topic outline

### Skill Gap Analysis

1. Map current skills of your audience
2. Map skills they need for their goals
3. Gap = course opportunity
4. Prioritize by: urgency, demand, your unique expertise

### Module Brainstorming

- Mind map from learning outcomes
- Reverse engineer from desired end state
- Design workshops with potential learners
- Apply SCAMPER to existing courses in your niche

---

## Content Gap Analysis

### Three Types of Gaps

1. **Uncovered topic** -- audience has questions but nobody answers
2. **Poorly explained** -- competitors cover it but lack examples/context
3. **Misaligned** -- content exists but targets wrong audience or angle

### Finding Gaps

- Focus on unanswered questions: "What does this look like in practice?"
- Check format gaps (maybe video exists but no written guide)
- Check buyer journey stages (awareness exists but no comparison guides)
- Use AI to analyze support tickets and search logs

---

## Content Repurposing

### COPE Framework: Create Once, Publish Everywhere

| Original | Repurpose Into |
|----------|---------------|
| Blog post | Carousel, LinkedIn post, Twitter thread, email, video, podcast |
| YouTube video | Shorts/Reels, blog post, quote graphics, email |
| Webinar/Live | Blog post, social clips, Q&A article, guide |
| Podcast | Blog takeaways, audio clips, graphic summaries |
| Course module | Blog series, YouTube tutorial, social tips, lead magnet |

**Best practices:**
- Start with best-performing content for repurposing
- Build repurposing into workflow from the start
- Aim for at least 5 social posts from every long-form piece
- Focus on 2-3 channels rather than mediocre presence on 5+

---

## Validation Checklist

Before committing resources to create content:

```
[ ] Search demand? (keyword research)
[ ] Real audience pain point? (surveys, comments)
[ ] Can I add unique value? (gap analysis)
[ ] Fits my content pillars? (strategy alignment)
[ ] Would I click this? (title/thumbnail test)
[ ] Can be repurposed? (ROI maximization)
```

---

## Practical Systems

### Idea Capture

- ONE system for all ideas (Notion, Obsidian, etc.)
- Quick capture from any device
- Swipe file for inspiration (save with tags)
- Return later to expand with fresh eyes

### Weekly Ritual

- 15-45 minutes weekly dedicated to brainstorming
- Treat as critical workflow, not "when stuck"
- Continuously capture ideas even outside brainstorming time

### Monthly Batching

- Block one day/month to plan next 4 weeks
- Select ideas from running list
- Map to calendar with publish dates
- Build repurposing into calendar from the start

---

## AI-Assisted Content Ideation Warnings

- **Homogenization is real:** Only 6% of AI-generated ideas were unique vs 100% in human-only groups
- **Individual gain, collective loss:** AI improves individual creativity but reduces collective diversity
- **Start human, layer AI:** Brainstorm first, then use AI to expand
- **Use multiple models:** Greater variety than single model
- **Don't mistake fluency for originality:** Well-written != innovative
