# Idea Development Pipeline

From raw ideas to actionable plans. Frameworks for refining, validating, and executing creative ideas.

---

## End-to-End Pipeline

```
[Discover] -> [Ideate] -> [Cluster] -> [Evaluate] -> [Develop] -> [Validate] -> [Execute]
```

| Phase | Goal | Key Techniques |
|-------|------|---------------|
| Discover | Understand the problem | User research, HMW questions, stakeholder interviews |
| Ideate | Generate many options | Brainstorming, SCAMPER, Mind Map, Brainwriting (aim 50-100+) |
| Cluster | Find patterns | Affinity Mapping, Idea Clustering |
| Evaluate | Select best candidates | NAF, Dot Voting, Impact/Effort Matrix |
| Develop | Shape into concepts | Concept Card, Assumption Mapping |
| Validate | Test assumptions | Quick prototypes, landing pages, user tests |
| Execute | Build and launch | Build-Measure-Learn (but Learn first!) |

---

## Concept Development

### Quick Concept Card

For each promising idea, fill in:

```
IDEA: [Name]
TAGLINE: [One compelling sentence]
PROBLEM: [What pain it solves]
SOLUTION: [How it works - 2-3 sentences]
TARGET USER: [Who benefits]
KEY INSIGHT: [The "aha" behind this]
EFFORT: [S / M / L]
BIGGEST RISK: [What could go wrong]
QUICKEST TEST: [How to validate cheaply]
NEXT STEP: [One concrete action]
```

### Opportunity Canvas (for bigger ideas)

| Section | Question |
|---------|----------|
| Problem/Need | What pain exists? |
| Users/Customers | Who is affected? |
| Solution ideas | How might it work? |
| User value | How does it help users? |
| Business value | How does it help the company? |
| Metrics | How do we measure success? |
| Adoption strategy | How will users discover and start using it? |
| Constraints | Budget, timeline, technical limits? |

**Key distinction:** Opportunity Canvas works at feature level (lighter than Business Model Canvas).

---

## Assumption Mapping

The most important refinement technique. Test your riskiest assumptions first.

### Process

1. **Identify:** "What must be true for this idea to work?"
2. **Write hypotheses:** "We believe that..."
3. **Map on 2x2:**
   - X-axis: Certainty (low to high)
   - Y-axis: Importance (low to high)
4. **Test top-right quadrant first:** High importance + Low certainty = riskiest

### Four Categories

| Category | Key Question |
|----------|-------------|
| Desirability | Do users want this? |
| Feasibility | Can we build this? |
| Viability | Can this make money? |
| Adaptability | Can this survive change? |

### Validation Methods

| Assumption Type | Test Method |
|----------------|-------------|
| Desirability | User interviews, surveys |
| Feasibility | Prototyping, technical spike |
| Viability | Landing page, pre-orders |
| Market fit | MVP, concierge test |

---

## Quick Prototyping

| Type | Best For |
|------|----------|
| Paper sketch | Initial concept visualization |
| Landing page | Demand validation |
| Clickable prototype (Figma) | Usability testing |
| Concierge (manual delivery) | Service feasibility |
| Wizard of Oz (fake backend) | Full experience testing |
| Explainer video | Testing demand (a la Dropbox) |

---

## Prioritization Methods

### ICE Scoring

```
Score = Impact x Confidence x Ease (each 1-10)
```

Best for: Quick experiments, growth hacking

### RICE Scoring

```
Score = (Reach x Impact x Confidence) / Effort
```

Best for: Data-driven product roadmap

### MoSCoW

| Category | Meaning | Effort Budget |
|----------|---------|---------------|
| Must have | Critical | ~60% |
| Should have | Important | ~20% |
| Could have | Nice to have | ~20% |
| Won't have | Out of scope | Documented |

Best for: Fixed-deadline projects, MVP scoping

### When to Use Which

| Situation | Method |
|-----------|--------|
| Quick team workshop | Impact/Effort Matrix |
| Growth experiments | ICE |
| Data-driven roadmap | RICE |
| Fixed deadline / MVP | MoSCoW |
| Complex multi-criteria | Weighted Scoring |
| Combining methods | RICE to score + MoSCoW to categorize |

---

## Execution Frameworks

### Learn-Build-Measure (corrected Lean Startup)

**Important:** Don't start building before researching. Flip the loop:

```
LEARN (validate assumptions) -> BUILD (MVP) -> MEASURE (data) -> repeat
```

### Stage-Gate Process

```
Ideation -> Screening -> Concept Dev -> Business Case -> Development -> Launch
  Gate 0     Gate 1       Gate 2        Gate 3          Gate 4       Gate 5
```

Each gate = go/no-go decision based on evidence.

### Test Card (for each assumption)

```
HYPOTHESIS: We believe [X]
TEST: We will test by [method]
METRIC: We will measure [what]
CRITERIA: We are right if [threshold]
```

---

## Technique Combination Recipes

### "I need a breakthrough"

```
1. HMW Reframing → Frame as opportunity
2. Worst Possible Idea → Break mental blocks
3. SCAMPER → Systematically twist concepts
4. Brainwriting 6-3-5 → Build on wild ideas
5. Dot Voting → Surface favorites
6. Concept Card → Develop top 3
```

### "I need to improve something"

```
1. SCAMPER → Modify existing product/process
2. Reverse Brainstorm → "How to make worse?" then flip
3. Affinity Mapping → Cluster improvements
4. Impact/Effort Matrix → Prioritize
5. Action Planning → Assign and execute
```

### "I need many diverse options"

```
1. Mind Mapping → Free-associate
2. Round-Robin → Each person adds one idea
3. Random Word → Force unexpected connections
4. Brainwriting → Silent parallel generation
5. Clustering → Group the mass
6. Multi-Voting → Narrow to top 10-15
```

### "I need to validate an idea"

```
1. Assumption Mapping → Find riskiest assumptions
2. Test Card → Design experiment
3. Quick Prototype → Build minimal version
4. User Test → 5 users reveals 85% of issues
5. Learn → Pivot or persevere
```
