# AI Prompt Templates for Creativity

Ready-to-use prompt patterns for each ideation technique.

---

## SCAMPER

### All-in-One

```
Apply the SCAMPER framework to [PRODUCT/SERVICE/IDEA]:

1. SUBSTITUTE: What components, materials, or processes could we replace?
2. COMBINE: What ideas, features, or products could we merge?
3. ADAPT: What could we copy or borrow from another industry?
4. MODIFY: What could we enlarge, shrink, change shape, or alter?
5. PUT TO ANOTHER USE: What else could this be used for? New markets?
6. ELIMINATE: What could we remove, simplify, or reduce?
7. REVERSE: What if we did the opposite? Reversed the process?

For each, generate 3 specific, actionable ideas.
```

### Individual Lenses

- "What can I replace in [idea] to make it different or better?"
- "What two things could I combine to make something new?"
- "How could I adapt this to work in a completely different context?"
- "What if I eliminated the most expensive/complex part entirely?"
- "What would happen if I reversed the entire process?"

---

## First Principles

```
Using First Principles thinking, analyze [TOPIC/PROBLEM]:

1. What are the fundamental truths about this problem?
   Strip away all assumptions and conventions.
2. What do we assume that might not be true?
3. If we built a solution from scratch knowing only the
   fundamental truths, what would it look like?
4. What would be radically different from today's approach?

Generate 5 ideas from this first-principles analysis.
```

---

## Reverse Brainstorming

```
Let's use reverse brainstorming for [GOAL]:

1. Instead of "How do we succeed?", answer:
   "How could this SPECTACULARLY fail?"
2. List 10 ways to guarantee failure
3. Now reverse each failure point into a success strategy
4. Which reversed strategies are most surprising or novel?
```

---

## Analogical Thinking

### Cross-Domain

```
Before answering, please:
1. Think of 3 similar problems from completely different domains
2. Explain how each was solved
3. Now apply those solution patterns to my problem:
[YOUR PROBLEM]
```

### Industry Crossover

```
How would [Nintendo/Netflix/IKEA/SpaceX] design a solution
for [YOUR PROBLEM]?

Consider their core principles:
- [Known principles of that company]

Generate 3 concrete ideas based on this analogy.
```

---

## Multi-Persona Parallel

### Panel Discussion

```
Solve [problem] from 4 perspectives simultaneously:
1. Skeptical engineer (feasibility)
2. Customer experience designer (delight)
3. Cost-optimizer (efficiency)
4. 10-year-old child (simplicity/fun)

Give each 2-3 distinct ideas. DO NOT let one persona
influence another.
```

### Famous Person Rolestorming

```
What would [Elon Musk / Steve Jobs / Marie Curie] do?

If they were tackling [PROBLEM], what approach would they take?
Consider their known philosophy and decision-making style.
Generate 3 ideas this person would likely propose.
```

---

## Constraint Injection

```
# Budget constraint
"If we had only $100 to solve [PROBLEM], what would we do?"

# Time constraint
"We have 48 hours to launch. What's the simplest thing that works?"

# Technology constraint
"Solve [PROBLEM] using only technology available in 1990."

# Audience constraint
"Design [PRODUCT] so a 5-year-old could use it."

# Extreme constraint
"If our budget were cut by 80% but we still had to meet objectives?"
```

---

## Divergence Guard

When AI ideas start looking too similar:

```
Your previous ideas share these patterns: [X, Y, Z].
Now generate 5 MORE ideas that:
- Are as DIFFERENT from each other as possible
- Come from domains we haven't considered
- Include at least one that sounds absurd
- Challenge one assumption we haven't questioned
```

---

## Tree of Thoughts

For complex creative problems (74% success vs CoT 49%):

```
Explore [PROBLEM] using multiple reasoning paths:

Path A: The conventional approach -- what would most experts suggest?
Path B: The contrarian approach -- what if the opposite is true?
Path C: The adjacent approach -- what if we solve a different but related problem?
Path D: The moonshot approach -- what if constraints didn't exist?

For each path, develop 2-3 concrete ideas.
Then identify which ideas from different paths could be combined.
```

---

## Combinatorial Engine

```
Let's use combinatorial creativity for [PROBLEM]:

1. ABSTRACT: What is the core function? (e.g., "move people" not "better bus")
2. RETRIEVE: How do these 3 domains solve similar functions?
   - Nature: [domain]
   - Military: [domain]
   - Entertainment: [domain]
3. GENERALIZE: What transferable principles emerge?
4. COMBINE: Create 3 novel configurations by mixing principles
5. INSTANTIATE: Make each concrete for our context
```

---

## Creativity-Boosting Patterns

### "Surprise Me" Framing

```
Generate 10 ideas for [TOPIC] that would surprise me:
- 3 that combine things nobody would think to combine
- 3 that challenge a fundamental assumption
- 2 inspired by a completely unrelated industry
- 2 that are the OPPOSITE of what most people would suggest
```

### Tabula Rasa (Clean Slate)

```
If we were to start [INDUSTRY/PRODUCT] from scratch today,
with all modern tools available, what would it look like?
Ignore all existing conventions.
```

### Future-Back Thinking

```
It's 2030. [COMPANY/PRODUCT] is the undisputed market leader.
Describe the breakthrough idea that got you there and
reverse-engineer the steps it took.
```

### Controlled Hallucination (~30% survive feasibility)

```
Speculate freely and creatively about [TOPIC].
Don't worry about current feasibility -- imagine what COULD exist.
Then, for each speculative idea, rate feasibility 1-5
and suggest what would need to be true for it to work.
```

### Process Over Product (Nature 2026 -- key finding)

```
DON'T: "Give me ideas for X"
DO: "What frameworks or mental models can I use to
    think about X from multiple angles?"
```

This single shift causes human creativity scores to skyrocket.

---

## Anti-Patterns to Avoid

| Anti-Pattern | Why It Fails | Better Alternative |
|---|---|---|
| "Give me ideas for X" | Too vague, AI defaults to common patterns | "10 ideas that would surprise an expert" |
| "Be creative" | Meaningless instruction | Use specific technique (SCAMPER, constraints) |
| Accept first outputs | First ideas are AI's "greatest hits" | Push past 2-3 rounds |
| Superlatives ("smartest person ever") | No effect on output quality | Specific expertise: "20-year veteran designer" |
| Showing anti-patterns | Less effective than positive examples | Show examples of what you DO want |
| Over-constraining | Stifles creativity | Generate freely first, filter second |
| Leading questions | Confirmation bias | "Arguments for AND against X?" |
