# Creativity Techniques Reference

Step-by-step guides for each technique.

## Table of Contents

1. [SCAMPER](#scamper)
2. [Random Word Association](#random-word-association)
3. [Reverse Brainstorming](#reverse-brainstorming)
4. [First Principles Thinking](#first-principles-thinking)
5. [Six Thinking Hats](#six-thinking-hats)
6. [How Might We (HMW)](#how-might-we-hmw)
7. [Morphological Box](#morphological-box)
8. [Analogical Thinking](#analogical-thinking)
9. [Challenging Assumptions](#challenging-assumptions)
10. [Forced Connections](#forced-connections)
11. [6-3-5 Brainwriting](#6-3-5-brainwriting)
12. [Oblique Strategies](#oblique-strategies)
13. [Jobs to be Done](#jobs-to-be-done)
14. [Incubation Cycling](#incubation-cycling) *(NEW 2025)*
15. [Combinatorial Creativity Engine](#combinatorial-creativity-engine) *(NEW 2025)*
16. [Constraint Injection Protocol](#constraint-injection-protocol) *(NEW 2025)*
17. [Multi-Persona Parallel](#multi-persona-parallel) *(NEW 2025)*
18. [TRIZ-AI Quick Method](#triz-ai-quick-method) *(NEW 2025)*
19. [Divergence Guard](#divergence-guard) *(NEW 2025)*

---

## SCAMPER

**Origin:** Alex Osborn, Bob Eberle
**Best for:** Improving existing products/processes

### The 7 Lenses

| Letter | Question | Examples |
|--------|----------|----------|
| **S**ubstitute | What can be replaced? | Materials, people, rules, processes |
| **C**ombine | What can be merged? | Features, functions, products |
| **A**dapt | What can be borrowed from elsewhere? | Ideas from other industries |
| **M**odify | What can be changed? | Size, shape, color, frequency |
| **P**ut to other use | What else could this do? | New markets, new users |
| **E**liminate | What can be removed? | Features, steps, components |
| **R**everse/Rearrange | What if order changed? | Sequence, layout, hierarchy |

### Process

1. Define the product/process to improve
2. Go through each letter systematically
3. Ask 2-3 questions per letter
4. Record ALL ideas (no judgment)
5. Review and select best ideas

### Example: Improving a Coffee Shop

- **Substitute**: Replace baristas with AI ordering? Use oat milk as default?
- **Combine**: Coffee + coworking space? Coffee + book club?
- **Adapt**: Drive-thru model from fast food? Subscription from Netflix?
- **Modify**: Make cups larger? Open 24 hours?
- **Put to other use**: Rent space for events? Sell coffee beans wholesale?
- **Eliminate**: Remove menus (only 3 drinks)? Remove tables (takeaway only)?
- **Reverse**: Customers make their own coffee? Pay-what-you-want?

---

## Random Word Association

**Origin:** Edward de Bono (Lateral Thinking)
**Best for:** Breaking mental fixation

### Process

1. **State the problem** clearly
2. **Pick a random noun** (use word bank below or dictionary)
3. **List 5-6 attributes** of that word
4. **Force connections** between each attribute and problem
5. **Develop** promising connections into ideas

### Word Bank (Random Selection)

Concrete nouns work best:
- Nature: tree, river, mountain, fish, bird, storm, desert, ocean
- Objects: bridge, mirror, clock, hammer, key, wheel, ladder, door
- Animals: elephant, spider, ant, eagle, shark, butterfly, wolf
- Places: airport, hospital, playground, kitchen, library, stadium

### Example: "How to increase customer loyalty?"

Random word: **Spider**

| Attribute | Connection to loyalty |
|-----------|----------------------|
| Webs | Create interconnected benefits that trap customers (in a good way) |
| 8 legs | Multiple touchpoints with customer |
| Patient | Reward long-term customers, not just new ones |
| Sticky silk | Make switching costs high (data, history, rewards) |
| Catches prey | Actively capture attention vs. waiting passively |

---

## Reverse Brainstorming

**Best for:** Finding hidden risks, uncovering opportunities

### Process

1. **Define the goal** (what you want to achieve)
2. **Reverse it** ("How could we make this WORSE?")
3. **Brainstorm** all ways to cause the problem
4. **Invert** each negative idea into a positive solution
5. **Evaluate** the inverted solutions

### Example: "How to improve customer service?"

**Reversed:** "How to make customer service TERRIBLE?"

| Ways to Make It Worse | Inverted Solution |
|----------------------|-------------------|
| Never answer the phone | Guarantee answer within 3 rings |
| Transfer customers 10 times | One person handles issue end-to-end |
| Use confusing jargon | Plain language policy |
| Make them repeat their problem | CRM shows full history |
| Blame the customer | Own the problem, apologize first |

---

## First Principles Thinking

**Origin:** Aristotle, popularized by Elon Musk
**Best for:** Breakthrough innovation, challenging "impossible" problems

### Elon Musk's 3-Step Framework

1. **Identify assumptions** - What does everyone believe?
2. **Break down to fundamentals** - What are the basic truths?
3. **Rebuild from scratch** - What new solution emerges?

### Process

1. State the problem
2. List all assumptions (things people accept as true)
3. Question each: "Is this actually true? Why?"
4. Identify the fundamental components/truths
5. Rebuild a solution from those fundamentals only

### Example: SpaceX Rockets

**Problem:** Rockets cost $65M, space exploration too expensive

**Assumptions:**
- You have to buy rockets from manufacturers
- Rockets are disposable (one-time use)
- Rocket technology is mature, can't be improved

**First Principles:**
- Rockets are made of: aluminum, titanium, copper, carbon fiber
- Raw material cost: ~2% of rocket price
- Physics allows rockets to land and be reused

**Rebuilt Solution:**
- Build rockets in-house (10x cheaper)
- Make rockets reusable (100x cheaper per launch)

---

## Six Thinking Hats

**Origin:** Edward de Bono
**Best for:** Balanced group thinking, avoiding conflict

### The 6 Hats

| Hat | Focus | Questions |
|-----|-------|-----------|
| **White** (Facts) | Information | What data do we have? What's missing? |
| **Red** (Feelings) | Emotions | How do I feel? What's my gut reaction? |
| **Black** (Caution) | Risks | What could go wrong? What are the dangers? |
| **Yellow** (Benefits) | Optimism | What are the benefits? What's the best case? |
| **Green** (Creativity) | Ideas | What alternatives exist? What's new? |
| **Blue** (Process) | Control | What's our process? What should we do next? |

### Process

1. Everyone wears the same hat at the same time
2. Spend 2-5 minutes per hat
3. Blue hat starts and ends the session
4. Suggested order: Blue → White → Green → Yellow → Black → Red → Blue

### Example: "Should we launch a new product line?"

- **Blue**: Define scope, set time limits
- **White**: Market size $2B, competitors: 5 major, our market share: 12%
- **Green**: Could bundle with existing products, subscription model, B2B version
- **Yellow**: First mover advantage, brand extension, revenue diversification
- **Black**: Cannibalize existing sales, stretch resources, brand dilution risk
- **Red**: Excited but nervous, feels rushed
- **Blue**: Decision: proceed with pilot, review in 90 days

---

## How Might We (HMW)

**Origin:** Procter & Gamble, popularized by IDEO
**Best for:** Reframing problems as opportunities

### Formula

```
"How Might We" + [action verb] + "for" + [user] + "so that" + [outcome]
```

### Good vs. Bad HMW

| Bad HMW | Why Bad | Better HMW |
|---------|---------|------------|
| "How might we redesign the app?" | Too broad | "How might we reduce checkout time for mobile users?" |
| "How might we add a chatbot?" | Embeds solution | "How might we answer customer questions 24/7?" |
| "How might we fix the bug?" | Too narrow | "How might we prevent errors in the order process?" |

### Process

1. Start with user insight/pain point
2. Write 3-5 different HMW framings
3. Choose the one that's not too broad, not too narrow
4. Use as prompt for brainstorming

### Example: Airbnb

**Insight:** Travelers feel like outsiders in new cities

**HMW Options:**
- How might we help travelers feel like locals?
- How might we connect travelers with residents?
- How might we make any place feel like home?

**Result:** "Belong Anywhere" campaign, Experiences feature

---

## Morphological Box

**Origin:** Fritz Zwicky (astronomer)
**Best for:** Systematic exhaustive exploration

### Process

1. **Decompose** problem into 3-5 parameters
2. **List variations** for each parameter (2-5 each)
3. **Create matrix** (parameters × variations)
4. **Combine** one variation from each parameter
5. **Evaluate** interesting combinations

### Example: New Restaurant Concept

| Parameter | Variation 1 | Variation 2 | Variation 3 |
|-----------|-------------|-------------|-------------|
| **Cuisine** | Thai | Italian | Fusion |
| **Price** | Budget | Mid-range | Premium |
| **Format** | Dine-in | Takeaway | Ghost kitchen |
| **Atmosphere** | Family | Romantic | Trendy/Social |

**Possible combinations:**
- Thai + Budget + Ghost kitchen + Trendy = Thai street food delivery brand
- Fusion + Premium + Dine-in + Romantic = Upscale fusion date spot
- Italian + Mid-range + Takeaway + Family = Family Italian takeout

---

## Analogical Thinking

**Best for:** Cross-industry innovation, breakthrough ideas

### Process

1. **Define** the problem abstractly
2. **Identify** analogous domains (nature, other industries)
3. **Research** how they solve similar problems
4. **Transfer** the solution principles
5. **Adapt** to your context

### Domains to Consider

| Domain | Good for | Examples |
|--------|----------|----------|
| **Nature (Biomimicry)** | Efficiency, resilience | Velcro (burrs), bullet train (kingfisher beak) |
| **Military** | Strategy, logistics | Blitzkrieg → Agile sprints |
| **Sports** | Teamwork, performance | Playbooks → Business processes |
| **Entertainment** | Engagement, storytelling | Gamification, narrative marketing |
| **Healthcare** | Precision, safety | Checklists, triage systems |

### Example: Airport → Hospital

**Problem:** Hospital emergency rooms are chaotic

**Analogy:** Airports handle high volume with clarity

**Transferred ideas:**
- Clear signage and wayfinding
- Status boards showing wait times
- "Boarding zones" for different severity levels
- Self-check-in kiosks for minor issues

---

## Challenging Assumptions

**Best for:** Paradigm shifts, disrupting status quo

### Process

1. **State** the problem/situation
2. **List** all assumptions (explicit and implicit)
3. **Challenge** each: "What if this weren't true?"
4. **Invert** promising assumptions
5. **Build** ideas from inverted assumptions

### Common Assumption Categories

- **Industry norms**: "This is how it's always done"
- **Customer beliefs**: "Customers want X"
- **Technical limits**: "It's impossible to..."
- **Business model**: "Revenue comes from..."
- **Time/Space**: "Must be done in person / at this time"

### Example: Hotel Industry → Airbnb

| Assumption | Challenge | Result |
|------------|-----------|--------|
| Hotels own their rooms | What if owners shared their homes? | Host network |
| Professional staff needed | What if hosts did everything? | Peer-to-peer model |
| Standard rooms/amenities | What if each place was unique? | Authentic experiences |
| Fixed pricing | What if hosts set own prices? | Dynamic market |

---

## Forced Connections

**Best for:** Novel combinations, breaking creative blocks

### Process

1. **Define** your challenge
2. **Select** 2 random, unrelated concepts
3. **List** attributes/features of each
4. **Force** connections between them and your challenge
5. **Develop** interesting connections

### Example: "New Fitness App" + "Library" + "Restaurant"

| Library Attribute | Restaurant Attribute | Forced Connection |
|-------------------|---------------------|-------------------|
| Quiet zones | Reservations | Book workout slots in advance |
| Late fees | Menu categories | "Today's special" featured workout |
| Card catalog | Tasting menu | Guided workout sampler |
| Lending period | Chef recommendations | AI suggests workouts like a personal chef |

---

## 6-3-5 Brainwriting

**Best for:** Team ideation, equal participation

### Format

- **6** participants
- **3** ideas each
- **5** minutes per round

### Process

1. Give each person a worksheet
2. State the problem clearly
3. Set timer for 5 minutes
4. Each person writes 3 ideas
5. Pass worksheet to the right
6. Read previous ideas, add 3 more (build on or new)
7. Repeat until worksheets complete full circle
8. Result: 108 ideas in 30 minutes

### Variations

- 4-5 people: fewer ideas but still effective
- Remote: Use shared docs, mute during writing
- Async: Set 24-hour deadline, pass digitally

---

## Oblique Strategies

**Origin:** Brian Eno, Peter Schmidt (1975)
**Best for:** Breaking deadlocks, artistic/creative blocks

### Sample Prompts

Use these when stuck. Pick randomly.

- "What would your closest friend do?"
- "Honor thy error as a hidden intention"
- "What if this was the other way around?"
- "Remove specifics and convert to ambiguities"
- "Do nothing for as long as possible"
- "What is the simplest solution?"
- "Use an old idea"
- "State the problem in words as clearly as possible"
- "What wouldn't you do?"
- "Make a blank valuable by putting it in an exquisite frame"
- "Disconnect from desire"
- "What would make this really easy?"
- "The most important thing is the thing most easily forgotten"
- "Ask your body"
- "What are you really trying to do?"

---

## Jobs to be Done

**Origin:** Clayton Christensen, Tony Ulwick
**Best for:** Understanding true customer needs

### Core Concept

People don't buy products. They "hire" products to do a job.

### The Framework

```
When [situation], I want to [motivation], so I can [expected outcome].
```

### Process

1. **Observe** what customers actually do (not say)
2. **Identify** the job they're trying to get done
3. **Uncover** functional, emotional, social aspects
4. **Find** where current solutions fail
5. **Design** for the job, not the product category

### Example: Milkshake

**Traditional view:** "How do we make a better milkshake?"

**JTBD view:** "What job is the milkshake being hired to do?"

**Research finding:** Morning commuters hire milkshakes to:
- Make boring commute interesting
- Keep them full until lunch
- Be easy to consume one-handed

**Solution:** Thicker shake, longer straw, add-ins for texture

---

## Incubation Cycling

**Origin:** Cognitive science (incubation effect) + LLM adaptation (2024)
**Best for:** Breaking AI self-anchoring, generating truly novel ideas
**Research:** [HBR 2025](https://hbr.org/2025/12/research-when-used-correctly-llms-can-unlock-more-creative-ideas)

### Why It Works

LLMs tend to anchor to their own outputs—each subsequent idea builds on previous ones, leading to convergence. Incubation cycling mimics the human "incubation effect" where stepping away from a problem leads to breakthrough insights.

### Process

1. **First Burst**: Generate 5-10 ideas on the problem
2. **Full Stop**: Completely stop. Do an unrelated task for 2-5 minutes
3. **Fresh Context**: Return WITHOUT looking at previous ideas
4. **Second Burst**: Generate 5-10 NEW ideas from scratch
5. **Compare & Combine**: Now review both sets together
6. **Synthesize**: Create hybrid ideas from the two independent sets

### Example: "How to increase newsletter subscribers?"

**First Burst:**
1. Add popup on homepage
2. Offer free ebook for signup
3. Create referral program
4. Add signup to checkout flow
5. Guest post with author bio links

**[2-minute break - check email, stretch]**

**Second Burst (fresh):**
1. Partner with complementary newsletters for cross-promotion
2. Create a free tool that requires email to save results
3. Host a challenge/course delivered via email
4. Make the newsletter itself shareable with unique link
5. Create "preview mode" showing what subscribers get

**Combined insights:** The second burst often reveals completely different angles (partnerships, product-led, social proof) that wouldn't emerge from the first burst's trajectory.

### Variations

- **Longer incubation**: Overnight gap for major creative challenges
- **Topic shift**: Work on different problem during break (cross-pollination)
- **Persona shift**: Return as different persona for second burst

---

## Combinatorial Creativity Engine

**Origin:** Computational creativity theory + LLM implementation
**Best for:** Systematic breakthrough innovation
**Research:** [arXiv 2024](https://arxiv.org/abs/2412.14141) — +7-10% on novelty metrics

### Core Concept

Most creative breakthroughs are combinations of existing ideas from different domains. This technique systematically applies that insight.

### The 5-Step Process

1. **ABSTRACT**: Strip problem to its core function
   - "I need to move people" not "I need a better bus"
   - "I need to transfer knowledge" not "I need a better textbook"

2. **RETRIEVE**: Find solutions from 3+ distant domains
   - Ask: "How does [nature/military/sports/healthcare/entertainment] solve this?"
   - Look for analogous functions, not similar appearances

3. **GENERALIZE**: Extract transferable principles
   - Not "ants use pheromones" but "leave trails for others to follow"
   - Not "hospitals triage" but "prioritize by severity, not arrival"

4. **COMBINE**: Create novel configurations
   - Principle A + Principle B applied to original problem
   - Mix-and-match from different domains

5. **INSTANTIATE**: Make concrete for your context
   - "Leave trails" → User activity feeds showing what others did
   - "Prioritize by severity" → Support tickets auto-ranked by impact

### Example: "How to reduce customer support load?"

**Abstract:** "Route questions to answers efficiently"

**Retrieve from distant domains:**
- **Airports**: Wayfinding signs, self-service kiosks
- **Ants**: Pheromone trails, distributed problem-solving
- **Libraries**: Classification systems, reference desk triage

**Generalize:**
- Make paths visible (airport signs)
- Let successful paths strengthen (pheromone trails)
- Classify by type, route to specialists (library)

**Combine & Instantiate:**
- Show "X people found this helpful" on FAQ answers (pheromone)
- Auto-classify tickets and route to specialty teams (library)
- Visual flowchart: "What do you need?" with clear paths (airport)

---

## Constraint Injection Protocol

**Origin:** Research on creativity constraints + AI homogenization mitigation
**Best for:** Preventing AI idea convergence, boosting novelty
**Research:** [Science Advances 2024](https://www.science.org/doi/10.1126/sciadv.adn5290)

### The Problem

Without constraints, AI-generated ideas tend to converge toward the same "optimal" solutions across users. Adding deliberate constraints paradoxically increases creativity.

### Constraint Types

| Type | Description | Example |
|------|-------------|---------|
| **Resource** | Limit money, people, time | "With $0 budget" |
| **Time** | Compress or extend timeline | "In 24 hours" / "Over 10 years" |
| **Anti-feature** | Remove an expected element | "Without any technology" |
| **Stakeholder** | Change the user | "For a 5-year-old" / "For an expert" |
| **Technical** | Limit tools/methods | "Using only paper" |
| **Scale** | Change magnitude | "For 1 million users" / "For 1 person" |
| **Location** | Change context | "In rural Africa" / "In space" |
| **Inversion** | Flip a core assumption | "Users pay us" → "We pay users" |

### Process

1. **Baseline**: Generate 5 ideas without constraints
2. **Inject**: Pick 1-2 random constraints from table
3. **Constrained round**: Generate 5 MORE ideas under constraints
4. **Compare**: Note which set is more creative/novel
5. **Hybrid**: Apply constraint insights to unconstrained ideas

### Example: "New productivity app features"

**Unconstrained ideas:**
1. AI task prioritization
2. Calendar integration
3. Team collaboration
4. Progress tracking
5. Focus mode

**Constraint injected:** "For users with no internet access"

**Constrained ideas:**
1. Offline-first with local AI that syncs later
2. SMS-based task management
3. Paper template generator for analog backup
4. Voice memos that transcribe when online
5. Peer-to-peer sync via Bluetooth

**Insight:** The constrained set reveals novel approaches (SMS, P2P, paper hybrid) that improve the app even WITH internet.

---

## Multi-Persona Parallel

**Origin:** Design research + LLM prompt engineering
**Best for:** Maximizing solution diversity
**Research:** [Cambridge Design Science 2024](https://www.cambridge.org/core/journals/design-science/article/enhancing-design-concept-diversity-multipersona-prompting-strategies-for-large-language-models/)

### Key Finding

Running multiple personas **simultaneously** produces more diverse ideas than running them sequentially. Sequential personas anchor to earlier outputs.

### Method A: Parallel Personas (Maximum Diversity)

Generate ALL personas' responses in a single prompt:

```
Solve [problem] from these 4 perspectives simultaneously:
1. As a skeptical engineer focused on feasibility
2. As a customer experience designer focused on delight
3. As a cost-optimizer focused on efficiency
4. As a 10-year-old child focused on fun

Give each perspective 2-3 distinct ideas.
```

### Method B: Sequential Evolution

When parallel isn't possible, use structured handoffs:

1. **Persona A** generates initial solution
2. **Persona B** critiques and proposes improvements
3. **Persona C** adds a completely different angle
4. **Synthesizer** combines insights from all three

### Persona Bank

| Category | Personas |
|----------|----------|
| **Role** | Engineer, Designer, Marketer, CFO, Customer Support |
| **Attitude** | Skeptic, Optimist, Pragmatist, Dreamer, Devil's Advocate |
| **Domain** | Healthcare, Military, Entertainment, Education, Nature |
| **Age** | Child (5), Teen (15), Adult (35), Elder (75) |
| **Constraint** | No budget, Unlimited budget, No time, 10 years, Hostile environment |

### Example: "Improve employee onboarding"

**Parallel prompt output:**

**Skeptical Engineer:**
- Automate repetitive setup with scripts
- Create checkable prerequisites before day 1
- Build self-service troubleshooting wiki

**Customer Experience Designer:**
- Design "welcome journey" with surprise moments
- Buddy system with gamified milestones
- Personalized welcome video from CEO

**10-year-old Child:**
- Make it a treasure hunt to find your desk/tools
- Sticker collection for completing tasks
- Have a "graduation ceremony" on day 30

**Synthesis:** The child's "treasure hunt" idea → transformed into an interactive onboarding quest with real rewards.

---

## TRIZ-AI Quick Method

**Origin:** TRIZ (Theory of Inventive Problem Solving) + LLM implementation
**Best for:** Technical/engineering problems, systematic innovation
**Research:** [AutoTRIZ 2024](https://arxiv.org/html/2403.13002v2)

### Background

TRIZ analyzed 40,000+ patents to extract 40 universal inventive principles. These principles can be applied systematically via LLM prompts.

### The 40 TRIZ Principles (Grouped)

**Structural:**
1. Segmentation — Divide into independent parts
2. Taking out — Separate interfering part
3. Local quality — Different parts do different things
4. Asymmetry — Replace symmetry with asymmetry
5. Merging — Bring closer, combine in time
6. Universality — One part performs multiple functions
7. Nesting — Place one inside another
8. Anti-weight — Compensate weight with lift
9. Preliminary anti-action — Create countermeasures in advance
10. Preliminary action — Pre-arrange before needed

**Dynamic:**
11. Beforehand cushioning — Prepare emergency means
12. Equipotentiality — Limit position changes
13. The other way around — Invert the action
14. Spheroidality — Use curves instead of lines
15. Dynamics — Allow characteristics to change
16. Partial or excessive action — Do more/less than needed
17. Another dimension — Move to 2D/3D
18. Mechanical vibration — Use oscillation
19. Periodic action — Use pulses instead of continuous
20. Continuity of useful action — Eliminate idle time

**Resource:**
21. Skipping — Conduct at high speed
22. Blessing in disguise — Use harmful factors
23. Feedback — Introduce feedback
24. Intermediary — Use intermediate carrier
25. Self-service — Object services itself
26. Copying — Use cheap copies
27. Cheap disposables — Replace expensive durable with cheap disposable
28. Mechanical substitution — Replace physical with sensory
29. Pneumatics and hydraulics — Use gas/liquid
30. Flexible membranes — Use thin films

**Transformation:**
31. Porous materials — Make porous
32. Color changes — Change color
33. Homogeneity — Make interacting parts of same material
34. Discarding/recovering — Discard or restore
35. Parameter changes — Change physical state
36. Phase transitions — Use phase change effects
37. Thermal expansion — Use thermal expansion
38. Strong oxidants — Use enriched atmosphere
39. Inert atmosphere — Use inert environment
40. Composite materials — Use composite materials

### Quick Application Process

1. **State problem** as a contradiction: "I want X but it causes Y"
2. **Identify** 2-3 relevant principles from list
3. **Prompt**: "Apply TRIZ principle [X] to solve: [problem]"
4. **Iterate** with different principles

### Example: "Battery drains too fast in mobile app"

**Contradiction:** "I want frequent sync but it drains battery"

**Relevant principles:**
- #19 Periodic action (pulse instead of continuous)
- #23 Feedback (adjust based on usage)
- #25 Self-service (app manages its own resources)

**Generated solutions:**
- Sync every 15 min when active, every 2 hours when idle (#19)
- Learn user patterns, sync before they typically open app (#23)
- App reduces features automatically when battery <20% (#25)

---

## Divergence Guard

**Origin:** Research on AI collective homogenization
**Best for:** Preventing AI ideas from becoming too similar
**Research:** [PMC 2024](https://pmc.ncbi.nlm.nih.gov/articles/PMC11244532/)

### The Problem

Studies show that while AI helps individuals generate more original ideas, the overall diversity ACROSS groups narrows. Everyone converges on similar "AI-optimized" solutions.

### The 5-Step Protocol

1. **Similarity Check**
   - After generating 3+ ideas, review for patterns
   - Ask: "Are these variations of the same concept?"

2. **Force Opposite**
   - Prompt: "Generate an idea that is the OPPOSITE of the above"
   - If ideas are digital → force analog
   - If ideas are fast → force slow

3. **Domain Shift**
   - Prompt: "What would [completely unrelated field] do?"
   - Use random domain: military, cooking, childcare, astronomy

4. **Constraint Swap**
   - Remove the most assumed constraint
   - Add a random new constraint
   - Regenerate

5. **Absurdity Injection**
   - Prompt: "What's the most ridiculous/impossible solution?"
   - Often contains kernel of genuine insight

### Example: "Ideas for team communication tool"

**Initial ideas (similar):**
1. Slack-like channels with threading
2. Teams-like video integration
3. Discord-like voice rooms

**Divergence Guard applied:**

**Force opposite:** "No real-time communication at all"
→ Async video messages that auto-delete after 24 hours

**Domain shift:** "What would a kindergarten teacher do?"
→ Visual mood boards, sticker reactions, show-and-tell sessions

**Absurdity injection:** "Most ridiculous solution?"
→ Mandatory 5-minute interpretive dance before each meeting
→ *Kernel:* Physical/movement element before intense discussions = "walking 1:1s" feature

**Result:** Far more diverse idea set than iteration would produce
