# Research: Technique Combination Strategies & Idea Development Pipeline

> Research conducted: 2026-01-29

---

## Part A: Which Creativity Techniques Work Well Together?

### 1. Technique Stacking -- Divergent + Convergent Pairing

The most fundamental principle in combining creativity techniques is the **divergent-convergent rhythm**. Every effective ideation session alternates between expanding possibilities (divergent) and narrowing focus (convergent).

#### The Core Pattern

```
Diverge (generate many ideas)
  --> Converge (select/filter)
    --> Diverge (develop selected ideas further)
      --> Converge (finalize)
```

**Key insight from NN/g**: By first working independently on a problem and then converging to share insights, teams leverage the benefits of both work styles, leading to rapid data analysis, diverse ideas, and high-quality designs. Diverge-and-converge eliminates bias, broadens insight, and adds depth to conversations.

**Workshop sequencing tip from Stormz**: You can visually show the alternation of divergence and convergence steps with `>` and `<`. Several successive steps of divergence are frequent in creativity workshops using different techniques to encourage participants to generate more ideas. It is generally a bad idea to end a workshop with a divergence activity -- always close with convergence.

Sources:
- [The Diverge-and-Converge Technique for UX Workshops (NN/g)](https://www.nngroup.com/articles/diverge-converge/)
- [Go Beyond The Basics of Divergent and Convergent Thinking (Stormz)](https://stormz.me/en/blog/go-beyond-the-basics-of-divergent-and-convergent-thinking)
- [The Synergy of Diverge and Converge in Design Thinking (Voltage Control)](https://voltagecontrol.com/articles/the-synergy-of-diverge-and-converge-in-design-thinking/)

#### Emergent Thinking (The In-Between)

There is actually a third mode between divergent and convergent: **emergent thinking**. This leverages ideas generated in the early divergent stage as stimuli to allow the generation of additional ideas -- building upon initial ideas to make new connections, combine, and spark new ideas. The early, more chaotic divergent sessions should provide a wide enough range of stimuli to make this possible.

Source: [How to Think and Work Divergently (IxDF)](https://www.interaction-design.org/literature/article/how-to-think-and-work-divergently-4-ideation-methods)

---

### 2. Sequential Technique Workflows

#### Mixing Techniques in Practice

The key is to match the technique to the stage of thinking:

| Stage | Goal | Techniques |
|-------|------|-----------|
| **Frame** | Define the challenge | How Might We (HMW), Problem Statement |
| **Expand** | Generate many ideas | Brainstorming, Brainwriting, Mind Mapping, SCAMPER |
| **Organize** | Cluster & pattern-find | Affinity Diagrams, Dot Voting |
| **Refine** | Develop top ideas | Concept Sketch, Storyboarding |
| **Evaluate** | Select best options | Impact/Effort Matrix, ICE/RICE Scoring |

**Practical combo example from Grammarly**: Start with listing to generate ideas quickly, then use mind mapping to organize them. If working in a group, try round-robin brainstorming followed by a SWOT analysis to evaluate the best ideas. Mixing methods helps tailor the process to your specific needs.

**SessionLab recommends**: Complex idea generation techniques combine brainstorming with idea evaluation, idea selection, and concept development to help you come up with the best options.

Sources:
- [17 Brainstorming Methods (Grammarly)](https://www.grammarly.com/blog/writing-process/brainstorming-methods/)
- [43 Brainstorming Techniques (SessionLab)](https://www.sessionlab.com/blog/brainstorming-techniques/)
- [Brainstorming Examples (Miro)](https://miro.com/brainstorming/brainstorming-examples/)

#### Lightning Decision Jam (LDJ) -- A Full Sequence Example

The LDJ is a fast-paced, structured ideation and decision-making workshop that combines:
1. Individual idea generation
2. Group consensus building
3. Prioritization
4. Action planning

Unlike traditional brainstorming, LDJ focuses on creating a clear, actionable plan by combining individual idea generation with group consensus.

Source: [10 Powerful Ideation Techniques (ITONICS)](https://www.itonics-innovation.com/blog/powerful-ideation-techniques)

---

### 3. Design Thinking Integration

#### Double Diamond Model

Created by the British Design Council in 2005, the Double Diamond has four phases with specific techniques for each:

```
Diamond 1: Problem Space          Diamond 2: Solution Space
  Discover --> Define               Develop --> Deliver
  (diverge)   (converge)           (diverge)   (converge)
```

| Phase | Type | Key Techniques |
|-------|------|---------------|
| **Discover** | Divergent | User interviews, field studies, desk research, mind maps, observations, surveys |
| **Define** | Convergent | Affinity diagrams, root-cause analysis, 5 Whys, problem statement crafting, design brief |
| **Develop** | Divergent | HMW questions, brainstorming, SCAMPER, wireframing, low-fi prototyping, collaborative workshops |
| **Deliver** | Convergent | Usability testing, A/B testing, iteration, stakeholder reviews, implementation roadmap |

**Key insight**: The two-diamond structure prevents the common design mistake of rushing to solutions before fully understanding the problem. By explicitly separating problem exploration from solution creation, the framework ensures designers solve the right problem with the right solution.

Sources:
- [The Double Diamond (Design Council)](https://www.designcouncil.org.uk/our-resources/the-double-diamond/)
- [The Double Diamond Process (Maze)](https://maze.co/blog/double-diamond-design-process/)
- [Double Diamond Design Process (UXPin)](https://www.uxpin.com/studio/blog/double-diamond-design-process/)
- [Double Diamond Design Process (Splunk)](https://www.splunk.com/en_us/blog/learn/double-diamond-design-process.html)

#### Design Sprint (Jake Knapp / Google Ventures)

A 5-day compressed innovation process with this specific technique sequence:

| Day | Phase | Activities |
|-----|-------|-----------|
| **Monday** | Map / Understand | Set long-term goal, map the challenge, expert interviews, pick a target |
| **Tuesday** | Sketch / Ideation | Review existing ideas for remix, individual 4-step sketching process |
| **Wednesday** | Decide | Critique solutions, vote on best, create storyboard plan |
| **Thursday** | Prototype | Build a realistic facade/prototype in one day |
| **Friday** | Test | Interview 5 customers watching them use the prototype |

**Key innovation from Knapp**: He switched from group ideas to individual ideas and gave people more time to develop those ideas before getting feedback. He also tried critique and decision-making exercises that did not rely on consensus. Testing with just 5 users reveals 85% of potential issues.

Sources:
- [The Design Sprint (GV)](https://www.gv.com/sprint/)
- [Sprint Book](https://www.thesprintbook.com/the-design-sprint)
- [Jake Knapp Sprint](https://jakeknapp.com/sprint)
- [Design Sprint Guide (Workshopper)](https://www.workshopper.com/post/the-ultimate-step-by-step-guide-for-design-sprint-beginners)

---

### 4. Recommended Sequences by Goal

#### Goal: "I need a breakthrough"

```
1. HMW Reframing --> Frame challenge as opportunity
2. Worst Possible Idea --> Break mental blocks
3. SCAMPER --> Systematically twist existing concepts
4. Brainwriting 6-3-5 --> Build on others' wild ideas silently
5. Dot Voting --> Surface favorites
6. Concept Sketch --> Develop top 3 ideas
```

**Why this works**: Starts by reframing the problem (HMW), deliberately breaks patterns (Worst Idea), then systematically explores alternatives (SCAMPER), leverages group intelligence without groupthink (Brainwriting), and focuses energy on winners (Dot Voting + Concept Sketch).

#### Goal: "I need to improve something"

```
1. SCAMPER --> Systematically modify existing product/process
2. Reverse Brainstorm --> "How could we make this worse?" then flip
3. Affinity Mapping --> Cluster improvement ideas
4. Impact/Effort Matrix --> Prioritize quick wins vs. big bets
5. Action Planning --> Assign owners and timelines
```

**Why this works**: SCAMPER gives structured lens for modification. Reverse brainstorming surfaces hidden problems. Affinity mapping finds themes. Impact/Effort prioritizes pragmatically.

#### Goal: "I need many diverse options"

```
1. Mind Mapping --> Free-associate from central concept
2. Round-Robin Brainstorming --> Each person adds one idea in turn
3. Random Word/Image Stimulus --> Force unexpected connections
4. Brainwriting --> Silent parallel idea generation
5. Affinity Clustering --> Group the mass of ideas
6. Multi-Voting --> Narrow to top 10-15
```

**Why this works**: Multiple divergent techniques in sequence, each using a different cognitive mode (visual, verbal, random, collaborative), maximizes the diversity of output before converging.

Sources:
- [Brainstorming Techniques (IxDF)](https://www.interaction-design.org/literature/topics/brainstorming)
- [Breakthrough Brainstorming (Arts Midwest)](https://artsmidwest.org/resources/ideas/use-brainstorming-that-breaks-through/)
- [Brainstorming Templates (Conceptboard)](https://conceptboard.com/blog/brainstorming-techniques-templates/)

---

## Part B: Idea Development Pipeline (Raw Idea to Actionable Plan)

### 1. From Idea to Execution Frameworks

#### Framework A: Stage-Gate / Idea Funnel (ITONICS)

```
Ideation --> Screening --> Concept Dev --> Business Case --> Development --> Launch
   |            |              |               |                |            |
  Gate 0      Gate 1        Gate 2          Gate 3           Gate 4       Gate 5
```

Each gate is a go/no-go decision point. By breaking the process into clear stages (scoping phase, testing phase, development stage), it becomes easier to assess each idea's potential impact. Each gate helps refine the idea and build up the business case step by step.

Source: [Idea Funnel Best Practices (ITONICS)](https://www.itonics-innovation.com/blog/idea-funnel)

#### Framework B: Lean Startup Build-Measure-Learn (Eric Ries)

```
     Ideas
       |
     BUILD --> MVP / Prototype
       |
    MEASURE --> Data & Metrics
       |
     LEARN --> Pivot or Persevere
       |
    (repeat)
```

The fundamental activity is to turn ideas into products, measure how customers respond, and then learn whether to pivot or persevere. All successful startup processes should be geared to accelerate that feedback loop.

**Types of MVPs**:
- **Landing page** -- gauge interest (used by Buffer)
- **Concierge MVP** -- manually deliver the service (used by Zappos)
- **Clickable prototype** -- validate usability
- **Explainer video** -- test demand (used by Dropbox)

**Important correction from Strategyzer**: Do not start building before researching. Flip the loop: **Learn first --> then Build --> then Measure**. Simply flipping the existing Build-Measure-Learn loop to begin with a brief Learn phase can provide validated insights to ensure that you are building the right thing for the right people.

Sources:
- [Lean Startup Principles](https://theleanstartup.com/principles)
- [Build-Measure-Learn (UserPilot)](https://userpilot.com/blog/build-measure-learn/)
- [BML is Not Enough (Agile Alliance)](https://agilealliance.org/build-measure-learn-lean-startup/)
- [Don't Build When You BML (Strategyzer)](https://www.strategyzer.com/library/dont-build-when-you-build-measure-learn)
- [Lean Startup (Viima)](https://www.viima.com/blog/lean-startup)

#### Framework C: Continuous Idea Pipeline (Ideanote)

Four key stages:
1. **Collection** -- Gather ideas from all sources
2. **Management** -- Organize, tag, deduplicate
3. **Evaluation** -- Score, rank, filter
4. **Tracking** -- Monitor implementation progress

Source: [Creating a Continuous Idea Pipeline (Ideanote)](https://ideanote.io/blog/idea-pipeline)

#### Framework D: 5i Innovation Pipeline (Triangle IP)

1. **Ideation** -- Brainstorm and research to generate viable ideas
2. **Invention** -- Turn ideas into tangible concepts through analysis, experimentation, refinement
3. **Vetting** -- Detailed market research, technical feasibility, initial financial assessments
4. **Prototyping** -- Develop MVP for ideas that show promise
5. **Implementation** -- Full development and launch

Source: [Innovation Pipeline Management (Triangle IP)](https://triangleip.com/strategies-for-implementing-effective-innovation-pipeline-management/)

#### Framework E: Dual-Track Agile (Tempo)

Run two parallel tracks:
- **Discovery track** -- Conducting experiments and building prototypes
- **Delivery track** -- Running development sprints

Validated stories flow directly from discovery into delivery without delays.

Source: [Idea Development (Tempo)](https://www.tempo.io/blog/idea-development)

---

### 2. Idea Refinement Techniques

#### Assumption Mapping

A critical technique for refining raw ideas into validated concepts.

**Process**:
1. **Identify assumptions** -- Ask: "What must be true for this idea to be viable/desirable/feasible?"
2. **Write hypotheses** -- Use "We believe that..." format
3. **Map on 2x2 matrix** -- Axes: Importance (high/low) x Certainty (high/low)
4. **Test high-importance/low-certainty first** -- These are the riskiest assumptions

**Four assumption categories**:
- **Desirability** -- Do users want this?
- **Feasibility** -- Can we build this?
- **Viability** -- Is this economically sustainable?
- **Adaptability** -- Can this survive change?

**Validation methods**:
- User interviews (desirability)
- Prototyping (usability/feasibility)
- MVPs (market viability)
- Market research (market sizing, competition)

Sources:
- [Assumptions Mapping (UXPin)](https://www.uxpin.com/studio/blog/assumptions-mapping/)
- [Assumptions Mapping (Google Design Sprint Kit)](https://designsprintkit.withgoogle.com/methodology/phase2-define/assumptions-mapping)
- [Assumption Mapping Guide (UXtweak)](https://blog.uxtweak.com/assumption-mapping/)
- [Assumption Mapping (Strategyzer)](https://www.strategyzer.com/library/how-assumptions-mapping-can-focus-your-teams-on-running-experiments-that-matter)
- [Assumption Mapping (Miro)](https://miro.com/blog/invest-winning-ideas-assumption-mapping/)

#### Concept Development Worksheet (Synthesized)

For each promising idea, fill in:

```
Concept Name: _______________
Problem it solves: _______________
Target user: _______________
Key assumptions:
  1. _______________
  2. _______________
  3. _______________
How it works (1 paragraph): _______________
Key differentiator: _______________
Biggest risk: _______________
Quickest way to test: _______________
Effort estimate (S/M/L): _______________
```

#### Quick Prototyping Approaches

| Type | Time | Best For |
|------|------|----------|
| Paper sketch | 5 min | Initial concept visualization |
| Landing page | 1-2 hours | Demand validation |
| Clickable prototype (Figma) | 1-2 days | Usability testing |
| Concierge (manual delivery) | 1 week | Service feasibility |
| Wizard of Oz (fake backend) | 1-2 weeks | Full experience testing |

---

### 3. Prioritization Methods

#### ICE Scoring (Sean Ellis / GrowthHackers)

```
ICE Score = Impact x Confidence x Ease
```

| Factor | Scale | Description |
|--------|-------|-------------|
| **Impact** | 1-10 | Potential benefit/value |
| **Confidence** | 1-10 | How certain are we? |
| **Ease** | 1-10 | How easy to implement? |

**Best for**: Quick experiments, growth hacking, early-stage ideas
**Weakness**: Subjective, less data-driven, prone to guesstimates

Source: [RICE vs ICE (ProductLift)](https://www.productlift.dev/blog/rice-vs-ice)

#### RICE Scoring (Intercom)

```
RICE Score = (Reach x Impact x Confidence) / Effort
```

| Factor | Description | Measurement |
|--------|-------------|-------------|
| **Reach** | How many users affected? | Users/quarter, transactions/month |
| **Impact** | How much does it affect them? | 3=massive, 2=high, 1=medium, 0.5=low, 0.25=minimal |
| **Confidence** | How certain are estimates? | 100%=high, 80%=medium, 50%=low |
| **Effort** | Person-months required | Engineering time |

**Best for**: Data-driven roadmap planning, product teams with metrics
**Strength**: Most objective of the scoring methods

Sources:
- [RICE Framework (Plaky)](https://plaky.com/blog/rice-framework/)
- [RICE Framework (Railsware)](https://railsware.com/blog/rice-framework/)

#### MoSCoW Method

| Category | Meaning | Guideline |
|----------|---------|-----------|
| **Must have** | Critical, non-negotiable | ~60% of effort |
| **Should have** | Important, not vital | ~20% of effort |
| **Could have** | Nice to have | ~20% of effort |
| **Won't have** | Out of scope (this time) | Documented for later |

**Best for**: Fixed-deadline projects, MVP scoping, sprint planning
**Strength**: Simple, enforces scope discipline

Sources:
- [RICE vs MoSCoW (Ramen Club)](https://www.ramenclub.so/blog/rice-moscow-methods-prioritization-framework)
- [MoSCoW vs RICE (Medium)](https://medium.com/@ebtihaj316/moscow-vs-rice-when-to-use-which-and-why-it-matters-27fb2244c2d4)

#### Weighted Scoring Matrix

A flexible framework where you define custom criteria:

**Step-by-step**:
1. **List all options** (ideas/features)
2. **Define criteria** (e.g., customer impact, revenue potential, strategic alignment, feasibility, time to market)
3. **Assign weights** as percentages (must sum to 100%)
4. **Score each option** on each criterion (1-5 scale)
5. **Multiply** score x weight for each cell
6. **Sum** weighted scores per option
7. **Rank** by total score

**Example**:

| Idea | Customer Impact (40%) | Feasibility (30%) | Strategic Fit (30%) | Total |
|------|----------------------|-------------------|-------------------|-------|
| A | 5 x 0.4 = 2.0 | 3 x 0.3 = 0.9 | 4 x 0.3 = 1.2 | **4.1** |
| B | 3 x 0.4 = 1.2 | 5 x 0.3 = 1.5 | 3 x 0.3 = 0.9 | **3.6** |
| C | 4 x 0.4 = 1.6 | 4 x 0.3 = 1.2 | 5 x 0.3 = 1.5 | **4.3** |

**Best for**: Complex decisions with multiple stakeholders, strategic portfolio decisions
**Strength**: Highly customizable, forces explicit agreement on what matters

Sources:
- [Weighted Scoring Prioritization (SixSigma.us)](https://www.6sigma.us/six-sigma-in-focus/weighted-scoring-prioritization/)
- [Weighted Decision Matrix (airfocus)](https://airfocus.com/blog/weighted-decision-matrix-prioritization/)
- [Weighted Scoring Model (Product School)](https://productschool.com/blog/product-fundamentals/weighted-scoring-model)
- [Weighted Scoring Model (Tempo)](https://www.tempo.io/blog/weighted-scoring-model)

#### Impact/Effort Matrix (2x2)

```
         High Impact
              |
   Big Bets   |   Quick Wins  <-- Do these first
              |
  ------------|------------
              |
   Avoid      |   Fill-ins
              |
         Low Impact

  High Effort      Low Effort
```

**Best for**: Quick visual prioritization, team workshops
**Strength**: Intuitive, fast, good for group alignment

Source: [Mastering Prioritization (Medium)](https://sumeet616.medium.com/mastering-prioritization-a-deep-dive-into-rice-moscow-and-impact-vs-effort-frameworks-43006f30717d)

#### When to Use Which Prioritization Method

| Situation | Best Method |
|-----------|-------------|
| Quick team workshop | Impact/Effort Matrix |
| Growth experiments | ICE Scoring |
| Data-driven product roadmap | RICE Scoring |
| Fixed deadline / MVP scoping | MoSCoW |
| Complex multi-criteria decision | Weighted Scoring Matrix |
| Combining methods | RICE to score + MoSCoW to categorize for sprint |

Source: [13 Prioritization Techniques (PPM Express)](https://www.ppm.express/blog/13-prioritization-techniques)

---

## Synthesis: Complete Idea-to-Execution Pipeline

Combining all research, here is a synthesized end-to-end pipeline:

### Phase 1: Discover & Frame
- **Techniques**: User research, stakeholder interviews, market analysis
- **Output**: Problem statements framed as HMW questions

### Phase 2: Ideate & Expand
- **Techniques**: Brainstorming, SCAMPER, Mind Mapping, Brainwriting
- **Pattern**: Use 2-3 divergent techniques in sequence for maximum diversity
- **Output**: Large volume of raw ideas (aim for 50-100+)

### Phase 3: Cluster & Select
- **Techniques**: Affinity Mapping, Dot Voting, Impact/Effort Matrix
- **Output**: Top 3-5 promising concepts

### Phase 4: Refine & Validate
- **Techniques**: Concept Development Worksheet, Assumption Mapping
- **Test**: Quick prototypes (paper, landing page, clickable)
- **Output**: Validated concepts with evidence

### Phase 5: Prioritize
- **Techniques**: ICE/RICE scoring, MoSCoW, Weighted Matrix
- **Output**: Ranked list with clear next actions

### Phase 6: Execute & Learn
- **Framework**: Build-Measure-Learn (but Learn first!)
- **Pattern**: MVP --> Measure --> Learn --> Iterate or Pivot
- **Output**: Launched solution with feedback loop

```
[Discover] --> [Ideate] --> [Cluster] --> [Refine] --> [Prioritize] --> [Execute]
   HMW         SCAMPER      Affinity     Assumption     RICE          Build-
   Research    Brainwrite   Dot Vote     Mapping        MoSCoW        Measure-
   Interviews  Mind Map     Impact/      Prototype      Weighted      Learn
                            Effort                      Matrix
```

---

## Key Takeaways

1. **Always alternate diverge/converge** -- Never end on divergence; always close with convergence.
2. **Individual before group** -- Let people think alone first, then share (reduces groupthink).
3. **Frame before generating** -- HMW questions focus creative energy on the right problem.
4. **Stack 2-3 divergent techniques** -- Different techniques activate different cognitive modes.
5. **Learn before you build** -- Flip the Build-Measure-Learn loop; validate assumptions first.
6. **Combine prioritization methods** -- Use RICE for scoring + MoSCoW for scoping.
7. **Test with 5 users** -- 85% of issues are found with just 5 people (per Design Sprint research).
8. **Map assumptions early** -- High-importance/low-certainty assumptions should be tested first.
