# Research 5: Ideation Output Templates & AI Prompt Templates

> Research date: 2026-01-29

---

## Part A: Output Templates for Creative Ideas

### A1. How to Document/Present Creative Ideas

#### Idea Card Format

The **idea card** is a compact, structured format for capturing a single creative idea. Several platforms offer variations:

- **Board of Innovation Brainstorm Cards**: A set of 52 trigger cards used as catalysts for smarter, more unique ideation sessions. Each card poses a provocative question or scenario to spark new business ideas.
  - Source: [Board of Innovation](https://www.boardofinnovation.com/tools/brainstorm-cards/)

- **Miro Card Brainstorming Template**: A structured framework with sections for user persona development, problem validation, and idea prioritization. Teams fill out individual "Idea Cards" during workshops, then share and vote on the most promising ideas.
  - Source: [Miro Card Brainstorming](https://miro.com/templates/card-brainstorming-template/)

- **The Concept Card (Miro)**: A dedicated template for writing up a single concept in a structured visual card format.
  - Source: [Miro Concept Card](https://miro.com/miroverse/the-concept-card/)

- **Innovation Mode Business IDEA Template**: Helps innovators communicate their ideas clearly and effectively, providing a standard format that allows teams to quickly summarize concepts in a way that is easy to share across teams and departments. Can be used independently or during structured brainstorming sessions.
  - Source: [Innovation Mode](https://www.theinnovationmode.com/the-business-idea)

**Typical Idea Card Fields:**
```
+---------------------------------------+
| IDEA CARD                             |
+---------------------------------------+
| Title:        [Catchy name]           |
| Tagline:      [One-line summary]      |
| Target User:  [Who benefits?]         |
| Problem:      [What pain is solved?]  |
| Solution:     [How it works]          |
| Value Prop:   [Why it matters]        |
| Effort:       [Low / Medium / High]   |
| Impact:       [Low / Medium / High]   |
| Next Steps:   [Immediate actions]     |
+---------------------------------------+
```

#### Concept Brief Templates

A concept brief bridges the gap between idea and implementation. Key resources:

- **Bonsai Concept Brief Template**: Customizable template for aligning project vision with stakeholders, covering messaging, storytelling, concept definitions, and creative elements.
  - Source: [Bonsai](https://www.hellobonsai.com/brief-template/concept)

- **SlideTeam Top 10 Concept Brief Templates**: One-pager templates that effectively communicate goals, purposes, and values. Just type in details and get a one-page document.
  - Source: [SlideTeam](https://www.slideteam.net/blog/top-10-concept-brief-templates-with-examples-and-samples)

- **9 Elements of an Innovation Brief (Killer Innovations)**: Essential elements include:
  1. Organization description with history and context
  2. Project summary and rationale
  3. Objectives (the problem to be solved) -- most crucial
  4. Target audience definition
  5. Competition analysis
  6. Project timing
  7. Budget specification
  8. Key stakeholders
  9. Success metrics
  - Source: [Killer Innovations](https://killerinnovations.com/9-elements-of-a-successful-innovation-brief-creative-brief/)

#### One-Page Idea Pitch Format (Problem-Solution-Benefit)

The **Problem-Solution-Benefit (PSB)** format is the most widely used structure for pitching ideas:

```
+-----------------------------------------------+
| ONE-PAGE IDEA PITCH                           |
+-----------------------------------------------+
| PROBLEM                                       |
| - What pain exists? (1-2 sentences)           |
| - Who experiences it?                         |
| - How severe/frequent is it?                  |
| - Supporting data/story                       |
+-----------------------------------------------+
| SOLUTION                                      |
| - How does it work?                           |
| - What makes it unique?                       |
| - Key features (3-5 bullets)                  |
+-----------------------------------------------+
| BENEFITS                                      |
| - For the user                                |
| - For the business                            |
| - Measurable outcomes                         |
+-----------------------------------------------+
| NEXT STEPS                                    |
| - Immediate action items                      |
| - Resources needed                            |
| - Timeline estimate                           |
+-----------------------------------------------+
```

Basecamp's *Shape Up* methodology adds two more ingredients: **Rabbit Holes** (known risks to avoid) and **No-gos** (things explicitly out of scope).
- Source: [Shape Up - Write the Pitch](https://basecamp.com/shapeup/1.5-chapter-06)
- Source: [Visible.vc](https://visible.vc/blog/problem-solution-slide/)

#### Idea Portfolio Layouts

- **Lucid Innovation Repository**: Brings together brainstorming sessions, user journey maps, process diagrams, UX wireframes, sprint planning boards, and retrospectives as a form of "always on" documentation. Reduces learning curves and enables faster change.
  - Source: [Lucid](https://lucid.co/blog/templates-for-building-an-innovation-repository)

- **Info-Tech Idea Document**: Structured to include major problem/need/opportunity addressed, the Idea Owner responsible for progression, and key components of a successful prototype proposal.
  - Source: [Info-Tech](https://www.infotech.com/research/idea-document)

---

### A2. Structured Output Formats

#### Idea Name + Tagline + Description + Next Steps

A minimal but effective format for quick idea capture:

```
IDEA: [Name]
TAGLINE: [One compelling sentence]
DESCRIPTION: [2-3 paragraphs explaining the concept]
TARGET USER: [Who this is for]
KEY INSIGHT: [The "aha" moment behind this idea]
NEXT STEPS:
  1. [Validate assumption X]
  2. [Build prototype of Y]
  3. [Test with Z users]
```

#### Problem-Solution-Benefit Format

See the One-Page Pitch format above. Best practices:
- **Define the problem clearly**: Summarize in one sentence that anyone can understand.
- **Tell a story**: Use a real person's experience to illustrate the pain point.
- **Present your value proposition**: Explain how the solution differs from alternatives.
- **Include supporting data**: Statistics and market research add credibility.
- **Anticipate objections**: Address potential concerns proactively.
- Source: [LinkedIn Pitch Best Practices](https://www.linkedin.com/advice/3/what-some-best-practices-presenting-your-problem-solution)

#### Opportunity Canvas

The **Opportunity Canvas** (created by Jeff Patton) is designed for evaluating new features or ideas for existing products, where a full Business Model Canvas would be too heavy:

**Key sections:**
- Problem/Need
- Users/Customers affected
- Solution ideas
- User value (how it helps users)
- Business value (how it helps the company)
- Metrics (how we measure success)
- Adoption strategy
- Budget/Timeline constraints

**Key distinction**: Unlike the Business Model Canvas or Lean Canvas, the Opportunity Canvas works at the **feature level**, making it ideal for product teams evaluating individual ideas.

- Source: [Jeff Patton Associates](https://jpattonassociates.com/opportunity-canvas/)
- Source: [Miro Opportunity Canvas](https://miro.com/templates/opportunity-canvas/)
- Source: [Aha! Software](https://www.aha.io/roadmapping/guide/templates/create/opportunity-canvas)

#### Business Case Lite for Ideas

- **AcceptMission One-Page Innovation Strategy Plan**: A short, focused document capturing the entire approach to innovation on a single page. Recommendations:
  - Keep key initiatives to 3-5 focus areas
  - Assign a responsible person or team to each initiative
  - Add deadlines or milestone dates for each major step
  - Source: [AcceptMission](https://www.acceptmission.com/blog/innovation-strategy-plan/)

---

### A3. Comparison/Ranking Formats

#### Idea Evaluation Matrix (2x2 Grid)

The **Idea Generation-Evaluation Matrix** plots ideas on two dimensions: **Impact** vs **Feasibility**.

```
                    HIGH IMPACT
                        |
    "Big Bets"          |        "Quick Wins"
    (High Impact,       |        (High Impact,
     Low Feasibility)   |         High Feasibility)
                        |
  ----------------------+----------------------
                        |
    "Reconsider"        |        "Fill-Ins"
    (Low Impact,        |        (Low Impact,
     Low Feasibility)   |         High Feasibility)
                        |
                    LOW IMPACT
         LOW FEASIBILITY | HIGH FEASIBILITY
```

Quadrant definitions:
- **Quick Wins** (High Impact + High Feasibility): Implement immediately
- **Big Bets** (High Impact + Low Feasibility): Worth investing in if resources allow
- **Fill-Ins** (Low Impact + High Feasibility): Do when time permits
- **Reconsider** (Low Impact + Low Feasibility): Deprioritize or discard

- Source: [Appfluence Evaluation Matrix](https://sync.appfluence.com/templates/idea-generation-evaluation-matrix/)

#### Idea Validation Test Card

The **Test Card** from Really Good Innovation provides a structured way to validate ideas:
- **Hypothesis**: What we believe
- **Test**: How we'll test it
- **Metric**: What we'll measure
- **Criteria**: What constitutes success
- Source: [Really Good Innovation](https://www.reallygoodinnovation.com/templates/test-card)

#### Idea Comparison Table Format

```
| Criteria          | Idea A | Idea B | Idea C |
|-------------------|--------|--------|--------|
| Problem clarity   | 4/5    | 3/5    | 5/5    |
| Market size       | Large  | Medium | Small  |
| Effort to build   | High   | Low    | Medium |
| Uniqueness        | 3/5    | 4/5    | 5/5    |
| Revenue potential  | $$$    | $$     | $      |
| Time to market    | 6 mo   | 2 mo   | 4 mo   |
| Risk level        | High   | Low    | Medium |
| TOTAL SCORE       | 22     | 19     | 25     |
```

#### Radar/Spider Chart Attributes

Common axes for idea radar charts:
1. **Novelty** -- How new/different is this?
2. **Feasibility** -- Can we actually build it?
3. **Desirability** -- Do users want this?
4. **Viability** -- Can it make money?
5. **Scalability** -- Can it grow?
6. **Strategic Fit** -- Does it align with our goals?

---

## Part B: AI Prompt Templates for Creativity Techniques

### B1. Effective Prompts for Creative Brainstorming with AI

#### SCAMPER Prompt Templates

SCAMPER = **Substitute, Combine, Adapt, Modify, Put to another use, Eliminate, Reverse**

**All-in-One SCAMPER Prompt:**
```
Apply the SCAMPER framework to [PRODUCT/SERVICE/IDEA]:

1. SUBSTITUTE: What components, materials, or processes could we replace?
2. COMBINE: What ideas, features, or products could we merge?
3. ADAPT: What else is like this? What could we copy or borrow from another industry?
4. MODIFY: What could we enlarge, shrink, change shape, or alter?
5. PUT TO ANOTHER USE: What else could this be used for? What new markets?
6. ELIMINATE: What could we remove, simplify, or reduce?
7. REVERSE: What if we did the opposite? What if we reversed the process?

For each, generate 3 specific, actionable ideas.
```

**Individual SCAMPER Prompts:**
- "What can I replace in [idea] to make it different or better?"
- "What two things could I combine to make something new?"
- "How could I adapt this idea to work in a completely different context?"
- "What could I make bigger, smaller, faster, or more surprising?"
- "What if I eliminated the most expensive/complex part entirely?"
- "What would happen if I reversed the entire process?"

- Source: [EasyAI Beginner - SCAMPER ChatGPT Template](https://easyaibeginner.com/chatgpt-scamper-framework-prompt-template/)
- Source: [Miro SCAMPER with AI](https://miro.com/miroverse/scamper-brainstorming-ai-assistance-template/)
- Source: [SCAMPER + AI Prompt Sheet (PDF)](https://create2discover.com/wp-content/uploads/2025/05/SCAMPER_AI_Prompt_Sheet.pdf)
- Source: [Juuzt.ai SCAMPER Framework](https://juuzt.ai/knowledge-base/prompt-frameworks/the-scamper-framework/)

#### First Principles Prompt Patterns

```
Using First Principles thinking, analyze [TOPIC/PROBLEM]:

1. What are the fundamental truths about this problem?
   Strip away all assumptions and conventions.
2. What do we assume that might not be true?
3. If we built a solution from scratch knowing only the
   fundamental truths, what would it look like?
4. What would be radically different from today's approach?

Generate 5 ideas that emerge from this first-principles analysis.
```

**Step-by-step First Principles prompt:**
- Step 1: "List every assumption we make about [problem/industry]"
- Step 2: "Challenge each assumption -- which ones are actually false or outdated?"
- Step 3: "What are the irreducible fundamental truths?"
- Step 4: "Build new solutions from only those truths"

- Source: [Maray.ai - First Principles Thinking](https://www.maray.ai/posts/first-principles-thinking)

#### Analogical Thinking Prompts

**Analogical prompting** encourages AI to recall relevant similar problems before solving the current one:

```
Before answering my question, please:
1. Think of 3 similar problems from completely different domains
2. Explain how each was solved
3. Now apply those solution patterns to my problem:
[YOUR PROBLEM]
```

**Cross-industry analogy prompt:**
```
Please act as an innovation consultant. How would
[COMPANY FROM UNRELATED INDUSTRY, e.g., Nintendo/Netflix/IKEA]
design a solution for [YOUR PROBLEM]?

Focus on their core principles such as
[KNOWN PRINCIPLES, e.g., "fun, accessibility, simplicity"]
and generate 3 concrete ideas based on this analogy.
```

- Source: [Tilburg.ai - Analogical Prompting](https://tilburg.ai/2024/11/analogical-prompting/)
- Source: [Relevance AI - Analogical Prompting](https://relevanceai.com/prompt-engineering/use-analogical-prompting-to-improve-ai-problem-solving)
- Source: [Skywork - AI Brainstorming Techniques](https://skywork.ai/blog/ai-agent/7-ai-powered-brainstorming-techniques-for-better-ideas/)

#### Reverse Brainstorming Prompts

```
Let's use reverse brainstorming for [GOAL]:

1. Instead of "How do we succeed?", answer:
   "How could this project SPECTACULARLY fail?"
2. List 10 ways to guarantee failure
3. Now reverse each failure point into a success strategy
4. Which of these reversed strategies are most surprising or novel?
```

**AI as Strategic Adversary:**
```
Act as a dedicated critic and strategic adversary.
Your job is NOT to be supportive but to uncover every
potential flaw in this idea:

[DESCRIBE IDEA]

Identify:
- Hidden assumptions that could be wrong
- Edge cases that would break it
- Market conditions under which this fails
- What competitors would do to beat this

Now, for each vulnerability, suggest how to turn it into a strength.
```

- Source: [Miro - Reverse Brainstorming](https://miro.com/templates/reverse-brainstorming/)
- Source: [Skywork - AI Brainstorming Techniques](https://skywork.ai/blog/ai-agent/7-ai-powered-brainstorming-techniques-for-better-ideas/)
- Source: [MindTools - Reverse Brainstorming](https://www.mindtools.com/a32qxsh/reverse-brainstorming/)

#### "Act as [Persona]" for Creativity

**Multi-Persona Panel Discussion:**
```
I want diverse perspectives on [TOPIC/IDEA].
Please simulate a panel discussion between:

1. A skeptical venture capitalist
2. An enthusiastic end-user / customer
3. A pragmatic engineer
4. A creative designer
5. An ethics advocate

Each persona should give their honest reaction,
concerns, and suggestions for [IDEA].
```

**Famous Person Rolestorming:**
```
What would [FAMOUS PERSON] do?

If [Elon Musk / Steve Jobs / Marie Curie / Walt Disney]
were tackling [PROBLEM], what approach would they take?

Consider their known principles:
- [Person's known philosophy/approach]
- [Their typical decision-making style]
- [What they value most]

Generate 3 ideas this person would likely propose.
```

**Best practices for persona prompts:**
- Be specific: "Act as a seasoned UX designer with 15 years of experience" (not just "Act as a designer")
- Provide context about background, tone, and expertise
- Combine with chain-of-thought reasoning
- Use multiple personas in sequence to simulate diverse viewpoints

---

### B2. Prompt Patterns That Boost Creativity

#### "Generate Surprising/Unexpected Ideas"

```
Generate 10 ideas for [TOPIC] that would surprise me.
Specifically:
- 3 ideas that combine things nobody would think to combine
- 3 ideas that challenge a fundamental assumption in this space
- 2 ideas inspired by a completely unrelated industry
- 2 ideas that are the OPPOSITE of what most people would suggest
```

#### Constraint-Based Prompting

Constraints force creative thinking. Examples:

```
# Budget constraint
"If we had only $100 to solve [PROBLEM], what would we do?"

# Time constraint
"We have 48 hours to launch a solution for [PROBLEM].
What's the simplest thing that could work?"

# Extreme constraint (from ITONICS)
"If our budget were cut by 80% but we still had to
meet our objectives, how would we do it?"

# Technology constraint
"Solve [PROBLEM] using only technology available in 1990."

# Audience constraint
"Design [PRODUCT] so that a 5-year-old could use it."
```

- Source: [ITONICS - 75+ ChatGPT Prompts for Ideation](https://www.itonics-innovation.com/blog/chatgpt-prompts-for-ideation)

#### Tabula Rasa (Clean Slate) Approach

```
"If we were to start [INDUSTRY/PRODUCT] from scratch today,
with all modern tools and technologies available,
what would it look like? Ignore all existing conventions."
```
- Source: [ITONICS](https://www.itonics-innovation.com/blog/chatgpt-prompts-for-ideation)

#### Industry Crossover Prompt

```
"How would our [BUSINESS/PRODUCT] operate if it were
run by leaders from a completely unrelated industry
(e.g., aerospace, fashion, gaming, healthcare)?
Generate specific operational changes for each industry lens."
```
- Source: [ITONICS](https://www.itonics-innovation.com/blog/chatgpt-prompts-for-ideation)

#### Future-Back Thinking

```
"It's 2030. [YOUR COMPANY/PRODUCT] is the undisputed
market leader. Describe the breakthrough idea that got
you there and reverse-engineer the steps it took."
```
- Source: [Stratpilot](https://stratpilot.ai/6-best-ai-prompts-for-business-innovation-and-success-in-2026/)

#### Few-Shot Examples for Creative Tasks

Rather than describing what you want, show examples:

```
Here are 3 examples of the kind of ideas I'm looking for:

Example 1: [Specific creative idea with detail]
Example 2: [Another idea in a different direction]
Example 3: [A third, more unconventional idea]

Now generate 5 more ideas in this style for [YOUR TOPIC],
but push the creativity further than my examples.
```

**Key insight from Google's prompt design guide**: Using examples to show a pattern to follow is MORE effective than showing anti-patterns to avoid.
- Source: [Google Gemini API - Prompt Design Strategies](https://ai.google.dev/gemini-api/docs/prompting-strategies)

#### "Around the Box" Ideation (MIT Sloan)

Rather than thinking "outside the box," this technique prompts for complementary products or services alongside core offerings:

```
"Given our core product [X], what complementary products,
services, or experiences could we offer that customers
would find valuable? Think adjacently, not radically."
```
- Source: [MIT Sloan](https://mitsloan.mit.edu/ideas-made-to-matter/prompt-engineering-so-2024-try-these-prompt-templates-instead)

#### Controlled Hallucination for Innovation

Strategically harness AI's generative tendencies:

```
"I want you to speculate freely and creatively about
[TOPIC]. Don't worry about current feasibility --
imagine what COULD exist. Then, for each speculative idea,
rate its feasibility on a 1-5 scale and suggest what
would need to be true for it to work."
```

**Key stat**: Approximately 30% of ideas generated through "controlled hallucination" survive feasibility analysis -- a remarkably high hit rate for novel concepts.
- Source: [Medium - Complete Prompt Engineering Guide](https://aloaguilar20.medium.com/the-complete-prompt-engineering-guide-for-2025-mastering-cutting-edge-techniques-dfe0591b1d31)

#### Temperature Settings for Creativity

When using API-level access:
- **0.8 - 1.0**: Brainstorming and ideation (creative, diverse outputs)
- **0.4 - 0.7**: Balanced creativity with coherence
- **0.0 - 0.2**: Deterministic, factual tasks (not for ideation)

---

### B3. Anti-Patterns in Creative Prompting

#### Prompts That Produce Generic/Safe Ideas

| Anti-Pattern | Why It Fails | Better Alternative |
|---|---|---|
| "Give me ideas for X" | Too vague, AI defaults to common patterns | "Give me 10 ideas for X that would surprise an expert in this field" |
| "What are some good solutions?" | No constraints or direction | "What solutions would work under these constraints: [specific limits]?" |
| "Be creative" | Meaningless instruction | "Generate ideas that combine [domain A] with [domain B]" |
| Using superlatives ("Act as the smartest person ever") | Experiments show this doesn't improve output quality | Be specific about expertise: "Act as a 20-year veteran product designer" |

- Source: [Ethan Mollick - A Guide to Prompting AI](https://www.oneusefulthing.org/p/a-guide-to-prompting-ai-for-what)

#### Over-Constraining Creativity

| Anti-Pattern | Effect | Fix |
|---|---|---|
| Too many requirements in one prompt | AI tries to satisfy all, produces mediocre results | Split into divergent (generate freely) then convergent (filter) phases |
| Asking for "the best" idea | AI gives one safe answer | Ask for "10 ideas ranging from safe to wild" |
| Specifying exact format too early | Constrains thinking | First generate ideas, then format separately |

#### Leading the AI Toward Expected Answers

| Anti-Pattern | Example | Fix |
|---|---|---|
| Confirmation bias prompts | "Don't you think X is the best approach?" | "What are arguments for AND against X?" |
| Priming with your preferred answer | "I think we should do X. What do you think?" | "Here's the problem. Generate 5 different approaches, including ones I might not have considered." |
| Showing only anti-patterns | "Don't generate ideas like X" | Show positive examples of what you DO want |
| Anchoring on first idea | Taking the first AI output as final | "Generate 10 more ideas that are DIFFERENT from the ones above" |

- Source: [Google Gemini API](https://ai.google.dev/gemini-api/docs/prompting-strategies)
- Source: [MIT Sloan EdTech - Effective Prompts](https://mitsloanedtech.mit.edu/ai/basics/effective-prompts/)

---

## Summary: Recommended Templates for an Ideation Tool

### For Output (Presenting Ideas)

1. **Quick Capture**: Idea Name + Tagline + 3-sentence Description
2. **Standard Card**: Problem / Solution / Benefit / Effort / Impact / Next Steps
3. **Deep Dive**: Full Opportunity Canvas (9 sections)
4. **Comparison**: 2x2 Matrix (Impact vs Feasibility) + Scoring Table
5. **Validation**: Test Card (Hypothesis / Test / Metric / Criteria)

### For Input (AI Prompts)

1. **Divergent Generation**: SCAMPER, First Principles, Reverse Brainstorming
2. **Perspective Shifting**: Multi-persona panel, Famous person rolestorming, Industry crossover
3. **Constraint Forcing**: Budget/time/tech constraints, Tabula rasa
4. **Pattern Breaking**: Analogical thinking, Cross-industry combination, Future-back
5. **Quality Boosting**: Few-shot examples, "Surprise me" framing, Controlled hallucination

### Key Design Principles

- **Separate divergent from convergent**: Generate freely first, evaluate/filter second
- **Use constraints to ENABLE creativity**, not restrict it
- **Show examples** of good output (few-shot) rather than describing what NOT to do
- **Iterate**: Create > Validate > Fix > Validate > Repeat
- **Multiple perspectives**: Never rely on a single prompt or persona

---

## All Sources

### Part A Sources
- [Board of Innovation - Brainstorm Cards](https://www.boardofinnovation.com/tools/brainstorm-cards/)
- [Miro - Card Brainstorming Template](https://miro.com/templates/card-brainstorming-template/)
- [Miro - Brainstorming & Ideation Prompt Cards](https://miro.com/miroverse/flex-your-mind-ideation-workshop/)
- [Miro - The Concept Card](https://miro.com/miroverse/the-concept-card/)
- [Innovation Mode - Business IDEA Template](https://www.theinnovationmode.com/the-business-idea)
- [The Thinking Shop - Creative Thinking Cards](https://thethinkingshop.org/products/creative-thinking-cards-deck)
- [Explorer Labs - 52 Sustainability Ideation Cards](https://www.explorerlabs.co/thinking/52-sustainability-focused-ideation-brainstorm-cards-for-free)
- [MethodKit - Card Decks for Brainstorming](https://methodkit.com/learn/methodkit-with/)
- [Really Good Innovation - Idea Validation Test Card](https://www.reallygoodinnovation.com/templates/test-card)
- [Bonsai - Concept Brief Template](https://www.hellobonsai.com/brief-template/concept)
- [SlideTeam - Top 10 Concept Brief Templates](https://www.slideteam.net/blog/top-10-concept-brief-templates-with-examples-and-samples)
- [Killer Innovations - 9 Elements of Innovation Brief](https://killerinnovations.com/9-elements-of-a-successful-innovation-brief-creative-brief/)
- [AcceptMission - One-Page Innovation Strategy Plan](https://www.acceptmission.com/blog/innovation-strategy-plan/)
- [Basecamp Shape Up - Write the Pitch](https://basecamp.com/shapeup/1.5-chapter-06)
- [Visible.vc - Problem/Solution Slides](https://visible.vc/blog/problem-solution-slide/)
- [LinkedIn - Pitch Best Practices](https://www.linkedin.com/advice/3/what-some-best-practices-presenting-your-problem-solution)
- [Lucid - Innovation Repository Templates](https://lucid.co/blog/templates-for-building-an-innovation-repository)
- [Info-Tech - Idea Document](https://www.infotech.com/research/idea-document)
- [Jeff Patton - Opportunity Canvas](https://jpattonassociates.com/opportunity-canvas/)
- [Miro - Opportunity Canvas](https://miro.com/templates/opportunity-canvas/)
- [Aha! Software - Opportunity Canvas](https://www.aha.io/roadmapping/guide/templates/create/opportunity-canvas)
- [Appfluence - Idea Evaluation Matrix](https://sync.appfluence.com/templates/idea-generation-evaluation-matrix/)

### Part B Sources
- [EasyAI Beginner - SCAMPER ChatGPT Template](https://easyaibeginner.com/chatgpt-scamper-framework-prompt-template/)
- [Miro - SCAMPER with AI Assistance](https://miro.com/miroverse/scamper-brainstorming-ai-assistance-template/)
- [SCAMPER + AI Prompt Sheet (PDF)](https://create2discover.com/wp-content/uploads/2025/05/SCAMPER_AI_Prompt_Sheet.pdf)
- [Juuzt.ai - SCAMPER Framework](https://juuzt.ai/knowledge-base/prompt-frameworks/the-scamper-framework/)
- [Praxie - AI Powered SCAMPER](https://praxie.com/scamper-innovation-online-tools-templates/)
- [Tilburg.ai - Analogical Prompting](https://tilburg.ai/2024/11/analogical-prompting/)
- [Relevance AI - Analogical Prompting](https://relevanceai.com/prompt-engineering/use-analogical-prompting-to-improve-ai-problem-solving)
- [Maray.ai - First Principles Thinking](https://www.maray.ai/posts/first-principles-thinking)
- [Miro - Reverse Brainstorming](https://miro.com/templates/reverse-brainstorming/)
- [Skywork - 7 AI Brainstorming Techniques](https://skywork.ai/blog/ai-agent/7-ai-powered-brainstorming-techniques-for-better-ideas/)
- [MindTools - Reverse Brainstorming](https://www.mindtools.com/a32qxsh/reverse-brainstorming/)
- [ITONICS - 75+ ChatGPT Prompts for Ideation](https://www.itonics-innovation.com/blog/chatgpt-prompts-for-ideation)
- [ITONICS - 110+ Prompts for Innovators](https://www.itonics-innovation.com/blog/chatgpt-prompts-for-innovators)
- [ITONICS - 10 Ideation Techniques](https://www.itonics-innovation.com/blog/powerful-ideation-techniques)
- [Stratpilot - AI Prompts for Creative Ideas 2026](https://stratpilot.ai/6-best-ai-prompts-for-creative-ideas-in-2026/)
- [Stratpilot - AI Prompts for Business Innovation 2026](https://stratpilot.ai/6-best-ai-prompts-for-business-innovation-and-success-in-2026/)
- [Stratpilot - AI Prompts for Design Thinking 2026](https://stratpilot.ai/top-ai-prompts-for-design-thinking-in-2026/)
- [MIT Sloan - Prompt Templates Over Prompt Engineering](https://mitsloan.mit.edu/ideas-made-to-matter/prompt-engineering-so-2024-try-these-prompt-templates-instead)
- [MIT Sloan EdTech - Effective Prompts](https://mitsloanedtech.mit.edu/ai/basics/effective-prompts/)
- [Ethan Mollick - A Guide to Prompting AI](https://www.oneusefulthing.org/p/a-guide-to-prompting-ai-for-what)
- [Google Gemini API - Prompt Design Strategies](https://ai.google.dev/gemini-api/docs/prompting-strategies)
- [IBM - 2026 Guide to Prompt Engineering](https://www.ibm.com/think/prompt-engineering)
- [Accountability Now - 12 ChatGPT Prompts for Creative Ideas 2026](https://accountabilitynow.net/chatgpt-prompts/)
- [Miro - 21 AI Prompts for Brainstorming](https://miro.com/ai/prompts/brainstorming-prompts/)
- [Juma (Team-GPT) - 10 Best AI Brainstorming Generators 2026](https://juma.ai/blog/ai-brainstorming-generators)
- [Arxiv - Novel Idea Generation Tool using Structured CAI](https://arxiv.org/html/2409.05747v1)
- [Asana - 29 Brainstorming Techniques](https://asana.com/resources/brainstorming-techniques)
- [Microsoft 365 - Brainstorming Techniques with AI](https://www.microsoft.com/en-us/microsoft-365-life-hacks/everyday-ai/creative-inspiration/brainstorming-techniques)
