# Color Theory for Graphic Design

## Color Wheel Relationships

### Primary Schemes

| Scheme | Description | Use Case |
|--------|-------------|----------|
| **Monochromatic** | One hue, vary saturation/lightness | Elegant, cohesive |
| **Analogous** | Adjacent colors (3) | Harmonious, natural |
| **Complementary** | Opposite colors | High contrast, vibrant |
| **Split-Complementary** | Base + 2 adjacent to complement | Balanced contrast |
| **Triadic** | 3 evenly spaced | Dynamic, balanced |

### Quick Palettes

```
Professional: #1E3A5F (navy) + #FFFFFF + #D4A84B (gold)
Energetic:    #FF6B35 (orange) + #1A1A1A + #FFFFFF
Calm:         #4A90D9 (blue) + #F5F5F5 + #FFFFFF
Premium:      #0A0A0A (black) + #D4A84B (gold) + #FFFFFF
Fresh:        #2ECC71 (green) + #FFFFFF + #F5F5F5
2025 Trend:   #0A0A0A (dark) + #00FF88 (neon) + #FFFFFF
```

---

## 60-30-10 Rule

| Percentage | Role | Example |
|------------|------|---------|
| **60%** | Dominant | Background, large areas |
| **30%** | Secondary | Containers, cards, accents |
| **10%** | Accent | CTAs, highlights, emphasis |

This creates visual balance and prevents chaos.

---

## Color Psychology

### Western Meanings

| Color | Emotions | Use For |
|-------|----------|---------|
| **Red** | Urgency, passion, energy, danger | Sales, warnings, CTAs |
| **Blue** | Trust, calm, professional, reliable | Corporate, tech, healthcare |
| **Green** | Growth, nature, health, money | Eco, health, finance |
| **Yellow** | Optimism, attention, warmth | Highlights, warnings |
| **Orange** | Friendly, energetic, affordable | E-commerce, food |
| **Purple** | Luxury, creativity, wisdom | Premium brands, beauty |
| **Black** | Power, elegance, sophistication | Luxury, fashion |
| **White** | Clean, pure, minimal, space | Backgrounds, tech |
| **Gold** | Premium, success, wealth | Luxury brands |

### Cultural Differences (IMPORTANT!)

| Color | Western | China/East Asia | Middle East | India |
|-------|---------|-----------------|-------------|-------|
| **Red** | Danger, passion | Luck, prosperity, joy | Danger, caution | Purity, fertility |
| **White** | Purity, weddings | Mourning, death | Purity, peace | Mourning (some regions) |
| **Yellow** | Happy, caution | Royal, sacred | Happiness | Sacred, auspicious |
| **Green** | Nature, money | Health, prosperity | Islam, paradise | Fertility, life |
| **Blue** | Trust, masculine | Immortality | Protection | Divine, Krishna |
| **Black** | Elegant, death | Water element, formal | Mystery, rebirth | Evil, negativity |
| **Gold** | Wealth, premium | Prosperity, imperial | Wealth | Divine, Lakshmi |

**Rule:** Research your target audience's cultural context before choosing colors!

---

## Contrast & Accessibility (WCAG)

### Required Ratios

| Standard | Normal Text (<18pt) | Large Text (18pt+) |
|----------|---------------------|-------------------|
| **AA (Minimum)** | 4.5:1 | 3:1 |
| **AAA (Enhanced)** | 7:1 | 4.5:1 |

### Contrast Examples

| Combo | Ratio | WCAG |
|-------|-------|------|
| Black on White | 21:1 | AAA |
| Navy on White | 16:1 | AAA |
| Gray #767676 on White | 4.5:1 | AA |
| Gray #959595 on White | 3:1 | Fail (normal text) |

### Tools

- [WebAIM Contrast Checker](https://webaim.org/resources/contrastchecker/)
- [Coolors Contrast Checker](https://coolors.co/contrast-checker)
- Browser DevTools → Accessibility tab

---

## Color in Design Hierarchy

1. **Background (60%)** — Neutral, doesn't compete
2. **Content areas (30%)** — Slightly different from bg
3. **Accent (10%)** — CTAs, highlights only

**Rule:** More saturated colors = more attention. Use sparingly for emphasis.

---

## Brand Color Application

### ThepExcel Example

```
Primary:   #D4A84B (Gold) — Accent, highlights
Secondary: #0A0A0A (Black) — Text, contrast
Tertiary:  #FFFFFF (White) — Background
Support:   #F5F5F5 (Light Gray) — Containers
```

### Usage Rules

| Color | Use For | Never Use For |
|-------|---------|---------------|
| Gold | Underlines, bullets, CTAs, icons | Large text, full backgrounds |
| Black | Headlines, body text | — |
| White | Background (90%+) | — |
| Light Gray | Cards, sections | Body text |

---

## Color Temperature

| Temperature | Colors | Feeling | Use For |
|-------------|--------|---------|---------|
| **Warm** | Red, Orange, Yellow | Energy, urgency, passion | Action, sales |
| **Cool** | Blue, Green, Purple | Calm, trust, professional | Corporate, health |
| **Neutral** | Gray, Black, White, Beige | Professional, balanced | Backgrounds, text |

---

## 2025 Color Trends

| Trend | Description |
|-------|-------------|
| **Dark mode + neon** | Black/navy bg with bright accent (cyan, lime, magenta) |
| **Earthy naturalism** | Terracotta, sage, moss, ochre |
| **Dopamine colors** | Bold, vibrant, saturated palettes |
| **Soft gradients** | Subtle color transitions |
| **Moody neutrals** | Warm grays, mushroom tones |

---

## Common Mistakes

| Mistake | Fix |
|---------|-----|
| Too many colors | Max 3-4 per design |
| Low contrast text | Check ratio (4.5:1+) |
| Vibrant background | Use for accent only |
| Ignoring culture | Research target audience |
| Inconsistent palette | Define and stick to it |
| Relying on color alone | Add shape/position cues for accessibility |

---

## Quick Checklist

- [ ] Max 3-4 colors in palette?
- [ ] Following 60-30-10 rule?
- [ ] Contrast ratio 4.5:1+ for text?
- [ ] Considered cultural meanings?
- [ ] Accent color used sparingly?
- [ ] Colors consistent across design?
- [ ] Tested for color blindness?

---

## Resources

- [Adobe Color Wheel](https://color.adobe.com/)
- [Coolors Palette Generator](https://coolors.co/)
- [WebAIM Contrast Checker](https://webaim.org/resources/contrastchecker/)
- [Color Oracle (Color Blindness Simulator)](https://colororacle.org/)
