# Presentation & Slide Design Guide

## Core Philosophy

**Slides support the speaker — they don't replace the speaker.**

Audience cannot read AND listen simultaneously. Choose one.

---

## Fundamental Rules

### One Idea Per Slide

Each slide = single focused message. Benefits:
- **Focus** — Easier for audience to concentrate
- **Memory** — Key messages retained longer
- **Learning** — Avoids cognitive overload

### Text Amount Rules

| Rule | Guideline |
|------|-----------|
| **Rule of 4** | Max 4 bullets, 4 words each |
| **6×6 Rule** | Max 6 lines, 6 words per line |
| **7×7 Rule** | Max 7 lines, 7 words per line |

**Best practice:** Use visuals, not text walls.

---

## Font Size Guidelines

### By Presentation Context

| Context | Titles | Body Text | Captions |
|---------|--------|-----------|----------|
| **Large room (100+ people)** | 60pt+ | 40pt+ | 24pt+ |
| **Medium room (20-50 people)** | 48pt+ | 36pt+ | 20pt+ |
| **Small room/Virtual** | 44pt+ | 32pt+ | 18pt+ |
| **Leave-behind document** | 36pt+ | 20pt+ | 12pt+ |

### Distance Rule

No universal answer — depends on:
- Room size
- Screen size
- Distance to furthest viewer

**Test:** Can the back row read it?

---

## Visual Hierarchy in Slides

### Techniques

1. **Size** — Headlines larger than body
2. **Color** — Accent color for emphasis
3. **Position** — Top-left gets attention first (Z-pattern)
4. **White space** — Isolation = importance
5. **Contrast** — Stand out from background

### Reading Patterns

**Z-Pattern** (most slides):
```
1 ─────────────→ 2
        ↘
3 ─────────────→ 4
```

Place key message at position 1 or 4 (start/end points).

---

## Slide Types & Templates

### Title Slide

```
┌───────────────────────────────────┐
│                                   │
│        PRESENTATION TITLE         │
│        ═══════════════════        │
│        Subtitle / Date            │
│                                   │
│                    Logo           │
└───────────────────────────────────┘
```

### Content Slide

```
┌───────────────────────────────────┐
│ Slide Title                       │
│ ════════════                      │
│                                   │
│  • Point one                      │
│  • Point two                      │
│  • Point three                    │
│                                   │
└───────────────────────────────────┘
```

### Two-Column

```
┌───────────────────────────────────┐
│ Slide Title                       │
│                                   │
│  Left Column    │  Right Column   │
│  • Item 1       │  [Image/Chart]  │
│  • Item 2       │                 │
│  • Item 3       │                 │
└───────────────────────────────────┘
```

### Data/Chart Slide

```
┌───────────────────────────────────┐
│ Key Finding (One Sentence)        │
│                                   │
│      ┌────────────────────┐       │
│      │                    │       │
│      │   [CHART/GRAPH]    │       │
│      │                    │       │
│      └────────────────────┘       │
│                                   │
│ Source: Citation                  │
└───────────────────────────────────┘
```

---

## Design Best Practices

### Do's

- [ ] One message per slide
- [ ] High contrast (4.5:1 minimum)
- [ ] Consistent fonts/colors throughout
- [ ] Use visuals > text for data
- [ ] Leave breathing room (white space)
- [ ] Test on target screen/projector

### Don'ts

- [ ] Text walls
- [ ] Reading slides aloud
- [ ] Too many animations
- [ ] Inconsistent styling
- [ ] Low contrast text
- [ ] Tiny fonts

---

## 2025 Trends

| Trend | Description | When to Use |
|-------|-------------|-------------|
| **Dark mode** | Dark bg + neon/bright text | Modern, tech, creative |
| **Minimalism** | One accent color, lots of space | Corporate, clean |
| **Gradients** | Subtle color transitions | Creative, dynamic |
| **Motion** | Micro-animations | Virtual presentations |
| **Magazine layouts** | Asymmetric, editorial | Creative agencies |
| **Mobile-first** | Vertical, large text | Hybrid meetings |

---

## Color for Slides

### Background Options

| Type | Use Case |
|------|----------|
| **White/Light** | Classic, readable, print-friendly |
| **Dark/Black** | Modern, reduces eye strain, virtual |
| **Brand color** | Consistency, recognition |

### Text on Background

| Background | Text Color |
|------------|------------|
| White | Black/Dark gray |
| Black | White/Light colors |
| Dark blue | White/Yellow |
| Light gray | Black/Navy |

**Rule:** Always check contrast ratio (4.5:1+)

---

## Data Visualization

### Chart Selection

| Data Type | Best Chart |
|-----------|------------|
| Comparison | Bar chart |
| Trend over time | Line chart |
| Part of whole | Pie chart (max 5 segments) |
| Relationship | Scatter plot |
| Process | Flowchart |

### Data Presentation Tips

1. **Simplify** — Remove unnecessary gridlines, labels
2. **Highlight** — Use color to emphasize key data point
3. **Title = Insight** — "Sales grew 40%" not "Sales chart"
4. **Source** — Always cite data source

---

## Animation Guidelines

### Use Sparingly

- Reveal content progressively (builds)
- Guide attention
- Show process/sequence

### Avoid

- Flashy transitions between slides
- Multiple animations per slide
- Animations that distract from message

### Safe Animations

- Fade in
- Appear
- Fly in (one direction)
- Simple morph (PowerPoint)

---

## Cognitive Load Considerations

### Dual-Channel Theory

Humans process visual and auditory separately. Don't:
- Show text AND speak the same words
- Require reading while listening

### Do Instead

- Show image/chart → explain verbally
- Show key word → elaborate verbally
- Use progressive reveal

### Working Memory Limits

- 4±1 items can be held at once
- Chunk information
- Use hierarchy to prioritize

---

## Presentation Checklist

### Before Presenting

- [ ] All text readable from back of room?
- [ ] Consistent styling throughout?
- [ ] One idea per slide?
- [ ] Data visualized, not tabled?
- [ ] Animations purposeful and minimal?
- [ ] Tested on actual screen/projector?
- [ ] Backup copy available?

### Design Quality

- [ ] High contrast (WCAG AA)?
- [ ] Max 2-3 fonts?
- [ ] Max 3-4 colors?
- [ ] Aligned to grid?
- [ ] White space adequate?
- [ ] Key message obvious?

---

## Resources

- **Research:** [Ten Simple Rules for Effective Slides](https://pmc.ncbi.nlm.nih.gov/articles/PMC8638955/)
- **Contrast Checker:** [WebAIM](https://webaim.org/resources/contrastchecker/)
- **Design Trends:** [24slides](https://24slides.com/presentbetter/best-presentation-design-trends)
