# Typography Guide

## Font Categories

| Category | Characteristics | Use For |
|----------|-----------------|---------|
| **Serif** | Traditional, trustworthy | Body text, print |
| **Sans-serif** | Modern, clean | Headlines, screens |
| **Display** | Decorative, impactful | Headlines only |
| **Monospace** | Code, technical | Code snippets |
| **Script** | Elegant, personal | Accents, signatures |

## Font Pairing Matrix

### Safe Combinations
| Display (Headlines) | Body (Text) | Mood |
|---------------------|-------------|------|
| Montserrat Bold | Open Sans | Modern Professional |
| Playfair Display | Lato | Elegant Editorial |
| Bebas Neue | Roboto | Bold Impact |
| Oswald | Source Sans Pro | Strong & Readable |
| Poppins Bold | Inter | Friendly Tech |

### Thai-Friendly Pairs
| Display | Body | Notes |
|---------|------|-------|
| Kanit Bold | Sarabun | ThepExcel standard |
| Prompt Bold | Pridi | Modern Thai |
| IBM Plex Sans Thai Bold | IBM Plex Sans Thai | Corporate |

## Size Scale (Modular)

### Ratio: 1.25 (Minor Third)
```
Caption:    12px / 0.75rem
Body:       16px / 1rem      ← Base
Large:      20px / 1.25rem
H4:         25px / 1.563rem
H3:         31px / 1.953rem
H2:         39px / 2.441rem
H1:         49px / 3.052rem
Display:    61px / 3.815rem
```

### Quick Reference (Presentation)
| Element | Size | Weight |
|---------|------|--------|
| Slide Title | 36-44pt | Bold |
| Section Header | 24-28pt | SemiBold |
| Body Text | 18-20pt | Regular |
| Caption | 14-16pt | Regular |

## Line Height (Leading)

| Text Type | Line Height |
|-----------|-------------|
| Headlines | 1.1-1.2 |
| Body text | 1.4-1.6 |
| UI text | 1.3-1.4 |

## Letter Spacing (Tracking)

| Use Case | Tracking |
|----------|----------|
| ALL CAPS headlines | +2% to +5% |
| Large display | -1% to -2% |
| Body text | 0 (default) |
| Small text | +1% |

## Line Length

| Context | Characters |
|---------|------------|
| Optimal reading | 50-75 |
| Headlines | 20-40 |
| Mobile | 35-50 |

## Hierarchy Techniques

### Size Only (Preferred)
```
HEADLINE (2-3x body)
Subhead (1.5x body)
Body text at base size
Caption smaller
```

### Weight Variation
```
Bold for headlines
Regular for body
Light for supporting (use sparingly)
```

### Color Variation
```
Black (#0A0A0A) — Primary text
Dark Gray (#4A4A4A) — Secondary
Light Gray (#9A9A9A) — Tertiary/disabled
```

## Common Mistakes

| Mistake | Fix |
|---------|-----|
| Too many fonts | Max 2 (1 display + 1 body) |
| All same size | Create clear hierarchy |
| Centered long text | Left-align paragraphs |
| Too tight line height | 1.4-1.6 for body |
| Fancy fonts for body | Use simple sans-serif |
| ALL CAPS body text | Reserve for short headlines |
