# Sources & Attribution

## Primary Sources (Official Documentation)

### Anthropic (Claude)
- [Claude 4 Best Practices](https://platform.claude.com/docs/en/build-with-claude/prompt-engineering/claude-4-best-practices) — Model-specific optimization
- [XML Tags Guide](https://docs.claude.com/en/docs/build-with-claude/prompt-engineering/use-xml-tags) — Structured prompting
- [System Prompts](https://docs.claude.com/en/docs/build-with-claude/prompt-engineering/system-prompts) — Role prompting
- [Context Engineering](https://www.anthropic.com/engineering/effective-context-engineering-for-ai-agents) — Agent context design
- [Claude Code Best Practices](https://www.anthropic.com/engineering/claude-code-best-practices) — CLAUDE.md guidance

### OpenAI (GPT)
- [Prompt Engineering Guide](https://platform.openai.com/docs/guides/prompt-engineering) — Core techniques
- [GPT-4.1 Prompting Guide](https://cookbook.openai.com/examples/gpt4-1_prompting_guide) — Model-specific tips
- [GPT-5 Prompting Guide](https://cookbook.openai.com/examples/gpt-5/gpt-5_prompting_guide) — Latest model guidance
- [Custom Instructions](https://help.openai.com/en/articles/8096356-chatgpt-custom-instructions) — ChatGPT customization

### Google (Gemini)
- [System Instructions](https://docs.cloud.google.com/vertex-ai/generative-ai/docs/learn/prompts/system-instructions) — Gemini API guidance
- [Gemini 3 Prompting Guide](https://docs.cloud.google.com/vertex-ai/generative-ai/docs/start/gemini-3-prompting-guide) — Latest practices
- [Prompt Design Strategies](https://ai.google.dev/gemini-api/docs/prompting-strategies) — Core techniques

---

## Secondary Sources (Research & Community)

### System vs User Prompt
- [PromptHub: System vs User Messages](https://www.prompthub.us/blog/the-difference-between-system-messages-and-user-messages-in-prompt-engineering)
- [Nebuly: LLM System vs User Prompt](https://www.nebuly.com/blog/llm-system-prompt-vs-user-prompt)
- [PromptLayer: System vs User Guide](https://blog.promptlayer.com/system-prompt-vs-user-prompt-a-comprehensive-guide-for-ai-prompts/)

### CLAUDE.md Optimization
- [Arize: CLAUDE.md Best Practices](https://arize.com/blog/claude-md-best-practices-learned-from-optimizing-claude-code-with-prompt-learning/) — +10% accuracy improvement
- [Claude Blog: Using CLAUDE.md Files](https://claude.com/blog/using-claude-md-files)

### n8n & Workflow Tools
- [n8n AI Agent Prompting](https://medium.com/automation-labs/ai-agent-prompting-for-n8n-the-best-practices-that-actually-work-in-2025-8511c5c16294)
- [n8n Tools AI Agent Docs](https://docs.n8n.io/integrations/builtin/cluster-nodes/root-nodes/n8n-nodes-langchain.agent/tools-agent/)

### Anti-Patterns
- [Prompt Engineering Playbook](https://addyo.substack.com/p/the-prompt-engineering-playbook-for) — Common mistakes
- [DreamHost: 25 Practices Tested](https://www.dreamhost.com/blog/claude-prompt-engineering/)

---

## Developed by ThepExcel

Original contributions:

1. **Consultant-First Workflow** — Discovery → Diagnose → Optimize → Validate
2. **Multi-Platform Support** — Unified framework across Claude, OpenAI, Gemini, n8n
3. **System/User Decision Matrix** — Clear guidance on prompt separation
4. **Platform Comparison Matrix** — Side-by-side platform differences
5. **Scoring System** — Weighted checklist with platform-specific checks

---

**Research Date:** January 2026
**Skill Version:** 2.0.0
**Maintainer:** ThepExcel (github.com/ThepExcel)
