# Sources & Attribution

## Tool & Technology

### Power Query
| Aspect | Source |
|--------|--------|
| Core Technology | Microsoft Power Query (Get & Transform) |
| Official Docs | [Microsoft Power Query Documentation](https://learn.microsoft.com/power-query/) |
| M Language | Microsoft Power Query M Formula Language |

### Data Transformation Concepts
| Concept | Context |
|---------|---------|
| Tidy Data | Hadley Wickham - "Tidy Data" paper |
| Long vs Wide Format | Data normalization principles |
| ETL Patterns | Data engineering best practices |

## Methodology Influences

### Teaching Approach
| Method | Purpose |
|--------|---------|
| Diagnosis-First | Understand problem before solution |
| Goal Visualization | Show desired end state |
| Concept + Action | Explain WHY before HOW |
| Timely Warnings | Prevent common mistakes |

### Coaching Principles
| Principle | Source |
|-----------|--------|
| Scaffolded Learning | Vygotsky's ZPD |
| Guided Discovery | Constructivist pedagogy |
| Progressive Complexity | Instructional design |

## Key References

- [Microsoft Power Query Docs](https://learn.microsoft.com/power-query/)
- [Hadley Wickham - Tidy Data](https://vita.had.co.nz/papers/tidy-data.html)
- ThepExcel.com Power Query tutorials

## Developed by ThepExcel

- Five-phase coaching workflow
- Thai persona design (Nong Fah coach)
- Multi-row headers handling methodology (Method 1 & 2)
- Diagnosis framework and problem patterns
- Best practices for reproducibility
- Common pitfalls documentation
- Real-world examples from Thai business contexts

---

*This skill helps office workers transform messy data into clean, analysis-ready formats using Power Query UI.*
