# The 39 TRIZ Engineering Parameters

Complete reference for the Contradiction Matrix parameters.

## Overview

The 39 parameters describe characteristics that can improve or worsen in a technical system. Use these to identify contradictions.

## Quick Reference Table

| # | Parameter | Description |
|---|-----------|-------------|
| 1 | Weight of moving object | Mass of object in motion |
| 2 | Weight of stationary object | Mass of object at rest |
| 3 | Length of moving object | Linear dimension of moving object |
| 4 | Length of stationary object | Linear dimension of stationary object |
| 5 | Area of moving object | Surface area of moving object |
| 6 | Area of stationary object | Surface area of stationary object |
| 7 | Volume of moving object | 3D space occupied by moving object |
| 8 | Volume of stationary object | 3D space occupied by stationary object |
| 9 | Speed | Velocity of object or process rate |
| 10 | Force | Mechanical interaction (push/pull) |
| 11 | Stress or pressure | Force per unit area |
| 12 | Shape | External contour or appearance |
| 13 | Stability of composition | Integrity of system structure |
| 14 | Strength | Resistance to breaking/deformation |
| 15 | Duration of action (moving) | Service life of moving object |
| 16 | Duration of action (stationary) | Service life of stationary object |
| 17 | Temperature | Thermal condition |
| 18 | Illumination intensity | Light characteristics |
| 19 | Energy use (moving object) | Energy consumed by moving object |
| 20 | Energy use (stationary object) | Energy consumed by stationary object |
| 21 | Power | Energy per unit time |
| 22 | Loss of energy | Waste energy |
| 23 | Loss of substance | Material waste |
| 24 | Loss of information | Data loss |
| 25 | Loss of time | Time waste |
| 26 | Quantity of substance | Amount of material |
| 27 | Reliability | Dependability over time |
| 28 | Measurement accuracy | Precision of measurements |
| 29 | Manufacturing precision | Accuracy of production |
| 30 | External harm to object | Susceptibility to damage |
| 31 | Object-generated harmful factors | Harm produced by object |
| 32 | Ease of manufacture | Simplicity of production |
| 33 | Ease of operation | User-friendliness |
| 34 | Ease of repair | Maintainability |
| 35 | Adaptability/versatility | Ability to change |
| 36 | Device complexity | Number of components |
| 37 | Difficulty of detecting/measuring | Observability |
| 38 | Extent of automation | Self-operation capability |
| 39 | Productivity | Output per unit time |

---

## Detailed Definitions

### Geometric Parameters (1-8)

**1. Weight of moving object**
The mass of an object that moves during operation. Includes objects with temporary or relative motion.
*Examples:* Vehicle, projectile, robotic arm, flowing material

**2. Weight of stationary object**
The mass of an object that doesn't move during its primary function.
*Examples:* Building, bridge, installed equipment, furniture

**3. Length of moving object**
Any linear dimension of a moving object: height, width, depth, diameter.
*Examples:* Length of a train, wingspan of aircraft, height of a crane

**4. Length of stationary object**
Any linear dimension of a non-moving object.
*Examples:* Building height, pipeline length, cable span

**5. Area of moving object**
The outer or cross-sectional surface area of a moving object.
*Examples:* Wing area, tire contact patch, sail area

**6. Area of stationary object**
The surface area of a non-moving object.
*Examples:* Floor space, solar panel area, heat exchanger surface

**7. Volume of moving object**
The cubic measure of a moving object.
*Examples:* Tank capacity, engine displacement, cargo volume

**8. Volume of stationary object**
The cubic measure of a non-moving object.
*Examples:* Building volume, storage tank, room size

---

### Physical Parameters (9-18)

**9. Speed**
The velocity of an object or rate of a process.
*Examples:* Vehicle speed, data transfer rate, production rate, clock speed

**10. Force**
Any mechanical interaction causing motion or deformation.
*Examples:* Lifting force, cutting force, braking force, torque

**11. Stress or pressure**
Force per unit area, tension or compression.
*Examples:* Hydraulic pressure, material stress, atmospheric pressure

**12. Shape**
The external form, contour, or geometric configuration.
*Examples:* Aerodynamic shape, ergonomic design, packaging form

**13. Stability of the object's composition**
The integrity and structural wholeness of a system.
*Examples:* Chemical stability, structural integrity, data integrity

**14. Strength**
The ability to resist breaking, deformation, or wear.
*Examples:* Tensile strength, impact resistance, durability

**15. Duration of action by a moving object**
The time that a moving object can perform its function (service life).
*Examples:* Tool life, battery runtime, tire life

**16. Duration of action by a stationary object**
The time that a stationary object can perform its function.
*Examples:* Building lifespan, road life, equipment life

**17. Temperature**
The thermal condition of the object or environment.
*Examples:* Operating temperature, heat dissipation, thermal limits

**18. Illumination intensity**
Light characteristics: brightness, wavelength, quality.
*Examples:* Display brightness, lighting level, laser power

---

### Energy Parameters (19-22)

**19. Use of energy by moving object**
Energy consumed by or required to move an object.
*Examples:* Fuel consumption, motor power, propulsion energy

**20. Use of energy by stationary object**
Energy consumed by a non-moving object.
*Examples:* Standby power, heating energy, lighting power

**21. Power**
The rate of energy transfer or work done per unit time.
*Examples:* Engine power, processor speed, throughput

**22. Loss of energy**
Waste or dissipation of energy.
*Examples:* Heat loss, friction losses, transmission losses, inefficiency

---

### Resource Parameters (23-26)

**23. Loss of substance**
Waste or loss of material.
*Examples:* Material waste, evaporation, wear debris, scrap

**24. Loss of information**
Partial or total loss of data or signals.
*Examples:* Data corruption, signal loss, memory loss

**25. Loss of time**
Time wasted or inefficiently used.
*Examples:* Waiting time, setup time, delays, downtime

**26. Quantity of substance**
The amount of material in or used by the system.
*Examples:* Material usage, inventory, raw material consumption

---

### Quality Parameters (27-31)

**27. Reliability**
The system's ability to perform consistently over time.
*Examples:* MTBF (mean time between failures), dependability, consistency

**28. Measurement accuracy**
The precision and accuracy of detecting/measuring.
*Examples:* Sensor precision, calibration, resolution

**29. Manufacturing precision**
The accuracy of production processes.
*Examples:* Tolerances, dimensional accuracy, repeatability

**30. External harm affects the object**
Susceptibility to external damaging factors.
*Examples:* Corrosion resistance, shock resistance, environmental protection

**31. Object-generated harmful factors**
Harmful outputs produced by the object.
*Examples:* Emissions, noise, vibration, waste, heat

---

### Usability Parameters (32-39)

**32. Ease of manufacture**
The simplicity and convenience of fabrication.
*Examples:* Manufacturing complexity, assembly difficulty, tooling needs

**33. Ease of operation**
The convenience of using the object.
*Examples:* User-friendliness, learning curve, accessibility

**34. Ease of repair**
The ability to fix, maintain, or service.
*Examples:* Maintainability, serviceability, modular design

**35. Adaptability or versatility**
The ability to respond to external changes or multiple uses.
*Examples:* Flexibility, configurability, multi-purpose

**36. Device complexity**
The number and intricacy of elements.
*Examples:* Part count, system complexity, integration level

**37. Difficulty of detecting and measuring**
The ease of monitoring or measuring the system.
*Examples:* Observability, testability, diagnostic capability

**38. Extent of automation**
The degree of autonomous operation.
*Examples:* Automation level, self-regulation, AI integration

**39. Productivity**
The output or performance per unit time or resource.
*Examples:* Throughput, efficiency, output rate, yield

---

## Common Contradiction Pairs

These parameter pairs frequently conflict:

| Improving | Often Worsens |
|-----------|---------------|
| 9 (Speed) | 1 (Weight), 19 (Energy), 27 (Reliability) |
| 14 (Strength) | 1 (Weight), 36 (Complexity) |
| 27 (Reliability) | 36 (Complexity), 32 (Ease of manufacture) |
| 39 (Productivity) | 25 (Loss of time), 22 (Loss of energy) |
| 33 (Ease of operation) | 36 (Complexity), 35 (Adaptability) |
| 38 (Automation) | 36 (Complexity), 27 (Reliability) |

---

## Tips for Selecting Parameters

1. **Choose the closest match** - If no parameter fits exactly, pick the nearest one
2. **Consider both directions** - The matrix is not symmetrical
3. **Think abstractly** - Parameters apply to any system, not just mechanical
4. **Check related parameters** - Similar parameters may yield different principles
5. **Use multiple pairs** - Complex problems may have multiple contradictions
