# The 40 TRIZ Inventive Principles

Complete reference with examples for each principle.

## Table of Contents

- [Principles 1-10](#principles-1-10)
- [Principles 11-20](#principles-11-20)
- [Principles 21-30](#principles-21-30)
- [Principles 31-40](#principles-31-40)

---

## Principles 1-10

### 1. Segmentation
**Divide an object into independent parts.**

- Divide into independent parts
- Make object easy to disassemble
- Increase degree of fragmentation

**Examples:**
- Modular furniture (IKEA)
- Sectional garage doors
- Modular smartphones
- Containerized shipping
- Microservices architecture (software)
- Venetian blinds vs. solid shade

---

### 2. Taking Out (Extraction)
**Separate an interfering part or property from an object.**

- Extract the "disturbing" part
- Extract only the necessary part

**Examples:**
- Locate noisy compressor outside building
- Use fiber optics to separate hot light source from light location
- Noise-canceling headphones (extract unwanted sound)
- Remove checkout counters → self-service kiosks
- Cloud computing (extract computing from local hardware)

---

### 3. Local Quality
**Change from uniform to non-uniform structure.**

- Make each part fulfill different functions
- Place each part in optimal conditions

**Examples:**
- Pencil with eraser at one end
- Swiss Army knife
- Lunch box with compartments
- Hammer with nail-puller
- Different bristle lengths on toothbrush
- Shark-skin riblets on aircraft to reduce drag

---

### 4. Asymmetry
**Replace symmetrical form with asymmetrical.**

- If already asymmetrical, increase asymmetry

**Examples:**
- Ergonomic mouse (right-handed design)
- Flat spot on cylinder for secure knob attachment
- Asymmetrical tires for better wet traction
- Container ship (bridge at stern)
- Mixing vanes in industrial tanks

---

### 5. Merging (Consolidation)
**Bring together identical or similar objects.**

- Combine in space or time
- Make operations parallel

**Examples:**
- Multi-blade razor
- Computer networks (parallel processing)
- Car-pooling / ride-sharing
- Multi-function printer (print/scan/copy)
- Shopping mall (many stores together)
- Bundled software suites

---

### 6. Universality
**Make a part perform multiple functions.**

- Eliminate need for other parts

**Examples:**
- Sofa bed
- Smartphone (phone + camera + GPS + music player)
- Child car seat that converts to stroller
- Toothbrush handle containing toothpaste
- Swiss Army knife

---

### 7. Nested Doll (Russian Dolls)
**Place one object inside another.**

- One object passes through cavity of another

**Examples:**
- Telescoping antenna
- Stacking chairs
- Measuring cups/spoons
- Retractable landing gear
- Nested software containers
- Foldable shopping bags

---

### 8. Anti-Weight (Counterweight)
**Compensate for object's weight with another force.**

- Use aerodynamic, hydrodynamic, buoyancy

**Examples:**
- Helium balloons for lifting
- Hydrofoils lift boats
- Race car spoilers (aerodynamic downforce)
- Magnetic levitation trains
- Counterweights in elevators

---

### 9. Preliminary Anti-Action
**Perform opposite action in advance.**

- If action has harmful/useful effects, perform counteraction first

**Examples:**
- Pre-stress concrete (compress before tension load)
- Vaccination (introduce weakened pathogen first)
- Backup before software update
- Buffer inventory before demand spike
- Pre-tension cables in suspension bridges

---

### 10. Preliminary Action
**Perform required action in advance.**

- Pre-arrange objects for convenient action

**Examples:**
- Pre-packaged kits (IKEA furniture)
- Pre-loaded software on devices
- Sterilized surgical instruments
- Pre-approved credit
- Just-in-time manufacturing
- Mise en place (cooking preparation)

---

## Principles 11-20

### 11. Beforehand Cushioning
**Prepare emergency means in advance.**

**Examples:**
- Airbags in cars
- Safety nets
- Fuses in electrical systems
- Software exception handling
- Insurance
- Sprinkler systems

---

### 12. Equipotentiality
**Change conditions to eliminate need to raise/lower objects.**

**Examples:**
- Canal locks (bring water to boat level)
- Spring-loaded floor in pool
- Loading dock at truck bed height
- Pit stops in racing (car at work level)
- Adjustable-height desks

---

### 13. The Other Way Round (Inversion)
**Invert the action, make moving parts fixed or vice versa.**

- Turn object upside down

**Examples:**
- Upside-down ketchup bottle
- Moving sidewalk (people stay still)
- Rotate workpiece instead of tool
- Self-checkout (customer does work)
- Running on treadmill (stationary running)
- Rotisserie (rotate food, not heat source)

---

### 14. Spheroidality (Curvature)
**Replace linear with curved, flat with spherical.**

- Use rollers, balls, spirals
- Replace linear motion with rotational

**Examples:**
- Ball bearings
- Arched doorways (stronger than rectangular)
- Curved computer monitors
- Scroll wheel on mouse
- Spiral staircases
- Dome structures

---

### 15. Dynamics
**Allow characteristics to change for optimal performance.**

- Divide into parts that can move relative to each other

**Examples:**
- Adjustable steering wheel
- Bifocal glasses (two focal lengths)
- Flexible shower hose
- Articulated bus
- Dynamic pricing
- Auto-adjusting suspension

---

### 16. Partial or Excessive Action
**If 100% is hard to achieve, use slightly less or more.**

**Examples:**
- Overspray when painting, sand off excess
- Fill tire with extra air, release to exact pressure
- Over-estimate project time, deliver early
- Rough machining before precision finishing
- Spray insulation, trim to shape

---

### 17. Another Dimension
**Move in 2D instead of 1D, 3D instead of 2D.**

- Use multi-story arrangement
- Tilt or reorient object

**Examples:**
- Multi-level parking garage
- Spiral staircase vs. straight
- CD vs. tape (2D vs. 1D storage)
- 3D printing
- Vertical farming
- Multi-lane highways

---

### 18. Mechanical Vibration
**Use oscillation or vibration.**

- Increase frequency (ultrasonic)
- Use resonance

**Examples:**
- Ultrasonic cleaning
- Electric toothbrush
- Jackhammer
- Vibrating concrete to remove air bubbles
- Massage chairs
- Piezoelectric energy harvesting

---

### 19. Periodic Action
**Replace continuous with periodic/pulsating action.**

- Use pauses between impulses for additional action

**Examples:**
- Pulsating sprinkler (vs. continuous)
- Flashing warning lights
- Interval training (exercise)
- Batch processing
- Intermittent windshield wipers
- PWM (pulse-width modulation)

---

### 20. Continuity of Useful Action
**Carry out action continuously, eliminate idle time.**

- All parts working at full capacity

**Examples:**
- Flywheel stores energy during idle
- Continuous flow manufacturing
- 24/7 operations
- Printing on both sides of paper
- Multi-tasking CPUs
- Regenerative braking

---

## Principles 21-30

### 21. Skipping (Rushing Through)
**Conduct harmful/dangerous operations at high speed.**

**Examples:**
- High-speed dental drill (less heat transfer)
- Laser surgery (minimal tissue damage)
- Flash pasteurization
- Quick-freezing food
- High-speed photography
- Explosive welding

---

### 22. Blessing in Disguise (Convert Harm to Benefit)
**Use harmful factors to achieve positive effect.**

- Amplify harmful factor until it becomes useful

**Examples:**
- Use waste heat for electricity (cogeneration)
- Controlled burns prevent wildfires
- Vaccines use weakened pathogens
- Noise-canceling uses noise to cancel noise
- Composting waste
- Judo (use opponent's force)

---

### 23. Feedback
**Introduce feedback to improve action.**

- If feedback exists, change its magnitude

**Examples:**
- Thermostat
- Cruise control
- Auto-focus camera
- Statistical process control
- Customer reviews
- A/B testing
- Agile retrospectives

---

### 24. Intermediary
**Use intermediate object to transfer action.**

- Temporarily connect objects

**Examples:**
- Catalyst in chemical reaction
- Carpenter's nail set
- Belt or chain drive
- API (application programming interface)
- Travel agent / broker
- Translator / interpreter

---

### 25. Self-Service
**Make object serve/repair itself.**

- Use waste resources

**Examples:**
- Self-cleaning oven
- Self-healing materials
- Self-sharpening lawn mower blades
- Auto-scaling cloud servers
- Plants that fertilize themselves (nitrogen fixation)
- Regenerative braking

---

### 26. Copying
**Use simple, inexpensive copies instead of expensive original.**

- Replace with optical copy (can scale)

**Examples:**
- Crash test dummies
- Wind tunnel models
- Digital twins
- Prototype before production
- Virtual reality training
- Photo of signature vs. hand-signing

---

### 27. Cheap Short-Living Objects
**Replace expensive with many cheap, disposable objects.**

**Examples:**
- Disposable diapers
- Paper cups at water cooler
- Disposable medical instruments
- Fast fashion
- Single-use pods (coffee, detergent)
- Throwaway prototypes

---

### 28. Mechanics Substitution
**Replace mechanical with optical, acoustic, thermal, etc.**

**Examples:**
- Optical mouse (vs. ball mouse)
- Electric fence (vs. physical barrier)
- Induction heating
- Wireless charging
- Voice recognition (vs. keyboard)
- Gesture control

---

### 29. Pneumatics and Hydraulics
**Use gas or liquid instead of solid parts.**

**Examples:**
- Inflatable furniture
- Hydraulic jack
- Air mattress
- Pneumatic tools
- Bubble wrap
- Hovercraft

---

### 30. Flexible Shells and Thin Films
**Use flexible shells, thin films, membranes.**

**Examples:**
- Inflatable structures
- Gore-Tex fabric
- Bubble wrap
- Shrink wrap
- Screen protectors
- Vacuum packaging

---

## Principles 31-40

### 31. Porous Materials
**Make object porous or add porous elements.**

- Fill pores with useful substance

**Examples:**
- Sponge
- Foam insulation
- Aerated chocolate
- Sintered metal filters
- Porous pavement (drainage)
- Aerogel insulation

---

### 32. Color Changes
**Change color or transparency for monitoring.**

- Use color additives or luminescent

**Examples:**
- Temperature-indicating strips
- Litmus paper (pH indicator)
- Mood rings
- UV-sensitive sunglasses
- Food freshness indicators
- Highlighter pens

---

### 33. Homogeneity
**Make objects interacting with main object from same material.**

**Examples:**
- Ice container made of ice
- Chocolate box made of chocolate
- Diamond cutting tools for diamonds
- Wooden dowels in wood joinery
- Same programming language for full stack

---

### 34. Discarding and Recovering
**Make portions that have fulfilled function disappear.**

- Restore consumable parts during operation

**Examples:**
- Dissolving stitches
- Rocket stage separation
- Self-erasing whiteboard markers
- Biodegradable packaging
- Evaporating dry ice
- Sacrificial anodes

---

### 35. Parameter Changes
**Change physical state, concentration, flexibility, temperature.**

**Examples:**
- Freeze food for transport
- LNG (liquefied natural gas)
- Freeze-drying
- Frozen nitrogen for surgery
- Concentrate juice for shipping
- Shape-memory alloys

---

### 36. Phase Transitions
**Use phenomena during phase transitions (expansion, heat release).**

**Examples:**
- Ice cubes cool drinks (melting absorbs heat)
- Steam power
- Heat packs (crystallization releases heat)
- Frost heaving (can be harmful or useful)
- Evaporative cooling

---

### 37. Thermal Expansion
**Use thermal expansion or contraction.**

- Use materials with different expansion coefficients

**Examples:**
- Bimetallic strip thermostat
- Shrink-fit assembly
- Expansion joints in bridges
- Thermometer
- Thermal switch

---

### 38. Strong Oxidants
**Use enriched atmospheres or strong oxidizing agents.**

**Examples:**
- Oxygen-enriched welding
- Hyperbaric oxygen therapy
- Ozone for water treatment
- Hydrogen peroxide bleaching
- Pure oxygen in hospitals

---

### 39. Inert Atmosphere
**Replace normal environment with inert one.**

**Examples:**
- Nitrogen packaging for chips
- Argon welding
- Nitrogen-filled tires
- Inert gas fire suppression
- Vacuum packaging

---

### 40. Composite Materials
**Change from uniform to composite materials.**

**Examples:**
- Carbon fiber reinforced plastic
- Reinforced concrete
- Plywood
- Fiberglass
- Gore-Tex (multiple layers)
- Sandwich panels

---

## Principle Groups by Function

### Adding Something
1, 3, 7, 24, 31, 40

### Removing Something
2, 27, 34

### Changing Something
4, 6, 13, 14, 15, 17, 28, 32, 35, 36, 37

### Using Resources
22, 25, 38, 39

### Timing/Sequence
9, 10, 11, 19, 20, 21

### Dynamics/Flexibility
5, 15, 18, 29, 30

### Substitution/Copying
26, 27, 28, 33
