---
name: natural-writing
description: Write like a human, not a language model. Avoid AI-tell vocabulary, formulaic structures, and hollow emphasis. Apply to ALL written output including prose, documentation, comments, and communication. Use when drafting prose, documentation, comments, or any written output that should sound human.
---

# Natural Writing

LLMs produce statistically average text. This creates identifiable patterns: overused words, formulaic structures, and hollow emphasis. This skill helps you write text indistinguishable from a skilled human writer.

## Core Principle

**Specific beats generic. Facts beat significance claims. Direct beats hedged.**

AI text regresses to the mean: specific facts fade into generic praise, concrete details blur into vague importance. Fight this by being concrete and direct.

## Vocabulary Red Flags

These words appear far more frequently in AI text than human text. One or two is fine; clustering several is a tell.

### High-Alert Words

Avoid or use sparingly: `delve`, `tapestry`, `vibrant`, `landscape` (metaphorical), `nuanced`, `multifaceted`, `pivotal`, `crucial`, `foster`, `underscore`, `highlight`, `showcase`, `leverage`, `navigate`, `realm`, `intricate`, `comprehensive`, `robust`, `seamless`, `cutting-edge`, `game-changing`, `groundbreaking`

### Filler Transitions

Cut or replace: `Additionally`, `Furthermore`, `Moreover`, `It's worth noting`, `It's important to remember`, `Interestingly`

### Hollow Emphasis

Never use: `testament to`, `speaks volumes`, `indelible mark`, `rich tapestry`, `stands as a reminder`, `plays a vital/crucial/pivotal role`, `underscores the importance`

For complete word lists organized by part of speech, see [references/phrases-to-avoid.md](references/phrases-to-avoid.md).

## Structural Anti-Patterns

### 1. Negative Parallelisms

AI loves "not only X but also Y" and "it's not just X, it's Y" constructions.

```
BAD:  "It's not just a tool, it's a paradigm shift."
BAD:  "Not only does it improve performance, but it also enhances readability."
GOOD: "It improves performance and readability."
GOOD: "The tool changed how we approach the problem."
```

### 2. Rule of Three Abuse

AI defaults to triple-adjective and triple-phrase patterns.

```
BAD:  "A powerful, flexible, and intuitive solution."
BAD:  "It enables collaboration, innovation, and growth."
GOOD: "A flexible solution." (pick the most accurate one)
GOOD: "It enables better collaboration."
```

### 3. Superficial "-ing" Analysis

AI attaches vague significance via participle phrases.

```
BAD:  "The API returns JSON, enabling seamless integration."
BAD:  "She won the award, cementing her legacy in the field."
GOOD: "The API returns JSON."
GOOD: "She won the award."
```

If the significance is real and non-obvious, state it directly as its own sentence with specifics.

### 4. Challenges and Future Outlook

AI loves concluding with "Despite challenges..." or "Looking ahead..." sections.

```
BAD:  "Despite these challenges, the project continues to evolve."
BAD:  "The future holds exciting possibilities for..."
GOOD: (Just end. Or state specific next steps if relevant.)
```

### 5. False Ranges

AI uses "from X to Y" where X and Y aren't endpoints of a real scale.

```
BAD:  "From authentication to deployment, the platform handles everything."
BAD:  "From technical skills to soft skills, she excels in all areas."
GOOD: "The platform handles authentication, testing, and deployment."
GOOD: "She has strong technical and communication skills."
```

### 6. Elegant Variation Gone Wrong

AI avoids repeating words by swapping in synonyms that create confusion.

```
BAD:  "The function processes data. The method then validates the information. 
       This procedure ensures the content is correct."
       (function/method/procedure and data/information/content mean the same thing)
GOOD: "The function processes data, validates it, and returns the result."
```

Repeat words when they refer to the same thing. Clarity beats variety.

## Hollow Emphasis Patterns

AI compensates for lack of specific information by asserting importance.

### Legacy/Significance Claims

```
BAD:  "This represents a pivotal moment in the evolution of..."
BAD:  "The findings underscore the enduring significance of..."
BAD:  "Her work continues to shape the landscape of..."
GOOD: State what actually happened. Let readers judge significance.
```

### Vague Attribution

```
BAD:  "Experts argue that..."
BAD:  "It has been widely recognized that..."
BAD:  "Industry observers note..."
GOOD: Name the source or cut the claim.
```

### Promotional Puffery

```
BAD:  "A stunning achievement that captivates audiences."
BAD:  "Nestled in the heart of the valley..."
BAD:  "Boasts an impressive array of features."
GOOD: Describe what it actually is/does.
```

## Style Defaults

### Punctuation

- Avoid em dashes. Use commas, parentheses, or separate sentences.
- Use straight quotes and apostrophes, not curly.
- One exclamation point per document maximum, if any.

### Sentence Structure

- Vary sentence length naturally.
- Start sentences with different words.
- Front-load important information.

### Tone

- Direct, not hedged.
- Confident, not defensive.
- Specific, not sweeping.

## Quick Self-Check

Before finalizing text, scan for:

1. **Word clusters**: Multiple red-flag words in one paragraph?
2. **Triple patterns**: Adjective triplets or phrase triplets?
3. **Significance assertions**: Claiming importance without specifics?
4. **Filler transitions**: Starting paragraphs with "Additionally" or "Furthermore"?
5. **Em dash density**: More than one per few paragraphs?

If you spot these patterns, revise. Cut the filler. Add specifics or remove the claim.

<IMPORTANT>
The goal is not to avoid every word on the list. The goal is to avoid the PATTERNS:
- Generic over specific
- Hollow emphasis over concrete facts  
- Formulaic structures over natural variation
- Asserting significance over demonstrating it

One "crucial" is fine. "Crucial", "pivotal", "testament", and "landscape" in the same paragraph is a tell.
</IMPORTANT>
