# Demo Action Items - [Demo Name/Date]

## High Priority

- [ ] **[Task Title]**
  - **Assignee**: [Name or Team]
  - **Deadline**: [Date or "TBD"]
  - **Category**: [Bug/Feature/Improvement/Documentation]
  - **Description**: [Detailed description of what needs to be done]
  - **Context**: [Relevant notes from demo - why this matters]
  - **Acceptance Criteria**:
    - [ ] [Criteria 1]
    - [ ] [Criteria 2]

## Medium Priority

- [ ] **[Task Title]**
  - **Assignee**: [Name]
  - **Deadline**: [Date]
  - **Category**: [Category]
  - **Description**: [Details]
  - **Context**: [Background]

## Low Priority

- [ ] **[Task Title]**
  - **Assignee**: [Name]
  - **Deadline**: [Date]
  - **Category**: [Category]
  - **Description**: [Details]

## Follow-up Questions

- [ ] **[Question to clarify]**
  - **Who to ask**: [Person or team]
  - **Context**: [Why this question came up]
  - **Blocking**: [Yes/No - is this blocking other work?]

## Notes

- **Demo Date**: [Date]
- **Attendees**: [List of attendees]
- **Demo Focus**: [What was demonstrated]
- **Overall Feedback**: [General feedback]
- **Decisions Made**: [Any decisions or agreements]

---

## Usage Instructions

### How to Use This Template

1. **Copy this template** for each demo or meeting
2. **Fill in the header** with demo name and date
3. **Add tasks** under appropriate priority sections
4. **Include all metadata** (assignee, deadline, category, etc.)
5. **Add context** so tasks make sense without the original notes

### Priority Guidelines

- **High**: Blocking bugs, critical features, security issues, urgent requests
- **Medium**: Important features, non-blocking bugs, planned improvements
- **Low**: Nice-to-haves, cosmetic issues, future enhancements

### Category Definitions

- **Bug**: Something that doesn't work as expected
- **Feature**: New functionality requested
- **Improvement**: Enhancement to existing feature
- **Documentation**: Docs, guides, or help text updates
- **Design**: UI/UX changes
- **Investigation**: Research or technical spike

### Best Practices

- Use **bold** for task titles to make them stand out
- Include **deadlines** even if approximate
- Add **context** from the demo so tasks are understandable later
- Use **checkboxes** (`- [ ]`) for easy progress tracking
- Group related tasks together
- Keep descriptions concise but informative
