# Basic Theme

## Overview
The Basic theme provides simple, no-frills black and white styling. Perfect for quick conversions, print-ready documents, and maximum compatibility.

## Use Cases
- Quick conversions
- Print-ready documents
- Maximum compatibility needs
- Simple notes and memos
- Draft documents
- Black and white printing

## Font Specifications

### Body Text
- **Font**: Liberation Serif
- **Size**: 11pt
- **Line Spacing**: 1.0 (single)

### Headings
- **Font**: Liberation Serif (Bold)
- **H1**: 18pt
- **H2**: 14pt
- **H3**: 12pt

### Code
- **Font**: Liberation Mono
- **Size**: Proportional to body text

## Color Palette

### Primary Colors
- **Primary**: #000000 (Pure Black)
- **Text**: #000000 (Pure Black)
- **Headings**: #000000 (Pure Black)
- **Background**: #ffffff (Pure White)

### Table Colors
- **Header Background**: #ffffff (White)
- **Header Text**: #000000 (Black)
- **Rows**: #ffffff (No alternation)

## Layout Settings

### Page Margins
- **Top**: 2.5cm
- **Bottom**: 2.5cm
- **Left**: 2.5cm
- **Right**: 2.5cm

### Spacing
- **Line Spacing**: 1.0 (single)
- **Paragraph Spacing**: 1em

## Table Styling

### Features
- Black borders only
- Bold header text
- No background colors
- No row alternation
- Simple, clean lines

### Visual Appearance
- High contrast (black on white)
- Print-optimized
- No color dependencies
- Universal compatibility
- Clear and simple

## Slovak Diacritics Support

### Test String
```
Príliš žltý kôň úpel ďábelské ódy
```

### All Slovak Characters
- **Lowercase**: á ä č ď é í ĺ ľ ň ó ô ŕ š ť ú ý ž
- **Uppercase**: Á Ä Č Ď É Í Ĺ Ľ Ň Ó Ô Ŕ Š Ť Ú Ý Ž

### Font Support
Liberation Serif fully supports all Slovak diacritical marks with excellent print quality.

## Output Formats

### PDF
- Simple, clean typography
- Print-optimized
- Minimal file size
- Universal compatibility

### DOCX
- Editable Word document
- Basic styling
- Maximum compatibility

### HTML
- Responsive design (max-width: 900px)
- Mobile-optimized
- Self-contained (embedded CSS)
- Print-friendly

## Special Features

### Print Optimization
- Pure black text for clarity
- No color ink required
- Clean, sharp output
- Excellent photocopying

### Compatibility
- Works with any printer
- No color dependencies
- Universal font support
- Minimal rendering issues

## Example Output Description

Documents using the Basic theme have:
- Simple black headings with clear hierarchy
- Clean, readable body text
- Tables with solid black borders
- No color styling or accents
- Maximum print compatibility
- Universal, no-frills appearance
- Excellent for drafts and quick conversions
