# Minimalist Theme

## Overview
The Minimalist theme embodies clean, modern design with emphasis on whitespace and simplicity. Perfect for portfolios, design-focused documents, and contemporary presentations.

## Use Cases
- Modern portfolios
- Design presentations
- Clean reports
- Contemporary documentation
- Creative briefs

## Font Specifications

### Body Text
- **Font**: Liberation Sans
- **Size**: 10pt
- **Line Spacing**: 1.5 (generous)

### Headings
- **Font**: Liberation Sans (Bold)
- **H1**: 22pt
- **H2**: 16pt
- **H3**: 13pt

### Code
- **Font**: Liberation Mono
- **Size**: Proportional to body text

## Color Palette

### Primary Colors
- **Primary Accent**: #333333 (Dark Gray)
- **Text**: #333333 (Dark Gray)
- **Headings**: #000000 (Pure Black)

### Table Colors
- **Header Background**: #f0f0f0 (Light Gray)
- **Header Text**: #000000 (Black)
- **Rows**: #ffffff (No alternation)

## Layout Settings

### Page Margins
- **Top**: 3cm (extra spacious)
- **Bottom**: 3cm
- **Left**: 2.5cm
- **Right**: 2.5cm

### Spacing
- **Line Spacing**: 1.5 (generous)
- **Paragraph Spacing**: 1em

## Table Styling

### Features
- Light gray header (#f0f0f0)
- Thin borders
- No row alternation (clean look)
- Bold header text
- Minimal visual weight

### Visual Appearance
- Ultra-clean aesthetic
- Whitespace-focused
- Modern and uncluttered
- Subtle, refined styling

## Slovak Diacritics Support

### Test String
```
Príliš žltý kôň úpel ďábelské ódy
```

### All Slovak Characters
- **Lowercase**: á ä č ď é í ĺ ľ ň ó ô ŕ š ť ú ý ž
- **Uppercase**: Á Ä Č Ď É Í Ĺ Ľ Ň Ó Ô Ŕ Š Ť Ú Ý Ž

### Font Support
Liberation Sans fully supports all Slovak diacritical marks with crisp, clean rendering.

## Output Formats

### PDF
- Clean, minimal typography
- Print-ready with generous margins
- Embedded fonts

### DOCX
- Editable Word document
- Style preservation
- Modern aesthetic

### HTML
- Responsive design (max-width: 900px)
- Mobile-optimized
- Self-contained (embedded CSS)
- Ultra-clean appearance

## Example Output Description

Documents using the Minimalist theme have:
- Black headings with clear hierarchy
- Generous whitespace for breathing room
- Tables with subtle gray headers
- Clean, uncluttered appearance
- Modern, design-forward aesthetic
- Excellent readability through simplicity
