# Professional Theme

## Overview
The Professional theme is designed for business reports, formal documents, and client deliverables. It features deep blue headings, formal typography, and polished table styling.

## Use Cases
- Business reports and proposals
- Client-facing deliverables
- Corporate documentation
- Formal presentations
- Executive summaries

## Font Specifications

### Body Text
- **Font**: Liberation Serif
- **Size**: 11pt
- **Line Spacing**: 1.15

### Headings
- **Font**: Liberation Serif (Bold)
- **H1**: 24pt
- **H2**: 18pt
- **H3**: 14pt

### Code
- **Font**: Liberation Mono
- **Size**: Proportional to body text

## Color Palette

### Primary Colors
- **Primary Accent**: #1a237e (Deep Blue)
- **Text**: #212121 (Near Black)
- **Headings**: #1a237e (Deep Blue)

### Table Colors
- **Header Background**: #1a237e (Deep Blue)
- **Header Text**: #ffffff (White)
- **Alternating Rows**: #f5f5f5 (Light Gray)

## Layout Settings

### Page Margins
- **Top**: 2.5cm
- **Bottom**: 2.5cm
- **Left**: 3cm (wider for binding)
- **Right**: 3cm

### Spacing
- **Line Spacing**: 1.15
- **Paragraph Spacing**: 1em

## Table Styling

### Features
- Deep blue header with white text
- Solid borders
- Alternating row colors (#f5f5f5/#ffffff)
- Bold header text
- 12px padding in cells

### Visual Appearance
- Professional and polished
- High contrast for readability
- Formal business aesthetic

## Slovak Diacritics Support

### Test String
```
Príliš žltý kôň úpel ďábelské ódy
```

### All Slovak Characters
- **Lowercase**: á ä č ď é í ĺ ľ ň ó ô ŕ š ť ú ý ž
- **Uppercase**: Á Ä Č Ď É Í Ĺ Ľ Ň Ó Ô Ŕ Š Ť Ú Ý Ž

### Font Support
Liberation Serif fully supports all Slovak diacritical marks with proper rendering.

## Output Formats

### PDF
- High-quality typography
- Print-ready formatting
- Embedded fonts for portability

### DOCX
- Editable Word document
- Style preservation
- Compatible with Microsoft Word

### HTML
- Responsive design (max-width: 900px)
- Mobile-optimized
- Self-contained (embedded CSS)
- Print-friendly

## Example Output Description

Documents using the Professional theme have:
- Prominent deep blue headings that establish hierarchy
- Clean, readable body text with generous line spacing
- Tables with bold blue headers and subtle row alternation
- Professional margins suitable for printing and binding
- Consistent, polished appearance throughout
