# Technical Theme

## Overview
The Technical theme is optimized for API documentation, technical specifications, and developer guides. Features dark slate colors, monospace code blocks, and developer-friendly styling.

## Use Cases
- API documentation
- Technical specifications
- Developer guides
- Code documentation
- Software manuals
- Technical reports

## Font Specifications

### Body Text
- **Font**: Liberation Sans
- **Size**: 10pt
- **Line Spacing**: 1.3 (compact)

### Headings
- **Font**: Liberation Sans (Bold)
- **H1**: 20pt
- **H2**: 16pt
- **H3**: 13pt

### Code
- **Font**: Liberation Mono
- **Size**: 0.9em (relative)
- **Background**: #f5f5f5 (Light Gray)

## Color Palette

### Primary Colors
- **Primary Accent**: #00897b (Teal)
- **Text**: #212121 (Near Black)
- **Headings**: #263238 (Dark Slate)

### Table Colors
- **Header Background**: #263238 (Dark Slate)
- **Header Text**: #ffffff (White)
- **Alternating Rows**: #f5f5f5 (Light Gray)

### Code Blocks
- **Background**: #f5f5f5 (Light Gray)
- **Border**: #ddd
- **Syntax Highlighting**: Supported

## Layout Settings

### Page Margins
- **Top**: 2cm (compact)
- **Bottom**: 2cm
- **Left**: 2cm
- **Right**: 2cm

### Spacing
- **Line Spacing**: 1.3 (compact for technical content)
- **Paragraph Spacing**: 1em

## Table Styling

### Features
- Dark slate header (#263238)
- White header text
- Solid borders
- Alternating row colors
- Monospace-friendly for data

### Visual Appearance
- Developer-focused
- Syntax-friendly styling
- Dark accents for technical feel
- Clear data presentation

## Code Block Styling

### Features
- Light gray background (#f5f5f5)
- 15px padding
- Rounded corners (5px)
- Horizontal scroll for long lines
- Border for definition

### Inline Code
- Light gray background
- 2px-6px padding
- Rounded corners
- Monospace font

## Slovak Diacritics Support

### Test String
```
Príliš žltý kôň úpel ďábelské ódy
```

### All Slovak Characters
- **Lowercase**: á ä č ď é í ĺ ľ ň ó ô ŕ š ť ú ý ž
- **Uppercase**: Á Ä Č Ď É Í Ĺ Ľ Ň Ó Ô Ŕ Š Ť Ú Ý Ž

### Font Support
Liberation Sans and Liberation Mono fully support all Slovak diacritical marks.

## Output Formats

### PDF
- Code-friendly typography
- Compact layout
- Print-ready for technical docs

### DOCX
- Editable Word document
- Monospace code preservation
- Technical styling

### HTML
- Responsive design (max-width: 900px)
- Mobile-optimized code blocks
- Self-contained (embedded CSS)
- Syntax-highlighting ready

## Example Output Description

Documents using the Technical theme have:
- Dark slate headings for technical authority
- Monospace code blocks with syntax highlighting
- Tables with dark headers optimized for data
- Compact layout for information density
- Developer-friendly aesthetic
- Clear visual separation between code and text
