# Technická Dokumentácia

## Úvod

Príliš žltý kôň úpel ďábelské ódy.

Toto je ukážkový dokument s **plnou podporou** slovenskej diakritiky. Obsahuje všetky slovenské znaky vrátane špeciálnych písmen ako ľ, š, č, ť, ž, ý, á, í, é, ú, ä, ô, ň, ď, ŕ, ĺ.

## Zoznam Vlastností

- **Plná podpora diakritiky**: á ä č ď é í ĺ ľ ň ó ô ŕ š ť ú ý ž
- **Tri výstupné formáty**: PDF, DOCX, HTML
- **Štyri profesionálne témy**: Professional, Minimalist, Technical, Basic
- **Dávkové spracovanie**: Konverzia celých adresárov naraz

## Príklad Tabuľky

| Názov | Popis | Hodnota | Poznámka |
|-------|-------|---------|----------|
| Prvý riadok | S diakritikou | 100 | Ľahko čitateľné |
| Druhý riadok | Špeciálne znaky: ľščťžýáíé | 200 | Správne zobrazené |
| Tretí riadok | Všetky znaky fungujú | 300 | Žiadny problém |
| Štvrtý riadok | Príliš žltý kôň | 400 | Testovacia veta |

## Príklad Kódu

```python
def pozdrav_slovensky():
    """
    Funkcia na pozdravenie v slovenčine
    """
    text = "Dobrý deň!"
    print(text)

    # Test slovenskej diakritiky
    test = "Príliš žltý kôň úpel ďábelské ódy"
    return test
```

## Viacúrovňové Nadpisy

### Tretia Úroveň

Táto časť demonštruje nadpisy tretej úrovne s diakritickými znamienkami.

#### Štvrtá Úroveň

A toto je príklad nadpisu štvrtej úrovne. Všetky znaky sa správne zobrazujú.

## Citát

> "Vzdelanie je najlepšia investícia do budúcnosti."
>
> - Slovenské príslovie

## Záver

Tento dokument úspešne demonštruje plnú podporu slovenského jazyka v systéme **tmq-markdown2anything**.

**Dôležité**: Všetky znaky vrátane ľ, š, č, ť, ž, ý, á, í, é, ú, ä, ô, ň, ď, ŕ, ĺ sú správne zakódované v UTF-8 a budú sa zobrazovať korektne vo všetkých výstupných formátoch.

---

*Vytvorené pomocou tmq-markdown2anything*
