# Tomáš Vince - Writing Style Guide

## Voice & Tone

### Core Characteristics
- **Authentic & Genuine** - Sounds like a real person, not marketing copy
- **Motivational** - Inspires action and positive change
- **Thoughtful** - Considers multiple angles, shows nuance
- **Conversational** - Direct, uses "you", like talking to a friend
- **Expert but Accessible** - Technical knowledge without jargon overload

### Tone Variations by Language

**Slovak:**
- More personal and direct
- Use "ty" form (informal)
- Mix of emotion and professionalism
- Comfortable with Slovak-English tech terms mix
- Slightly more expressive with emojis

**English:**
- Professional yet friendly
- More global perspective
- Technical but clear
- Authoritative without being arrogant

## Sentence Structure

### Variety is Key
- **Short punchy sentences** for impact
- Longer explanatory sentences for context
- Single-word paragraphs. Sometimes.
- Questions to engage thinking

### Example Flow:
```
Short statement. Boom. 💥
Now a longer sentence that explains the context and adds necessary detail.
Another punchy one.
See how it creates rhythm?
```

## Word Choice

### Prefer:
- Simple over complex: "use" not "utilize", "help" not "facilitate"
- Active voice: "I implemented" not "it was implemented"
- Concrete over abstract: "saved 3 hours" not "increased efficiency"
- Specific over vague: "AWS Lambda" not "serverless solution"

### Embrace:
- Contractions: I'm, you'll, it's, that's
- Direct address: "you", "your"
- Personal pronouns: "I", "we", "my team"
- Tech terms when appropriate: cloud, deploy, automation (no need to explain basics)

## Authenticity Markers

### What Makes It Sound Human:

**1. Vulnerability**
```
❌ "Successfully implemented solution"
✅ "Tried 3 approaches. First two failed. Here's what worked."
```

**2. Specific Details**
```
❌ "Improved performance significantly"
✅ "Reduced load time from 3.2s to 400ms"
```

**3. Real Emotions**
```
❌ "Encountered a challenge"
✅ "Woke up at 3 AM. Production was down. Panic mode."
```

**4. Honest Mistakes**
```
❌ "Optimized the approach"
✅ "I was wrong. Admitted it. Changed direction."
```

## Engagement Techniques

### Opening Hooks
- Start with conflict, surprise, or question
- Personal moment or scenario
- Controversial statement (backed by experience)
- Relatable pain point

### Throughout Post
- Ask rhetorical questions
- Use examples with numbers
- Include "you" statements
- Break up text visually

### Closing
- Always end with engagement invitation
- Specific question, not "what do you think?"
- Request for experiences
- Challenge or prediction

## Formatting Preferences

### Emojis
- **Use:** 2-4 per post
- **Strategic placement:**
  - 💡 Insights
  - 🚀 Results/growth
  - ⚠️ Warnings/important
  - ✅ Success/tips
  - 🤔 Questions/thinking
  - 🔧 Technical/implementation
  - 💸 Costs/money
- **Avoid:** Overuse, irrelevant emojis, emoji sentences

### Bold Text
- **Key points** or main takeaways
- **Important terms** first mention
- **Numbers** for emphasis (sometimes)
- Don't overuse - loses impact

### Paragraph Structure
- 1-3 sentences per paragraph
- Blank line between paragraphs
- Occasional single-line paragraph for impact
- Lists (bullets or numbers) for steps/options

## Content Philosophy

### Add Value Always
Every post should:
- Teach something practical
- Share real experience
- Provoke new thinking
- Inspire action
- Start discussion

### Be Specific
```
❌ "Cloud optimization is important"
✅ "Last month: optimized data flow patterns. Same infrastructure, 45% cost reduction."
```

### Show, Don't Tell
```
❌ "I'm experienced in cloud architecture"
✅ "Migrated 3 enterprises from on-prem to multi-cloud this year. Here's what I learned..."
```

### Balance Technical & Human
- Technical details when relevant
- Human impact always included
- Explain "what" and "why"
- Connect technology to outcomes

## Topics & Themes

### Core Expertise Areas
1. **Cloud Architecture** - Multi-cloud, AWS, Azure, GCP, migrations
2. **IoT & Edge** - Smart devices, edge computing, IIoT
3. **AI & Automation** - AI agents, no-code/low-code, productivity
4. **Digital Transformation** - Modernization, efficiency, change management

### Content Angles
- **Real Projects** - Specific client work (anonymized)
- **Lessons Learned** - What worked, what didn't
- **Technical Tips** - Practical how-tos
- **Industry Commentary** - Trends, predictions, analysis
- **Team & Leadership** - Building, managing, learning

## Common Patterns

### Problem → Solution → Result
```
[Faced this challenge]
[Tried this approach]
[Got this outcome]
[Here's the lesson]
```

### Observation → Insight → Action
```
[Noticed this pattern]
[Here's what it means]
[What you can do about it]
```

### Question → Analysis → Perspective
```
[Everyone asks X]
[Here's the nuance]
[My take based on experience]
```

## Quality Checks

### Before Publishing Ask:
- [ ] Does it sound like me? (authentic voice)
- [ ] Would I say this out loud? (conversational)
- [ ] Is there specific value? (not just opinion)
- [ ] Are there concrete examples? (not just theory)
- [ ] Would someone comment? (engagement-worthy)
- [ ] Is it scannable on mobile? (formatting)
- [ ] No AI-tell phrases? (human-written)

## Don'ts

❌ Corporate speak: "leverage synergies"
❌ Buzzword soup: "disruptive paradigm shift"
❌ Humble brags: "humbled by this award"
❌ Vagueness: "great experience"
❌ ALL CAPS: (except acronyms)
❌ Excessive emojis: 🎉🎊🥳🎈🎁
❌ Generic CTAs: "thoughts?"
❌ No personality: pure facts without perspective

## Examples of Voice

### Good (Authentic):
```
"Spent 6 hours debugging. Found the issue was a typo.
In a config file. That wasn't in version control.
Lessons learned: 1) Always version everything. 2) Coffee doesn't solve everything."
```

### Bad (Too Corporate):
```
"Successfully implemented a comprehensive debugging methodology
which facilitated the identification and resolution of configuration-based deployment challenges."
```

### Good (Specific):
```
"Migrated 47 microservices to Kubernetes last quarter.
Cost: $12K/month → $6.5K/month.
Downtime during migration: 0."
```

### Bad (Vague):
```
"Successfully completed a significant infrastructure modernization initiative
with impressive cost savings and minimal disruption."
```

---

Remember: Write like you talk. Be specific. Add value. Stay authentic.
