# The Power of Dividend Growth Compounding

## Core Concept: Yield on Cost vs. Current Yield

**Current Yield:** What a stock yields today based on today's price
**Yield on Cost (YOC):** What a stock yields based on YOUR purchase price

**Example:**
```
Stock A purchased 10 years ago:
- Purchase price: $50
- Annual dividend at purchase: $1.00
- Initial yield on cost: 2.0%

Stock A today:
- Current price: $120
- Annual dividend today: $2.50
- Current yield: 2.1% (for new buyers)
- YOUR yield on cost: 5.0% (based on your $50 cost)
```

**Key Insight:** Your yield on cost grows every time the dividend increases, regardless of stock price movement. This is the magic of dividend growth investing.

## The Mathematics of Dividend Growth

### 12% Annual Dividend Growth (Screening Minimum)

Starting with 1.5% yield:

| Year | Annual Dividend | Yield on Cost | Cumulative Dividends | Total Value |
|------|----------------|---------------|---------------------|-------------|
| 0 | $1.50 | 1.50% | $0 | $100 |
| 1 | $1.68 | 1.68% | $1.68 | $101.68 |
| 3 | $2.11 | 2.11% | $5.51 | $105.51 |
| 5 | $2.64 | 2.64% | $10.18 | $110.18 |
| 10 | $4.66 | 4.66% | $26.20 | $126.20 |
| 15 | $8.22 | 8.22% | $53.98 | $153.98 |
| 20 | $14.50 | 14.50% | $102.45 | $202.45 |

**Key Milestones:**
- Year 6: Dividend doubles (3% yield on cost)
- Year 12: Dividend quadruples (6% yield on cost)
- Year 18: Dividend grows 8x (12% yield on cost)

### 15% Annual Dividend Growth (Excellent Tier)

Starting with 1.8% yield:

| Year | Annual Dividend | Yield on Cost | Cumulative Dividends | Total Value |
|------|----------------|---------------|---------------------|-------------|
| 0 | $1.80 | 1.80% | $0 | $100 |
| 1 | $2.07 | 2.07% | $2.07 | $102.07 |
| 3 | $2.74 | 2.74% | $7.02 | $107.02 |
| 5 | $3.62 | 3.62% | $13.86 | $113.86 |
| 10 | $7.28 | 7.28% | $40.57 | $140.57 |
| 15 | $14.65 | 14.65% | $93.11 | $193.11 |
| 20 | $29.47 | 29.47% | $195.57 | $295.57 |

**Key Milestones:**
- Year 5: Dividend doubles (3.6% yield on cost)
- Year 10: Dividend quadruples (7.3% yield on cost)
- Year 15: Dividend grows 8x (14.7% yield on cost)
- Year 20: Dividend grows 16x (29.5% yield on cost)

### 20% Annual Dividend Growth (Exceptional Tier)

Starting with 2.0% yield:

| Year | Annual Dividend | Yield on Cost | Cumulative Dividends | Total Value |
|------|----------------|---------------|---------------------|-------------|
| 0 | $2.00 | 2.00% | $0 | $100 |
| 1 | $2.40 | 2.40% | $2.40 | $102.40 |
| 3 | $3.46 | 3.46% | $8.66 | $108.66 |
| 5 | $4.98 | 4.98% | $18.67 | $118.67 |
| 10 | $12.38 | 12.38% | $63.10 | $163.10 |
| 15 | $30.77 | 30.77% | $181.74 | $281.74 |
| 20 | $76.49 | 76.49% | $479.76 | $579.76 |

**Key Milestones:**
- Year 4: Dividend doubles (4% yield on cost)
- Year 8: Dividend quadruples (8.6% yield on cost)
- Year 12: Dividend grows 8x (17.8% yield on cost)
- Year 16: Dividend grows 16x (36.6% yield on cost)

## Growth vs. Yield Trade-Off

### Scenario Comparison: 20-Year Investment

**Stock A: High Yield, Low Growth**
- Initial Yield: 4.0%
- Dividend Growth: 3% annually
- Year 20 Yield on Cost: 7.2%
- Total Dividends Collected: $109.11
- Final Position Value (with dividends): $209.11

**Stock B: Low Yield, High Growth**
- Initial Yield: 1.5%
- Dividend Growth: 15% annually
- Year 20 Yield on Cost: 24.5%
- Total Dividends Collected: $146.79
- Final Position Value (with dividends): $246.79

**Winner: Stock B by 18% higher total return**

**Key Insight:** Lower starting yield + higher growth beats higher starting yield + lower growth over long periods (10+ years). This is why we screen for 12%+ dividend growth, not maximum current yield.

## Real-World Examples

### Microsoft (MSFT): 2010-2020

**2010 Entry:**
- Price: $28
- Annual Dividend: $0.55
- Yield on Cost: 2.0%
- Dividend Growth Rate: ~15% annually

**2020 Result:**
- Price: $220 (7.9x)
- Annual Dividend: $2.24
- Yield on Cost: 8.0% (4x)
- Total Return: ~900% including dividends

**Lesson:** A "boring" 2% yielder in 2010 became an 8% yielder on cost in 10 years. Investors who bought for the 2% yield stayed for the dividend growth and compounded massive returns.

### Visa (V): 2012-2022

**2012 Entry (Post-IPO):**
- Price: $20 (split-adjusted)
- Annual Dividend: $0.10
- Yield on Cost: 0.5%
- Dividend Growth Rate: ~20% annually

**2022 Result:**
- Price: $210 (10.5x)
- Annual Dividend: $1.50
- Yield on Cost: 7.5% (15x)
- Total Return: ~1,100% including dividends

**Lesson:** Even a 0.5% yielder can become a high-yield position through sustained dividend growth. The starting yield is less important than the growth rate.

### Apple (AAPL): 2012-2022 (After Dividend Reinstatement)

**2012 Entry:**
- Price: $19 (split-adjusted)
- Annual Dividend: $0.38 (split-adjusted)
- Yield on Cost: 2.0%
- Dividend Growth Rate: ~10% annually

**2022 Result:**
- Price: $150 (7.9x)
- Annual Dividend: $0.92 (split-adjusted)
- Yield on Cost: 4.8% (2.4x)
- Total Return: ~850% including dividends

**Lesson:** Even "modest" 10% dividend growth creates significant income growth over a decade, especially when combined with price appreciation.

## Quality Characteristics of Dividend Growth Stocks

### Why Do Companies Grow Dividends 12%+?

**Business Growth:**
- Revenue growing 10%+ annually
- Earnings per share (EPS) growing 12%+ annually
- Market share expansion or pricing power

**Capital Efficiency:**
- High Return on Equity (ROE >15%)
- Strong profit margins (>15%)
- Excess cash generation

**Capital Allocation Priority:**
- Management committed to dividend growth
- Payout ratios low enough to sustain growth (30-70%)
- Balance between dividends, buybacks, and reinvestment

**Competitive Advantages:**
- Economic moats (brand, network effects, switching costs)
- Pricing power to pass through inflation
- Secular growth tailwinds

### Typical Profiles

**Technology (Software/Payments):**
- Example: Microsoft, Visa, Mastercard
- Characteristics: High margins (30-50%), low capex, scalable
- Dividend Growth: 15-20% annually
- Starting Yield: 0.5-1.5%
- Payout Ratio: 20-40%

**Financials (Banks/Insurers):**
- Example: JPMorgan, Progressive
- Characteristics: ROE 12-18%, regulatory capital requirements
- Dividend Growth: 10-15% annually
- Starting Yield: 2-3%
- Payout Ratio: 30-50%

**Consumer (Brands/Retail):**
- Example: Nike, Costco, Starbucks
- Characteristics: Brand loyalty, pricing power
- Dividend Growth: 12-18% annually
- Starting Yield: 1-2.5%
- Payout Ratio: 30-50%

**Healthcare (Pharma/Devices):**
- Example: Abbott, Johnson & Johnson
- Characteristics: Patent protection, aging demographics
- Dividend Growth: 8-15% annually
- Starting Yield: 1.5-2.5%
- Payout Ratio: 40-60%

## Sustainability: Can 12%+ Growth Continue?

### Payout Ratio Dynamics

**Low Payout Ratios (20-50%) = Sustainable Growth:**

If a company pays out only 40% of earnings as dividends:
- EPS needs to grow 12% → Dividend can grow 12% (payout ratio stable)
- EPS grows 8% → Dividend can still grow 12% by increasing payout ratio
- Creates multi-year runway for high dividend growth

**Example: Microsoft 2010-2020**
```
2010: EPS $2.50, Dividend $0.55, Payout Ratio 22%
2020: EPS $6.20, Dividend $2.24, Payout Ratio 36%

EPS CAGR: 9.5%
Dividend CAGR: 15.0%
Payout ratio expanded from 22% → 36%, enabling higher dividend growth
```

**High Payout Ratios (70-90%) = Unsustainable:**

If a company pays out 80% of earnings:
- EPS must grow 12%+ to sustain 12% dividend growth
- No room for payout ratio expansion
- Risk of dividend cut if earnings decline

### The Growth Ceiling

**Mathematical Reality:**
- A 1.5% yielding stock growing dividends 15%/year will eventually yield 10%+ on cost
- At that point, payout ratios force dividend growth to slow
- Typical ceiling: After 10-15 years, dividend growth slows to 5-10%

**Why This Is OK:**
```
Years 1-10: Dividend growth 15%, total return 18-20%/year
Years 11-20: Dividend growth 8%, total return 10-12%/year
Years 21+: Dividend growth 5%, total return 7-9%/year

Your yield on cost is now 15-20%, generating massive income
```

**Lesson:** High dividend growth cannot last forever, but it doesn't need to. The compounding in the first 10-15 years creates permanently elevated income streams.

## Portfolio Construction with Dividend Growth

### Diversification Across Growth Tiers

**Balanced Approach (Recommended):**
- 40% in 12-15% growers (sustainable, moderate risk)
- 40% in 15-20% growers (excellent growth, higher valuation risk)
- 20% in 20%+ growers (exceptional but may slow down)

**Rationale:**
- 12-15% growers provide stable compounding
- 15-20% growers drive outsized returns
- 20%+ growers add "lottery ticket" upside

**Result:** Portfolio-level dividend growth ~15%/year, balancing risk and reward

### Entry Timing with RSI

**Without RSI Timing:**
- Buy 2% yielder at fair value
- Year 10 yield on cost: 8.0% (15% CAGR)

**With RSI ≤35 Timing:**
- Buy same stock 12% cheaper during pullback
- Effective yield: 2.27% (vs 2.0%)
- Year 10 yield on cost: 9.1% (13.7% improvement)
- Plus: Better total return from lower entry price

**Lesson:** RSI timing enhances already strong dividend growth returns. Even modest entry price improvements (10-15%) compound significantly over time.

### Reinvestment vs. Income

**Reinvestment (Accumulation Phase):**
- Reinvest all dividends into more shares
- Accelerates compounding through DRIP
- Effective dividend growth rate includes share accumulation
- Example: 15% dividend growth + 2% yield reinvested ≈ 17% total dividend income growth

**Income (Distribution Phase):**
- Spend dividends as income
- Rely on dividend growth for inflation protection
- 12% dividend growth = doubling income every 6 years

## Common Misconceptions

### "I Need High Yield NOW for Income"

**Reality:** If your time horizon is 10+ years, starting yield matters far less than growth rate.

**Math:**
```
Stock A: 5% yield, 3% growth
Year 10 income: 5% × 1.03^10 = 6.7% on cost

Stock B: 1.5% yield, 15% growth
Year 10 income: 1.5% × 1.15^10 = 6.1% on cost

Year 15 income:
Stock A: 7.8% on cost
Stock B: 12.1% on cost (55% more income!)
```

**Takeaway:** Patience with dividend growth beats immediate high yield.

### "Low Payout Ratio Means Company Is Cheap"

**Reality:** Low payout ratios (20-40%) in dividend growers are GOOD, not a sign of stinginess.

**Why:**
- Provides runway for sustained 12-15% dividend growth
- Signals management confidence (room to increase)
- Enables dividend growth even if earnings slow slightly

**Contrast:** High payout ratios (80-100%) limit dividend growth and signal risk.

### "Dividend Growth Will Slow When Stock Gets Expensive"

**Partial Truth:** Valuation and dividend growth are separate.

**Reality:**
- Expensive stocks (high P/E) CAN sustain high dividend growth if earnings grow
- Cheap stocks (low P/E) can have slow dividend growth if business is mature

**Focus:** Business growth (revenue, EPS) drives dividend growth, not valuation multiples. However, expensive stocks have lower total returns if multiples compress, even if dividends grow.

## Practical Application

### Stock Selection Checklist

For screening, require:
- [ ] Current Yield ≥ 1.5% (provides income floor)
- [ ] 3-Year Dividend CAGR ≥ 12% (proven growth)
- [ ] Payout Ratio < 80% (sustainable)
- [ ] Revenue CAGR > 0% (business growing)
- [ ] EPS CAGR > 0% (profitability growing)
- [ ] RSI ≤ 40 (timing opportunity)

### Position Monitoring

**Quarterly Reviews:**
- [ ] Dividend increased in past 12 months?
- [ ] Dividend growth rate still ≥10%? (Allow slight slowdown)
- [ ] Payout ratio stable or declining?
- [ ] Revenue and EPS growing?

**Action:** If all checks pass, hold indefinitely. If 2+ fail, consider trimming.

### Exit Triggers

**Fundamental Deterioration:**
- Dividend growth slows below 5%/year for 2+ years
- Payout ratio approaches 100%
- Revenue or EPS declining for 2+ quarters
- Management signals dividend growth pause

**Do NOT Exit For:**
- Stock price volatility (ignore noise)
- Valuation expansion (P/E rising)
- RSI overbought (>70)
- Market corrections

**Lesson:** You're holding for dividend growth, not price appreciation. Price volatility is irrelevant if dividends keep growing.

## Conclusion

Dividend growth investing is about patience and compounding. The strategy is:

1. **Find Quality:** Screen for 12%+ dividend CAGR, 1.5%+ yield
2. **Time Entry:** Use RSI ≤40 to buy during temporary weakness
3. **Hold Forever:** Let dividends compound for 10-20 years
4. **Reinvest (Optional):** Accelerate compounding in accumulation phase
5. **Enjoy Income:** Eventually yield on cost becomes 10-20%+, providing massive income

The magic is NOT in picking individual winners - it's in systematically buying quality dividend growers at good entry prices (RSI ≤40) and holding long enough for compounding to work.

**Remember:**
- A 1.5% yielder growing 15%/year becomes a 6% yielder in 10 years and 24% yielder in 20 years
- Entry price matters - RSI ≤40 improves cost basis by 10-15% typically
- Time horizon is critical - Need 10+ years for full compounding effect
- Business quality trumps everything - 12%+ dividend growth requires strong fundamentals

---

**Disclaimer:** Past dividend growth does not guarantee future performance. Dividend policies can change. Conduct thorough due diligence and consult a financial advisor before making investment decisions.
