# Market Analysis Patterns

## Market Pattern Analysis

### Trend Identification
1. **Uptrend**
   - Higher highs and higher lows
   - Moving averages trending upward
   - Price rises accompanied by volume increases

2. **Downtrend**
   - Lower highs and lower lows
   - Moving averages trending downward
   - Decreased volume on bounces

3. **Range-Bound Market**
   - Trading within defined range
   - Moving averages sideways
   - Declining volume trend

### Risk-On / Risk-Off Assessment

#### Risk-On Environment Characteristics
- Stock markets rising (especially emerging markets)
- High-yield currency buying (AUD, NZD, etc.)
- VIX index declining
- Interest rates rising
- Risk assets like crude oil rising

#### Risk-Off Environment Characteristics
- Flight to safe assets (yen buying, Swiss franc buying)
- Gold prices rising
- Bond buying (yields falling)
- VIX index rising
- Emerging market currencies and stocks selling

## Economic Indicator Interpretation

### Employment Data (US)

- **Nonfarm Payrolls (NFP)**
  - +200k or more above expectations: Strong employment, rate hike expectations
  - -100k or more below expectations: Employment deterioration, rate cut expectations

- **Unemployment Rate**
  - 3.5% or below: Near full employment
  - 4.0% or above: Signs of employment environment deterioration

### Inflation Indicators

- **CPI (Consumer Price Index)**
  - 2% YoY: Fed target level
  - 3%+: Inflation alert
  - Below 1%: Deflation risk

- **PPI (Producer Price Index)**
  - Important as CPI leading indicator
  - Captures upstream inflation

### Central Bank Policy

- **Fed (Federal Reserve)**
  - Watch dot plot
  - Policy rate outlook changes

- **BOJ (Bank of Japan)**
  - YCC (Yield Curve Control) policy
  - ETF purchase trends

- **ECB (European Central Bank)**
  - 2% inflation target
  - Response to regional disparities

## Inter-Market Correlation Analysis

### Positive Correlation Patterns
- Stocks ↑ → Interest rates ↑ (strong economy)
- USD/JPY ↑ → Nikkei ↑ (exporters favorable)
- Crude oil ↑ → Inflation expectations ↑

### Inverse Correlation Patterns
- Interest rates ↑ → Bond prices ↓
- Dollar ↑ → Gold prices ↓
- VIX ↑ → Stocks ↓

## Seasonality & Anomalies

### Monthly Patterns
- **January Effect**: New year fund inflows
- **Sell in May**: Pre-summer doldrums position closing
- **September**: Historically weak month
- **December**: Tax-loss selling, Santa Claus rally

### Day-of-Week Effects
- **Monday**: Weekend risk pricing
- **Friday**: Position adjustments

### Fiscal Year-End
- **End of March**: Japanese corporate fiscal year, repatriation flows
- **End of December**: Western corporate fiscal year

## Technical Indicator Usage

### Trend Indicators
- **Moving Averages**: 25-day, 75-day, 200-day line relationships
- **MACD**: Identifying trend turning points
- **Bollinger Bands**: Volatility and contrarian entry points

### Oscillators
- **RSI**: Over 70 overbought, below 30 oversold
- **Stochastics**: Short-term turning points
- **Volume**: Confirming price movement reliability

## Sentiment Analysis

### Capturing Investor Psychology
- **Put/Call Ratio**: Option market skew
- **Bull/Bear Ratio**: Investor surveys
- **Fear & Greed Index**: CNN Fear & Greed Index

### News Flow Analysis
- Headline tone changes
- Media coverage frequency
- Social media buzzwords
