# Asset Allocation Framework

This document provides comprehensive guidance on asset allocation principles, target allocations by risk profile, and rebalancing triggers for portfolio management.

## Core Principles

### 1. Asset Allocation Drives Returns

Academic research shows that asset allocation accounts for approximately 90% of portfolio return variability over time. Security selection and market timing contribute far less to long-term outcomes.

**Key Insight:** Getting the allocation right is more important than picking individual stocks.

### 2. Diversification Across Asset Classes

Different asset classes have different risk-return characteristics and respond differently to economic conditions:

| Asset Class | Expected Return | Volatility | Purpose |
|-------------|----------------|------------|---------|
| **Stocks (Equities)** | 8-10% | High (15-20%) | Growth, long-term appreciation |
| **Bonds (Fixed Income)** | 3-5% | Low (3-6%) | Income, capital preservation, volatility dampening |
| **Cash & Equivalents** | 1-2% | Very Low | Liquidity, stability, opportunistic deployment |
| **Real Estate** | 6-8% | Medium (10-15%) | Income, inflation hedge, diversification |
| **Commodities** | 4-6% | High (15-25%) | Inflation hedge, diversification |
| **Alternatives** | Varies | Varies | Non-correlated returns, risk management |

*Note: Returns are historical long-term averages and not guaranteed. Actual returns vary significantly.*

### 3. Risk Tolerance Alignment

Asset allocation should match investor's risk tolerance and time horizon:

- **Risk Capacity:** Financial ability to withstand losses (net worth, income stability, time horizon)
- **Risk Tolerance:** Emotional ability to withstand volatility (behavioral, psychological)
- **Risk Requirement:** Return needed to achieve financial goals

Optimal allocation balances all three factors.

## Asset Allocation by Risk Profile

### Conservative (Capital Preservation)

**Investor Profile:**
- Age: Typically 60+ or near retirement
- Time Horizon: 0-5 years
- Primary Goal: Preserve capital, generate income
- Risk Tolerance: Low - cannot afford significant losses
- Volatility Tolerance: Minimal (<5-8% annual drawdown)

**Target Allocation:**
- **Stocks:** 20-40%
  - US Large Cap: 15-25%
  - US Small/Mid Cap: 0-5%
  - International: 5-10%
- **Bonds:** 50-70%
  - Investment Grade Corporate: 20-30%
  - Government Bonds: 20-30%
  - High Yield: 0-10%
- **Cash:** 10-20%
- **Alternatives:** 0-10%

**Sector Guidelines (Equity Portion):**
- Defensive sectors: 60-70% (Utilities, Consumer Staples, Healthcare)
- Cyclical sectors: 30-40%
- Avoid: High-growth tech, speculative stocks

**Expected Outcomes:**
- Annual Return: 4-6%
- Max Drawdown: -10 to -15%
- Recovery Time: 1-2 years

### Moderate (Balanced Growth & Income)

**Investor Profile:**
- Age: Typically 40-60
- Time Horizon: 5-15 years
- Primary Goal: Balanced growth and income
- Risk Tolerance: Medium - can handle moderate volatility
- Volatility Tolerance: Moderate (10-15% annual drawdown)

**Target Allocation:**
- **Stocks:** 50-70%
  - US Large Cap: 30-40%
  - US Small/Mid Cap: 10-15%
  - International: 10-15%
- **Bonds:** 25-40%
  - Investment Grade Corporate: 15-25%
  - Government Bonds: 5-10%
  - High Yield: 5-10%
- **Cash:** 5-10%
- **Alternatives:** 0-10%

**Sector Guidelines (Equity Portion):**
- Defensive sectors: 40-50%
- Growth sectors: 30-40% (Technology, Communication, Consumer Discretionary)
- Cyclical sectors: 20-30% (Industrials, Financials, Materials)

**Expected Outcomes:**
- Annual Return: 6-8%
- Max Drawdown: -15 to -25%
- Recovery Time: 2-4 years

### Growth (Long-Term Capital Appreciation)

**Investor Profile:**
- Age: Typically 30-50
- Time Horizon: 10-25 years
- Primary Goal: Long-term wealth accumulation
- Risk Tolerance: Medium-High - can withstand volatility for higher returns
- Volatility Tolerance: Significant (15-20% annual drawdown)

**Target Allocation:**
- **Stocks:** 75-90%
  - US Large Cap: 40-50%
  - US Small/Mid Cap: 15-20%
  - International: 15-20%
  - Emerging Markets: 5-10%
- **Bonds:** 10-20%
  - Investment Grade Corporate: 5-10%
  - High Yield: 5-10%
- **Cash:** 2-5%
- **Alternatives:** 0-10%

**Sector Guidelines (Equity Portion):**
- Growth sectors: 45-55% (Technology, Healthcare, Communication)
- Cyclical sectors: 25-35%
- Defensive sectors: 20-30%

**Expected Outcomes:**
- Annual Return: 8-10%
- Max Drawdown: -20 to -35%
- Recovery Time: 3-5 years

### Aggressive (Maximum Growth)

**Investor Profile:**
- Age: Typically <40 or high net worth with long horizon
- Time Horizon: 15+ years
- Primary Goal: Maximize wealth, comfortable with high risk
- Risk Tolerance: High - can emotionally and financially withstand major losses
- Volatility Tolerance: Very high (20-30%+ annual drawdown)

**Target Allocation:**
- **Stocks:** 90-100%
  - US Large Cap: 40-50%
  - US Small/Mid Cap: 20-25%
  - International: 15-20%
  - Emerging Markets: 10-15%
  - Alternatives: 0-5%
- **Bonds:** 0-10%
- **Cash:** 0-5%

**Sector Guidelines (Equity Portion):**
- Growth sectors: 50-60% (Technology, Healthcare, Consumer Discretionary)
- Cyclical sectors: 30-35%
- Defensive sectors: 10-20%
- May include speculative positions (small caps, growth stocks)

**Expected Outcomes:**
- Annual Return: 9-12%
- Max Drawdown: -30 to -50%
- Recovery Time: 4-7 years

## Sector Allocation Guidelines

### Defensive Sectors (Lower Volatility)

**Utilities (3-5% of equity allocation)**
- Characteristics: Stable cash flows, dividend-focused, regulated
- Economic Sensitivity: Low
- Use: Income generation, volatility dampening
- Overweight when: Late cycle, high uncertainty, rising rates

**Consumer Staples (5-10%)**
- Characteristics: Steady demand, pricing power, recession-resistant
- Economic Sensitivity: Low
- Use: Stability, dividend income
- Overweight when: Economic slowdown, defensive posture

**Healthcare (10-15%)**
- Characteristics: Demographic tailwinds, innovation-driven, essential services
- Economic Sensitivity: Low to Medium
- Use: Growth with defensive qualities
- Overweight when: Aging demographics, innovation cycle

### Growth Sectors (Higher Volatility, Higher Expected Returns)

**Technology (15-25%)**
- Characteristics: High growth, innovation-driven, secular trends
- Economic Sensitivity: Medium to High
- Use: Capital appreciation, secular growth
- Overweight when: Economic expansion, innovation cycles, low rates
- Caution: Concentration risk, valuation sensitivity

**Communication Services (5-10%)**
- Characteristics: Platform businesses, network effects, advertising-driven
- Economic Sensitivity: Medium
- Use: Growth, secular trends (digital transformation)
- Overweight when: Ad market strength, content consumption growth

**Consumer Discretionary (8-12%)**
- Characteristics: Cyclical demand, premium brands, e-commerce
- Economic Sensitivity: High
- Use: Economic growth exposure, consumer trends
- Overweight when: Strong consumer confidence, wage growth

### Cyclical Sectors (Economic Cycle Sensitive)

**Financials (10-15%)**
- Characteristics: Interest rate sensitive, credit cycle dependent
- Economic Sensitivity: High
- Use: Economic expansion exposure, dividend income
- Overweight when: Rising rates, strong economy, steepening yield curve

**Industrials (8-12%)**
- Characteristics: Capital goods, infrastructure, global trade
- Economic Sensitivity: High
- Use: Economic growth, infrastructure spending
- Overweight when: Fiscal stimulus, manufacturing upturn, globalization

**Materials (3-6%)**
- Characteristics: Commodity-driven, economic cycle dependent
- Economic Sensitivity: Very High
- Use: Inflation hedge, economic growth
- Overweight when: Infrastructure spending, commodity supercycles

**Energy (3-8%)**
- Characteristics: Commodity price driven, capital intensive, volatile
- Economic Sensitivity: High
- Use: Inflation hedge, commodity exposure
- Overweight when: Rising oil prices, underinvestment supply cycles
- Caution: ESG concerns, energy transition risk

**Real Estate (3-6%)**
- Characteristics: Income-focused, interest rate sensitive, inflation hedge
- Economic Sensitivity: Medium
- Use: Diversification, income, inflation protection
- Overweight when: Low rates, economic expansion, inflation

## Geographic Allocation

### US Equities (60-75% of total equity)

**Rationale:**
- Home market bias (reduce currency risk, familiar companies)
- Deepest, most liquid markets
- Strong corporate governance and shareholder rights
- Dollar-denominated returns

**Allocation by Market Cap:**
- Large Cap (>$10B): 60-70% of US equity
- Mid Cap ($2B-$10B): 20-25%
- Small Cap (<$2B): 10-15%

### International Developed Markets (15-25% of total equity)

**Regions:**
- Europe: 8-12%
- Japan: 3-5%
- UK: 2-4%
- Other (Canada, Australia): 2-4%

**Rationale:**
- Diversification (different economic cycles)
- Currency diversification
- Access to global industry leaders
- Valuation opportunities

**Considerations:**
- Currency risk (hedge or leave unhedged based on view)
- Political risk (EU regulatory environment, Brexit impact)
- Lower growth rates vs US

### Emerging Markets (5-15% of total equity)

**Regions:**
- China: 2-5%
- India: 1-3%
- Other Asia (Taiwan, Korea): 1-3%
- Latin America: 0-2%
- Other: 0-2%

**Rationale:**
- Higher growth potential
- Demographic advantages
- Commodity exposure
- Diversification

**Considerations:**
- Higher volatility
- Political and regulatory risk
- Currency volatility
- Liquidity concerns

**Risk Management:**
- Limit to 5-10% for moderate investors
- Use broad ETFs rather than individual stocks
- Monitor geopolitical developments

## Rebalancing Framework

### Rebalancing Triggers

**1. Time-Based Rebalancing**
- **Frequency:** Quarterly or Semi-Annually
- **Methodology:** Review allocation every 3-6 months, rebalance if needed
- **Pros:** Disciplined, predictable, simple
- **Cons:** May rebalance when not necessary (costs), or miss urgent needs

**2. Threshold-Based Rebalancing**
- **Trigger:** Allocation drifts >5% from target
- **Example:** If target is 60% stocks, rebalance when stocks reach <55% or >65%
- **Pros:** Responsive to market moves, cost-efficient
- **Cons:** Requires monitoring, may miss small drifts

**3. Hybrid Approach (Recommended)**
- **Method:** Check quarterly, rebalance only if drift >5%
- **Best of both worlds:** Disciplined review, cost-conscious execution

### Rebalancing Thresholds

| Allocation Drift | Action | Priority |
|-----------------|--------|----------|
| **<3%** | Monitor, no action needed | None |
| **3-5%** | Consider rebalancing (optional) | Low |
| **5-10%** | Rebalance recommended | Medium |
| **>10%** | Rebalance immediately | High |

**Position-Level Thresholds:**
- Single stock >15% of portfolio → Trim immediately
- Single stock >20% of portfolio → Urgent trim required
- Any position doubling target weight → Review and likely trim

### Rebalancing Methods

**1. Sell and Redeploy**
- **Method:** Sell overweight positions, buy underweight positions
- **Pros:** Precise rebalancing
- **Cons:** Tax implications (capital gains), transaction costs

**2. Direct New Contributions**
- **Method:** Use new cash to buy underweight positions
- **Pros:** No selling (tax-efficient), simple
- **Cons:** Slower rebalancing, requires regular contributions

**3. Dividend Reinvestment**
- **Method:** Reinvest dividends into underweight positions
- **Pros:** Tax-efficient, gradual rebalancing
- **Cons:** Very slow, limited impact

**4. Opportunistic (Tactical)**
- **Method:** Sell overweight positions on strength, buy underweight on weakness
- **Pros:** Improve execution prices
- **Cons:** Requires active monitoring, may delay rebalancing

**Recommendation:** Use method #1 (sell and redeploy) for large drifts (>10%), method #2 for small drifts (<5%), and method #4 when actively managing.

### Tax Considerations

**Tax-Loss Harvesting:**
- Sell positions with losses to offset capital gains
- Reinvest in similar (but not substantially identical) securities
- Avoid wash sale rule (30-day rule)

**Tax-Efficient Rebalancing:**
- Prioritize rebalancing in tax-advantaged accounts (IRA, 401k)
- In taxable accounts, hold winners >1 year for long-term capital gains rates
- Use new contributions to rebalance rather than selling

**Timing:**
- Rebalance in December to harvest losses
- Rebalance in January to deploy fresh capital
- Avoid year-end if sitting on large gains (defer taxes)

## Tactical Adjustments

While strategic asset allocation should be stable, tactical adjustments can enhance returns:

### Market Cycle Adjustments

**Early Bull Market:**
- Overweight: Cyclicals (Financials, Industrials, Materials)
- Underweight: Defensives (Utilities, Staples)
- Rationale: Economic acceleration favors cyclical sectors

**Mid Bull Market:**
- Overweight: Growth (Technology, Healthcare)
- Neutral: Cyclicals and Defensives
- Rationale: Expansion matures, focus on quality growth

**Late Bull Market:**
- Overweight: Defensives (Utilities, Staples, Healthcare)
- Underweight: Cyclicals
- Rationale: Prepare for slowdown, reduce beta

**Bear Market:**
- Overweight: Cash, Bonds, Defensive equities
- Underweight: Cyclical equities
- Rationale: Capital preservation, prepare for recovery

### Valuation-Based Adjustments

**When US stocks expensive (high Shiller PE >30):**
- Reduce US equity allocation by 5-10%
- Increase international or value stocks
- Increase cash/bonds

**When sectors extremely overvalued:**
- Trim sector allocation by 3-5%
- Redistribute to undervalued sectors
- Maintain overall equity target

### Interest Rate Adjustments

**Rising Rate Environment:**
- Shorten bond duration
- Overweight: Financials, Value stocks
- Underweight: High P/E growth, Utilities, REITs

**Falling Rate Environment:**
- Lengthen bond duration
- Overweight: Growth stocks, Technology, REITs
- Underweight: Financials

## Common Mistakes to Avoid

### 1. Market Timing
**Mistake:** Drastically changing allocation based on market predictions
**Impact:** Missing recoveries, buying high/selling low
**Solution:** Stick to strategic allocation, make only minor tactical adjustments

### 2. Over-Diversification
**Mistake:** Holding 100+ positions across 50 funds
**Impact:** Closet indexing, high fees, complexity
**Solution:** 15-30 individual stocks OR 5-10 ETFs for most investors

### 3. Under-Diversification
**Mistake:** Heavy concentration in single stock/sector (often employer stock)
**Impact:** Excessive risk, correlated life outcomes (job + portfolio)
**Solution:** Limit single stock to <10%, single sector to <25%

### 4. Ignoring Rebalancing
**Mistake:** "Let winners run" indefinitely
**Impact:** Portfolio drifts to high risk, concentration increases
**Solution:** Disciplined rebalancing schedule, trim winners

### 5. Emotional Rebalancing
**Mistake:** Panic selling in crashes, euphoric buying in bubbles
**Impact:** Locking in losses, buying tops
**Solution:** Systematic rebalancing rules, ignore emotions

### 6. Chasing Performance
**Mistake:** Shifting to last year's top-performing sectors
**Impact:** Mean reversion, buying expensive
**Solution:** Maintain strategic allocation, resist recency bias

## Allocation Review Checklist

Use this checklist when reviewing portfolio allocation:

**Asset Class Level:**
- [ ] Current stock/bond/cash allocation vs target (within 5%?)
- [ ] Risk profile still appropriate for goals/timeline?
- [ ] Any major life changes requiring allocation shift?
- [ ] Tax considerations for rebalancing?

**Sector Level:**
- [ ] Any sector >30% of equity allocation?
- [ ] Defensive sectors appropriate for market cycle?
- [ ] Growth vs value balance appropriate?
- [ ] Sector allocations reasonable vs benchmark?

**Geographic Level:**
- [ ] US vs International allocation on target?
- [ ] Emerging market exposure appropriate for risk tolerance?
- [ ] Any country concentration concerns?
- [ ] Currency exposure considerations?

**Position Level:**
- [ ] Any single stock >15% of portfolio?
- [ ] Top 10 holdings represent what % of portfolio?
- [ ] Any highly correlated positions creating concentration?
- [ ] Position sizes match conviction and risk?

**Performance Level:**
- [ ] Performance vs benchmark acceptable?
- [ ] Any positions consistently underperforming?
- [ ] Winners becoming too large (>2x initial allocation)?
- [ ] Losers requiring re-evaluation (broken thesis)?

## Summary

**Key Takeaways:**

1. **Asset allocation is the primary driver of returns** - Get the big picture right
2. **Match allocation to risk tolerance and time horizon** - Don't take more risk than you can handle
3. **Diversify across asset classes, sectors, and geographies** - Don't put all eggs in one basket
4. **Rebalance systematically** - Trim winners, add to losers, maintain discipline
5. **Minimize taxes and costs** - Tax-efficient rebalancing, low-cost implementation
6. **Stay the course** - Avoid emotional decisions, stick to the plan
7. **Review regularly but change rarely** - Annual review, infrequent major changes

**Remember:** Asset allocation should reflect your personal circumstances, not market forecasts. The best allocation is one you can stick with through market cycles.
