# Risk Profile Questionnaire

This document provides a framework for assessing investor risk tolerance and determining appropriate target asset allocation.

## Overview

Risk profile assessment helps answer:
1. How much volatility can the investor handle emotionally?
2. How much loss can they afford financially?
3. What allocation matches their risk capacity and tolerance?
4. What expected return do they need to meet goals?

**Three Components of Risk Assessment:**

1. **Risk Capacity** - Financial ability to withstand losses (objective)
2. **Risk Tolerance** - Emotional willingness to accept volatility (subjective)
3. **Risk Requirement** - Return needed to achieve goals (objective)

Optimal allocation balances all three components.

## Risk Capacity Assessment (Financial)

Risk capacity is determined by objective financial factors:

### 1. Time Horizon

**Question:** When will you need to withdraw a significant portion of this portfolio?

| Answer | Years | Risk Capacity | Typical Allocation |
|--------|-------|---------------|-------------------|
| **A.** Retired, currently withdrawing | 0-3 | Very Low | 20-30% stocks |
| **B.** Retiring soon | 3-5 | Low | 30-40% stocks |
| **C.** Mid-career, 10-15 years | 10-15 | Medium | 50-70% stocks |
| **D.** Early career, 20+ years | 20-30 | High | 70-85% stocks |
| **E.** Very young, 30+ years | 30+ | Very High | 85-100% stocks |

**Scoring:**
- A = 1 point
- B = 2 points
- C = 3 points
- D = 4 points
- E = 5 points

**Rationale:** Longer time horizons allow recovery from market downturns, supporting higher equity allocation.

### 2. Income Stability

**Question:** How stable and predictable is your income?

| Answer | Risk Capacity Impact |
|--------|---------------------|
| **A.** Fixed pension or annuity (very stable) | Very High (can handle portfolio volatility) |
| **B.** Stable salary, secure job | High |
| **C.** Salary with some variability | Medium |
| **D.** Commission or bonus-heavy | Low |
| **E.** Entrepreneur/self-employed | Low (income correlates with markets) |

**Scoring:**
- A = 5 points
- B = 4 points
- C = 3 points
- D = 2 points
- E = 2 points (or 1 if business is cyclical)

**Rationale:** Stable income allows taking more risk in portfolio; variable income requires conservative portfolio as ballast.

### 3. Net Worth and Liquidity

**Question:** What percentage of your total net worth is this investment portfolio? (Exclude home equity and retirement accounts you can't access)

| Answer | Risk Capacity Impact |
|--------|---------------------|
| **A.** Less than 25% (most wealth elsewhere) | Very High |
| **B.** 25-50% | High |
| **C.** 50-75% | Medium |
| **D.** 75-90% | Low |
| **E.** Over 90% (nearly all wealth) | Very Low |

**Scoring:**
- A = 5 points
- B = 4 points
- C = 3 points
- D = 2 points
- E = 1 point

**Rationale:** If portfolio represents most of your wealth, you can't afford large losses. Diversified wealth allows higher risk in this account.

### 4. Emergency Fund Status

**Question:** Do you have a separate emergency fund (3-6 months expenses) outside this portfolio?

| Answer | Risk Capacity Impact |
|--------|---------------------|
| **A.** Yes, fully funded (6+ months) | High (no need to tap portfolio) |
| **B.** Partially funded (3-4 months) | Medium |
| **C.** No, this portfolio is my emergency fund | Low (need liquidity) |

**Scoring:**
- A = 5 points
- B = 3 points
- C = 1 point

**Rationale:** Emergency fund prevents forced liquidation at market lows; its absence requires higher cash allocation.

### 5. Debt Level

**Question:** What is your debt situation?

| Answer | Risk Capacity Impact |
|--------|---------------------|
| **A.** No debt (or only mortgage) | High |
| **B.** Moderate debt, manageable payments | Medium |
| **C.** High debt, significant payments | Low |
| **D.** High-interest debt (credit cards) | Very Low |

**Scoring:**
- A = 5 points
- B = 3 points
- C = 2 points
- D = 1 point

**Rationale:** High debt reduces capacity to handle portfolio losses; paying down debt may be better use of funds than risky investments.

**Risk Capacity Score (Financial):**
```
Total Points: ___ / 25

20-25 points: Very High Capacity (can handle 80-100% stocks)
15-19 points: High Capacity (60-80% stocks)
10-14 points: Medium Capacity (40-60% stocks)
5-9 points: Low Capacity (20-40% stocks)
0-4 points: Very Low Capacity (0-20% stocks)
```

## Risk Tolerance Assessment (Emotional/Behavioral)

Risk tolerance is subjective - how much volatility can you handle emotionally?

### 1. Loss Reaction

**Question:** If your $100,000 portfolio dropped to $80,000 (-20%) in a market crash, how would you react?

| Answer | Risk Tolerance |
|--------|----------------|
| **A.** Panic, sell everything, can't sleep at night | Very Low |
| **B.** Very concerned, consider selling | Low |
| **C.** Uncomfortable but hold steady | Medium |
| **D.** Stay calm, stick to plan | High |
| **E.** Excited, buy more at lower prices | Very High |

**Scoring:**
- A = 1 point
- B = 2 points
- C = 3 points
- D = 4 points
- E = 5 points

### 2. Historical Behavior

**Question:** Have you experienced a major market downturn (2008, 2020)? How did you react?

| Answer | Risk Tolerance |
|--------|----------------|
| **A.** Sold stocks near the bottom, locked in losses | Very Low |
| **B.** Reduced equity exposure significantly | Low |
| **C.** Held steady, didn't trade | Medium |
| **D.** Held steady and added to stocks | High |
| **E.** Increased equity exposure significantly | Very High |
| **F.** Haven't experienced a major downturn yet | Unknown (rate yourself hypothetically) |

**Scoring:**
- A = 1 point
- B = 2 points
- C = 3 points
- D = 4 points
- E = 5 points
- F = Use answer to Question 1

**Insight:** Past behavior is the best predictor of future behavior. If you sold in prior crashes, you likely will again.

### 3. Sleep Test

**Question:** What is the largest portfolio decline you could tolerate without losing sleep?

| Answer | Drawdown Tolerance | Risk Tolerance | Suitable Allocation |
|--------|-------------------|----------------|---------------------|
| **A.** -5% | Very Low | Very Low | 20% stocks |
| **B.** -10% | Low | Low | 30-40% stocks |
| **C.** -15% | Medium-Low | Medium-Low | 40-50% stocks |
| **D.** -20% | Medium | Medium | 50-60% stocks |
| **E.** -25% | Medium-High | Medium-High | 60-70% stocks |
| **F.** -30% | High | High | 70-80% stocks |
| **G.** -40% or more | Very High | Very High | 80-100% stocks |

**Scoring:**
- A = 1 point
- B = 2 points
- C = 2.5 points
- D = 3 points
- E = 3.5 points
- F = 4 points
- G = 5 points

**Key Insight:** This is the most important question. Be honest - what loss would cause you to sell in panic?

### 4. Investment Timeframe and Patience

**Question:** If your portfolio underperformed the market for 3 years straight, would you:

| Answer | Risk Tolerance |
|--------|----------------|
| **A.** Immediately switch to index funds | Very Low |
| **B.** Re-evaluate and likely make changes within 6 months | Low |
| **C.** Review carefully, make changes if thesis broken | Medium |
| **D.** Stay patient, 3 years is short-term | High |
| **E.** Add more, contrarian opportunity | Very High |

**Scoring:**
- A = 1 point
- B = 2 points
- C = 3 points
- D = 4 points
- E = 5 points

### 5. Volatility Preference

**Question:** Which investment would you prefer?

| Option | Expected Return | Possible Outcomes | Risk Level |
|--------|----------------|-------------------|------------|
| **A.** Conservative | 4% per year | Range: 2% to 6% | Very Low |
| **B.** Moderate | 6% per year | Range: -5% to 15% | Low |
| **C.** Balanced | 8% per year | Range: -10% to 25% | Medium |
| **D.** Growth | 10% per year | Range: -20% to 40% | High |
| **E.** Aggressive | 12% per year | Range: -35% to 60% | Very High |

**Scoring:**
- A = 1 point
- B = 2 points
- C = 3 points
- D = 4 points
- E = 5 points

**Risk Tolerance Score (Emotional):**
```
Total Points: ___ / 25

20-25 points: Very High Tolerance (comfortable with 80-100% stocks)
15-19 points: High Tolerance (comfortable with 60-80% stocks)
10-14 points: Medium Tolerance (comfortable with 40-60% stocks)
5-9 points: Low Tolerance (comfortable with 20-40% stocks)
0-4 points: Very Low Tolerance (comfortable with 0-20% stocks)
```

## Risk Requirement Assessment (Goals)

Risk requirement is determined by what return you need to achieve financial goals.

### 1. Return Needed

**Question:** What annual return do you need to meet your financial goals?

Calculate: Required Return = (Future Goal - Current Savings) / (Years × Current Savings)

Simplified Self-Assessment:

| Required Return | Risk Requirement | Suitable Allocation |
|----------------|-----------------|---------------------|
| **< 4%** | Low (bonds/cash sufficient) | 20-40% stocks |
| **4-6%** | Medium-Low (conservative stocks work) | 40-60% stocks |
| **6-8%** | Medium (balanced portfolio) | 60-70% stocks |
| **8-10%** | Medium-High (equity-heavy) | 70-85% stocks |
| **> 10%** | High (aggressive growth) | 85-100% stocks |

**Scoring:**
- <4% = 1 point
- 4-6% = 2 points
- 6-8% = 3 points
- 8-10% = 4 points
- >10% = 5 points

### 2. Savings Rate

**Question:** Are you contributing regularly to this portfolio?

| Answer | Risk Requirement Impact |
|--------|------------------------|
| **A.** High savings rate (>20% of income) | Low (can achieve goals with lower returns) |
| **B.** Moderate savings rate (10-20%) | Medium |
| **C.** Low savings rate (<10%) | High (need higher returns) |
| **D.** No contributions, portfolio must grow itself | Very High |
| **E.** Net withdrawing from portfolio | N/A (preservation focus) |

**Scoring:**
- A = 1 point (don't need high risk)
- B = 2 points
- C = 4 points (need higher returns)
- D = 5 points
- E = 1 point (focus shifts to preservation)

**Rationale:** High savings rate means goals can be met with lower investment returns; low savings requires taking more risk.

### 3. Goal Flexibility

**Question:** How flexible are your financial goals?

| Answer | Risk Requirement Impact |
|--------|------------------------|
| **A.** Very flexible (can delay retirement, reduce spending) | Low (can afford conservative approach) |
| **B.** Somewhat flexible | Medium |
| **C.** Not flexible (specific retirement date, fixed expenses) | High (must meet return target) |

**Scoring:**
- A = 1 point
- B = 3 points
- C = 5 points

**Risk Requirement Score:**
```
Total Points: ___ / 15

12-15 points: High Requirement (need 70-100% stocks)
9-11 points: Medium-High Requirement (need 60-80% stocks)
6-8 points: Medium Requirement (need 40-60% stocks)
3-5 points: Low Requirement (need 20-40% stocks)
0-2 points: Very Low Requirement (can use conservative allocation)
```

## Synthesizing the Three Assessments

### Step 1: Calculate Component Scores

```
Risk Capacity Score: ___ / 25 → Convert to 1-5 scale = ___
Risk Tolerance Score: ___ / 25 → Convert to 1-5 scale = ___
Risk Requirement Score: ___ / 15 → Convert to 1-5 scale = ___
```

**Conversion Table:**

| Raw Score (out of max) | Converted Score (1-5) |
|------------------------|----------------------|
| 0-20% | 1 |
| 21-40% | 2 |
| 41-60% | 3 |
| 61-80% | 4 |
| 81-100% | 5 |

### Step 2: Determine Overall Risk Profile

**Method 1: Conservative (Recommended for Most Investors)**

Use the **lowest** of the three scores. This ensures you don't take more risk than you can handle.

```
Risk Capacity: 4
Risk Tolerance: 2 ← Lowest
Risk Requirement: 4

Overall Risk Profile: 2 (Low)
Recommended Allocation: 30-40% stocks
```

**Rationale:** If emotional tolerance is low (2), it doesn't matter that capacity and requirement are higher - investor will sell in panic during crash.

**Method 2: Balanced**

Use the **average** of the three scores.

```
Risk Capacity: 4
Risk Tolerance: 2
Risk Requirement: 4

Average: (4 + 2 + 4) / 3 = 3.33 → 3 (Medium)
Recommended Allocation: 50-60% stocks
```

**Rationale:** Balances all factors, may take slightly more risk than emotional tolerance suggests.

**Method 3: Adaptive**

Weight the scores based on individual circumstances:

```
Typical weighting:
Risk Tolerance: 50% (most important - behavioral)
Risk Capacity: 30% (financial constraints)
Risk Requirement: 20% (goals)

Example:
Capacity: 4 × 0.30 = 1.2
Tolerance: 2 × 0.50 = 1.0
Requirement: 4 × 0.20 = 0.8

Weighted Score: 1.2 + 1.0 + 0.8 = 3.0 (Medium)
```

### Step 3: Map to Asset Allocation

| Overall Risk Score | Risk Profile | Recommended Stocks % | Recommended Bonds % |
|-------------------|--------------|---------------------|---------------------|
| **1.0 - 1.5** | Very Low (Conservative) | 20-30% | 60-70% |
| **1.6 - 2.5** | Low (Conservative) | 30-40% | 50-60% |
| **2.6 - 3.5** | Medium (Moderate) | 50-60% | 35-45% |
| **3.6 - 4.5** | High (Growth) | 70-80% | 15-25% |
| **4.6 - 5.0** | Very High (Aggressive) | 85-100% | 0-10% |

### Step 4: Resolve Conflicts

**Conflict Example:**

```
Risk Capacity: 5 (Very High - young, stable income, long horizon)
Risk Tolerance: 2 (Low - can't handle volatility emotionally)
Risk Requirement: 4 (High - need high returns to meet goals)
```

**Resolution:**

This investor **needs** to take risk (requirement), **can** take risk (capacity), but **can't handle** risk emotionally (tolerance).

**Options:**

1. **Conservative approach (Recommended):**
   - Use risk tolerance as limit (30-40% stocks)
   - Accept that goals may not be met with investment returns alone
   - Increase savings rate to compensate for lower returns
   - Work longer or reduce spending goals

2. **Education approach:**
   - Work on improving risk tolerance through education
   - Start with moderate allocation (50% stocks)
   - Gradually increase equity exposure as comfort grows
   - Build tolerance through experience

3. **Mismatch acceptance (Not Recommended):**
   - Use higher allocation (70%+ stocks) despite low tolerance
   - **Risk:** Will likely panic-sell in crash, locking in losses
   - **Outcome:** Worst of both worlds - volatility AND poor returns

**Best Practice:** Never exceed emotional risk tolerance. If goals can't be met with acceptable risk level, adjust goals or increase savings.

## Risk Profile Classification

### Conservative Profile (Risk Score: 1-2)

**Characteristics:**
- Low risk tolerance (can't handle >10-15% loss)
- Near retirement or retired
- Portfolio represents most of wealth
- Needs capital preservation and income

**Recommended Allocation:** 20-40% stocks, 60-80% bonds

**Behavioral Tendencies:**
- May sell stocks during corrections (>10% drop)
- Prefers stability over growth
- Anxious about volatility
- Needs reassurance during downturns

**Management Approach:**
- Conservative allocation with high bond allocation
- Focus on dividend income and bond interest
- Avoid volatile stocks (high-beta tech)
- Regular communication during volatility
- Emphasis on stability and capital preservation

### Moderate Profile (Risk Score: 2.6-3.5)

**Characteristics:**
- Medium risk tolerance (can handle 15-25% loss)
- Mid-career, 10-20 year horizon
- Balanced income and growth needs
- Some anxiety about volatility but can stay the course

**Recommended Allocation:** 50-60% stocks, 35-45% bonds

**Behavioral Tendencies:**
- May consider selling in bear markets but likely holds
- Wants growth but also wants to sleep at night
- Seeks balanced approach
- Needs data and reassurance during volatility

**Management Approach:**
- Balanced portfolio with stock and bond components
- Diversified across sectors and asset classes
- Regular rebalancing to maintain targets
- Education on long-term perspective
- Quarterly reviews with clear communication

### Growth Profile (Risk Score: 3.6-4.5)

**Characteristics:**
- High risk tolerance (can handle 25-35% loss)
- Long time horizon (15-30 years)
- Focus on capital appreciation
- Emotionally stable during volatility

**Recommended Allocation:** 70-80% stocks, 15-25% bonds

**Behavioral Tendencies:**
- Stays invested during downturns
- May add to stocks during corrections
- Comfortable with volatility
- Understands risk/reward tradeoffs

**Management Approach:**
- Equity-heavy portfolio with growth focus
- Diversified across sectors and geographies
- Limited bond allocation (volatility dampening only)
- Emphasis on long-term performance
- Semi-annual or annual reviews

### Aggressive Profile (Risk Score: 4.6-5.0)

**Characteristics:**
- Very high risk tolerance (can handle >35% loss)
- Very long time horizon (25+ years)
- Seeks maximum growth
- Views volatility as opportunity

**Recommended Allocation:** 85-100% stocks, 0-10% bonds

**Behavioral Tendencies:**
- Buys during crashes
- Comfortable with extreme volatility
- Focuses on long-term compounding
- Rational decision-making during panic

**Management Approach:**
- Equity-focused or 100% equity portfolio
- Growth-oriented stock selection
- International and emerging market exposure
- Minimal to no bonds
- Annual reviews with emphasis on strategy

## Questionnaire Summary

Use this simplified questionnaire for quick assessment:

```
INVESTOR RISK PROFILE QUESTIONNAIRE

Name: _______________  Date: _______________

1. Age: ___ → Time horizon: ___ years

2. Investment time horizon before major withdrawal:
   [ ] 0-5 years  [ ] 5-10 years  [ ] 10-20 years  [ ] 20+ years

3. What is the maximum portfolio decline you could tolerate?
   [ ] -5%  [ ] -10%  [ ] -15%  [ ] -20%  [ ] -30%  [ ] -40%+

4. Income stability:
   [ ] Very stable (pension)  [ ] Stable (salary)  [ ] Variable (commission/business)

5. This portfolio represents what % of your net worth?
   [ ] <25%  [ ] 25-50%  [ ] 50-75%  [ ] >75%

6. Emergency fund status:
   [ ] Fully funded (6+ months)  [ ] Partial (3 months)  [ ] None

7. If market crashed 25%, would you:
   [ ] Panic sell  [ ] Sell some  [ ] Hold steady  [ ] Buy more

8. Investment experience with bear markets:
   [ ] Never experienced  [ ] Experienced, sold stocks  [ ] Experienced, held  [ ] Experienced, bought more

9. Return needed to meet goals:
   [ ] <4%  [ ] 4-6%  [ ] 6-8%  [ ] 8-10%  [ ] >10%

10. Primary investment objective:
    [ ] Capital preservation  [ ] Income  [ ] Balanced growth & income  [ ] Growth  [ ] Aggressive growth

SCORING & RECOMMENDATION:

Risk Capacity Score: ___ / 25
Risk Tolerance Score: ___ / 25
Risk Requirement Score: ___ / 15

Overall Risk Profile: [ ] Conservative  [ ] Moderate  [ ] Growth  [ ] Aggressive

Recommended Allocation:
Stocks: ___%
Bonds: ___%
Cash: ___%

Notes:
________________________________________________________________
________________________________________________________________
________________________________________________________________

Advisor Signature: _______________  Client Signature: _______________
```

## Summary

**Key Principles:**

1. **Three-dimensional assessment:** Capacity, Tolerance, Requirement
2. **Tolerance is the constraint:** Never exceed emotional tolerance
3. **Honest self-assessment:** Past behavior predicts future behavior
4. **Resolve conflicts conservatively:** When scores conflict, use lowest
5. **Periodic reassessment:** Risk profile changes with age and circumstances
6. **Allocation must match profile:** Mismatch leads to behavioral errors

**Remember:** The best allocation is one you can stick with through market cycles. It's better to have a moderate allocation you can maintain than an aggressive allocation you'll abandon in a crash. Behavioral discipline matters more than optimal allocation.
