# Target Allocation Models

This document provides model portfolio allocations for different investor risk profiles, serving as benchmarks for portfolio analysis and rebalancing.

## Overview

Target allocations provide a framework for:
1. Assessing if current portfolio matches investor risk tolerance
2. Identifying allocation gaps and concentration risks
3. Guiding rebalancing decisions
4. Setting position sizing guidelines

**Important:** These are templates, not prescriptions. Actual allocations should be customized based on individual circumstances, goals, time horizon, and constraints.

## Investor Risk Profile Classification

### Factors Determining Risk Profile

| Factor | Conservative | Moderate | Growth | Aggressive |
|--------|-------------|----------|--------|------------|
| **Age** | 60+ | 45-60 | 30-45 | <30 |
| **Time Horizon** | 0-5 years | 5-15 years | 15-25 years | 25+ years |
| **Income Stability** | Fixed income (retired) | Stable salary | Growing career | Variable/high |
| **Net Worth** | Low to moderate | Moderate | High | Very high |
| **Loss Tolerance** | Cannot afford >10% loss | Can handle 15-25% loss | Can handle 25-35% loss | Can handle >40% loss |
| **Investment Goal** | Preserve capital, income | Balanced growth & income | Long-term growth | Maximum growth |
| **Market Experience** | Limited | Moderate | Experienced | Very experienced |

**Self-Assessment:**
Rate yourself on each factor, assign the corresponding risk profile, and determine your overall profile based on the majority classification.

## Conservative Portfolio (Capital Preservation)

### Profile
- **Investor:** Near or in retirement, low risk tolerance, need for income and capital preservation
- **Time Horizon:** 0-5 years
- **Max Acceptable Drawdown:** -10 to -15%
- **Expected Annual Return:** 4-6%
- **Expected Volatility:** 6-10%

### Asset Allocation

```
Total Portfolio Allocation:
├── Equities: 30%
│   ├── US Stocks: 20%
│   ├── International Developed: 7%
│   └── Emerging Markets: 3%
├── Fixed Income: 55%
│   ├── Investment Grade Bonds: 30%
│   ├── Government Bonds: 20%
│   └── High Yield Bonds: 5%
├── Cash & Equivalents: 10%
└── Alternatives (Optional): 5%
    ├── REITs: 3%
    └── Gold: 2%
```

### Equity Allocation (30% of total portfolio)

**US Stocks (20% of total, 67% of equity):**

| Sector | % of Total Portfolio | % of US Equity | Characteristics |
|--------|---------------------|----------------|-----------------|
| **Utilities** | 3.5% | 17.5% | High dividends, stable cash flows |
| **Consumer Staples** | 3.0% | 15.0% | Defensive, recession-resistant |
| **Healthcare** | 3.5% | 17.5% | Defensive with growth potential |
| **Financials** | 2.5% | 12.5% | Dividend income, moderate growth |
| **Technology** | 2.5% | 12.5% | Quality large-caps only (AAPL, MSFT) |
| **Communication Services** | 2.0% | 10.0% | Stable cash flows (T, VZ) |
| **Consumer Discretionary** | 1.5% | 7.5% | Underweight cyclicals |
| **Industrials** | 1.0% | 5.0% | Minimal exposure |
| **Real Estate** | 0.5% | 2.5% | Via separate REIT allocation |
| **Energy** | 0% | 0% | Avoid volatility |
| **Materials** | 0% | 0% | Avoid volatility |

**International & Emerging (10% of total, 33% of equity):**
- International Developed: 7% (Europe, Japan, UK - stable, dividend-focused)
- Emerging Markets: 3% (minimal exposure, diversification only)

**Position Sizing:**
- Maximum single position: 5% of total portfolio
- Typical position: 2-3%
- Number of positions: 12-20 stocks OR 4-6 diversified ETFs

**Preferred Holdings:**
- Large-cap dividend aristocrats (25+ years of dividend growth)
- Defensive sectors with recession resistance
- Low beta stocks (β < 0.8)
- Established companies with strong balance sheets

**Example Portfolio (ETF-based):**
- 10% VZ (Verizon) - Telecom, 6% yield
- 10% JNJ (Johnson & Johnson) - Healthcare, dividend aristocrat
- 10% PG (Procter & Gamble) - Consumer staples, stable
- 5% SO (Southern Company) - Utility, high yield
- 5% KO (Coca-Cola) - Consumer staples, dividend
- 5% PFE (Pfizer) - Healthcare, value
- (Or equivalent via dividend-focused ETFs: VYM, SCHD, DVY)

### Fixed Income Allocation (55% of total portfolio)

| Bond Type | % of Total Portfolio | Purpose |
|-----------|---------------------|---------|
| **Investment Grade Corporate** | 30% | Income, moderate risk |
| **US Treasury Bonds** | 15% | Safety, low risk |
| **TIPS (Inflation-Protected)** | 5% | Inflation hedge |
| **High Yield (Junk Bonds)** | 5% | Higher income, higher risk |

**Duration:** Short to intermediate (3-7 years) to reduce interest rate risk

**Example Holdings:**
- AGG (Core Bond ETF)
- BND (Total Bond Market)
- LQD (Investment Grade Corporate)
- TIP (TIPS)
- HYG (High Yield - small allocation)

### Cash & Equivalents (10%)

**Purpose:**
- Emergency liquidity
- Opportunistic buying on dips
- Reduce overall volatility

**Holdings:**
- Money market funds
- Short-term Treasury bills
- High-yield savings accounts

---

## Moderate Portfolio (Balanced Growth & Income)

### Profile
- **Investor:** Mid-career, balanced objectives, moderate risk tolerance
- **Time Horizon:** 5-15 years
- **Max Acceptable Drawdown:** -15 to -25%
- **Expected Annual Return:** 6-8%
- **Expected Volatility:** 10-14%

### Asset Allocation

```
Total Portfolio Allocation:
├── Equities: 60%
│   ├── US Stocks: 42%
│   ├── International Developed: 12%
│   └── Emerging Markets: 6%
├── Fixed Income: 32%
│   ├── Investment Grade Bonds: 20%
│   ├── Government Bonds: 7%
│   └── High Yield Bonds: 5%
├── Cash & Equivalents: 5%
└── Alternatives (Optional): 3%
    ├── REITs: 2%
    └── Commodities/Gold: 1%
```

### Equity Allocation (60% of total portfolio)

**US Stocks (42% of total, 70% of equity):**

| Sector | % of Total Portfolio | % of US Equity | Benchmark (S&P 500) |
|--------|---------------------|----------------|---------------------|
| **Technology** | 11.0% | 26% | 28% |
| **Healthcare** | 7.0% | 17% | 13% |
| **Financials** | 6.0% | 14% | 13% |
| **Consumer Discretionary** | 5.5% | 13% | 11% |
| **Industrials** | 4.0% | 10% | 9% |
| **Consumer Staples** | 3.5% | 8% | 7% |
| **Communication Services** | 2.5% | 6% | 9% |
| **Energy** | 1.0% | 2% | 4% |
| **Utilities** | 1.0% | 2% | 3% |
| **Real Estate** | 0.5% | 1% | 3% |
| **Materials** | 0.5% | 1% | 3% |

**Sector Strategy:**
- Slight overweight in Technology and Healthcare (growth + quality)
- Balanced exposure to Financials and Consumer sectors
- Underweight Energy and Materials (volatility)
- Defensive sectors (Utilities, Staples) lower than conservative portfolio

**International & Emerging (18% of total, 30% of equity):**
- International Developed: 12% (Europe, Japan, UK, Canada)
- Emerging Markets: 6% (China, India, Brazil - growth exposure)

**Position Sizing:**
- Maximum single position: 8% of total portfolio
- High conviction positions: 6-8%
- Medium conviction: 4-6%
- Low conviction: 2-3%
- Number of positions: 15-25 stocks OR 6-10 ETFs

**Market Cap Distribution:**
- Large-cap (>$10B): 70% of US equity
- Mid-cap ($2-10B): 20%
- Small-cap (<$2B): 10%

**Example Portfolio (Individual Stocks):**
- 8% MSFT - Technology, quality growth
- 7% AAPL - Technology, ecosystem
- 6% GOOGL - Technology, advertising
- 6% JNJ - Healthcare, defensive
- 5% JPM - Financials, dividend
- 5% UNH - Healthcare, growth
- 4% V - Financials, payments
- 4% HD - Consumer Discretionary, housing
- 4% DIS - Communication, entertainment
- 3% BA - Industrials, aerospace
- (Additional 15% in 8-10 smaller positions)
- 18% International (VEA, VWO, or individual stocks)

### Fixed Income Allocation (32% of total portfolio)

| Bond Type | % of Total Portfolio | Purpose |
|-----------|---------------------|---------|
| **Investment Grade Corporate** | 20% | Core income, moderate risk |
| **US Treasury Bonds** | 5% | Safety ballast |
| **TIPS** | 2% | Inflation hedge |
| **High Yield Bonds** | 5% | Enhanced income |

**Duration:** Intermediate (5-10 years)

---

## Growth Portfolio (Long-Term Capital Appreciation)

### Profile
- **Investor:** Younger investor, long time horizon, growth-focused
- **Time Horizon:** 15-25 years
- **Max Acceptable Drawdown:** -25 to -35%
- **Expected Annual Return:** 8-10%
- **Expected Volatility:** 14-18%

### Asset Allocation

```
Total Portfolio Allocation:
├── Equities: 80%
│   ├── US Stocks: 52%
│   ├── International Developed: 18%
│   └── Emerging Markets: 10%
├── Fixed Income: 15%
│   ├── Investment Grade Bonds: 8%
│   └── High Yield Bonds: 7%
├── Cash & Equivalents: 3%
└── Alternatives: 2%
    └── REITs or Commodities: 2%
```

### Equity Allocation (80% of total portfolio)

**US Stocks (52% of total, 65% of equity):**

| Sector | % of Total Portfolio | % of US Equity | Notes |
|--------|---------------------|----------------|-------|
| **Technology** | 16.0% | 31% | Growth focus, secular trends |
| **Healthcare** | 8.0% | 15% | Innovation, demographics |
| **Consumer Discretionary** | 7.5% | 14% | Economic growth exposure |
| **Communication Services** | 6.0% | 12% | Digital transformation |
| **Financials** | 5.5% | 11% | Economic expansion |
| **Industrials** | 5.0% | 10% | Capital spending cycles |
| **Consumer Staples** | 2.0% | 4% | Underweight defensive |
| **Energy** | 1.0% | 2% | Minimal exposure |
| **Materials** | 0.5% | 1% | Minimal exposure |
| **Utilities** | 0.5% | 1% | Minimal exposure |
| **Real Estate** | 0% | 0% | Separate REIT allocation |

**Sector Strategy:**
- Heavy overweight Technology (innovation, secular growth)
- Overweight Healthcare (demographics, innovation)
- Growth and cyclical sectors emphasized
- Minimal defensive sectors (don't need stability)

**International & Emerging (28% of total, 35% of equity):**
- International Developed: 18% (quality international growth)
- Emerging Markets: 10% (higher growth potential)

**Position Sizing:**
- Maximum single position: 10% of total portfolio
- High conviction positions: 8-10%
- Medium conviction: 5-7%
- Low conviction: 2-4%
- Number of positions: 15-30 stocks

**Market Cap Distribution:**
- Large-cap: 60% of US equity
- Mid-cap: 25%
- Small-cap: 15% (growth potential)

**Growth vs Value Tilt:** Balanced to slight growth tilt (not extreme)

**Example Portfolio:**
- 10% NVDA - Technology, AI leadership
- 9% MSFT - Technology, cloud + AI
- 8% AAPL - Technology, ecosystem
- 7% GOOGL - Technology, AI + advertising
- 6% AMZN - Consumer Discretionary, AWS
- 6% META - Communication, digital advertising
- 5% TSLA - Consumer Discretionary, EV + energy
- 5% UNH - Healthcare, managed care
- 4% V - Financials, payments
- 4% MA - Financials, payments
- (Remaining 36% in 15-20 smaller positions + international)

### Fixed Income Allocation (15% of total portfolio)

| Bond Type | % of Total Portfolio | Purpose |
|-----------|---------------------|---------|
| **Investment Grade Corporate** | 8% | Moderate income, volatility dampening |
| **High Yield Bonds** | 7% | Enhanced returns, equity-like exposure |

**Duration:** Intermediate to long (7-15 years) - can handle rate risk

---

## Aggressive Portfolio (Maximum Growth)

### Profile
- **Investor:** Young, high income, very high risk tolerance, long horizon
- **Time Horizon:** 20+ years
- **Max Acceptable Drawdown:** -35 to -50%
- **Expected Annual Return:** 9-12%
- **Expected Volatility:** 18-22%

### Asset Allocation

```
Total Portfolio Allocation:
├── Equities: 95%
│   ├── US Stocks: 57%
│   ├── International Developed: 23%
│   └── Emerging Markets: 15%
├── Fixed Income: 0-5%
└── Cash & Equivalents: 0-5%
```

### Equity Allocation (95% of total portfolio)

**US Stocks (57% of total, 60% of equity):**

| Sector | % of Total Portfolio | % of US Equity | Strategy |
|--------|---------------------|----------------|----------|
| **Technology** | 20.0% | 35% | Maximum exposure to innovation |
| **Healthcare** | 9.0% | 16% | Biotech, medical devices, innovation |
| **Consumer Discretionary** | 9.0% | 16% | E-commerce, luxury, travel |
| **Communication Services** | 6.0% | 11% | Digital platforms, streaming |
| **Financials** | 6.0% | 11% | Fintechs, growth-oriented |
| **Industrials** | 4.0% | 7% | Aerospace, automation |
| **Consumer Staples** | 1.0% | 2% | Minimal |
| **Energy** | 1.0% | 2% | Renewables focus |
| **Materials** | 0.5% | 1% | Minimal |
| **Utilities** | 0.5% | 1% | Minimal |

**Sector Strategy:**
- Extreme overweight Technology (35% vs 28% benchmark)
- Growth sectors dominate (80%+ of portfolio)
- Minimal defensive exposure
- Willing to accept high volatility

**International & Emerging (38% of total, 40% of equity):**
- International Developed: 23% (European tech, Asian growth)
- Emerging Markets: 15% (China tech, India growth, LatAm)

**Position Sizing:**
- Maximum single position: 12% of total portfolio
- High conviction positions: 10-12%
- Medium conviction: 6-9%
- Low conviction: 3-5%
- Number of positions: 12-25 stocks (concentrated)

**Market Cap Distribution:**
- Large-cap: 55%
- Mid-cap: 30%
- Small-cap: 15% (higher growth potential, higher risk)

**Growth vs Value:** Strong growth tilt

**Style Characteristics:**
- High P/E ratios acceptable (growth premium)
- Focus on revenue growth over profitability (for some positions)
- Secular themes: AI, cloud, EVs, fintech, biotech
- May include speculative positions (5-10% total)

**Example Portfolio:**
- 12% NVDA - Technology, AI chips
- 10% TSLA - Consumer Discretionary, EVs + autonomy
- 9% MSFT - Technology, cloud + AI
- 8% GOOGL - Technology, AI + advertising
- 8% META - Communication, VR/AI
- 7% AMZN - Consumer Discretionary, AWS
- 6% AAPL - Technology, ecosystem
- 5% SHOP - Technology, e-commerce platform
- 5% SQ - Fintech, payments
- 4% CRSP - Healthcare, gene editing
- 4% ENPH - Energy, solar
- (Remaining 22% in smaller growth positions + international exposure)

### Fixed Income Allocation (0-5% of total portfolio)

**Minimal to none:**
- 0-5% investment grade or cash for liquidity only
- No need for volatility dampening given time horizon
- 100% equity acceptable for this profile

---

## Specialized Allocation Considerations

### Dividend Income Portfolio

**Objective:** Maximize current income while preserving capital

**Allocation:**
- Equities: 60% (dividend-focused)
  - High-yield stocks (4-7% yields): 40%
  - Dividend growth stocks: 20%
- Fixed Income: 30% (income-focused)
  - Investment grade corporate: 15%
  - High yield bonds: 10%
  - Preferred stocks: 5%
- REITs: 10% (high dividends, inflation hedge)

**Target Yield:** 4-6% on total portfolio

### Tax-Efficient Portfolio (Taxable Account)

**Considerations:**
- Minimize turnover (reduce capital gains)
- Favor qualified dividends and long-term gains
- Tax-loss harvesting opportunities
- Municipal bonds (if high tax bracket)

**Allocation Adjustments:**
- Growth stocks (low/no dividends): Higher weight
- Municipal bonds: Replace corporate bonds
- Index funds: Higher weight vs active funds
- International: Lower weight (foreign tax complexity)

### Retirement Portfolio (Post-Retirement)

**Objective:** Generate income, preserve capital, manage longevity risk

**Allocation (varies by age):**
- Age 65: 40/60 stocks/bonds
- Age 75: 30/70 stocks/bonds
- Age 85: 20/80 stocks/bonds

**Income Strategy:**
- 4% withdrawal rate (sustainable)
- Bucket approach:
  - Bucket 1 (0-2 years expenses): Cash
  - Bucket 2 (3-7 years): Bonds
  - Bucket 3 (8+ years): Stocks

---

## Position Sizing Guidelines by Risk Profile

| Risk Profile | Max Single Position | Typical Position | Min # of Stocks | Max # of Stocks |
|--------------|--------------------|--------------------|----------------|----------------|
| **Conservative** | 5% | 2-3% | 12 | 20 |
| **Moderate** | 8% | 4-6% | 15 | 25 |
| **Growth** | 10% | 5-7% | 15 | 30 |
| **Aggressive** | 12% | 6-9% | 12 | 25 |

**Single Sector Maximums:**

| Risk Profile | Max Single Sector |
|--------------|------------------|
| **Conservative** | 25% |
| **Moderate** | 30% |
| **Growth** | 35% |
| **Aggressive** | 40% |

---

## Rebalancing Triggers by Risk Profile

| Risk Profile | Rebalancing Frequency | Asset Class Drift Trigger | Position Drift Trigger |
|--------------|----------------------|--------------------------|------------------------|
| **Conservative** | Quarterly | >3% | >2% |
| **Moderate** | Quarterly | >5% | >3% |
| **Growth** | Semi-Annually | >7% | >4% |
| **Aggressive** | Annually | >10% | >5% |

---

## Lifecycle Allocation (Age-Based)

**Traditional Rule of Thumb:** "120 minus your age" in stocks

| Age | Stock % | Bond % | Formula |
|-----|---------|--------|---------|
| 25 | 95% | 5% | 120 - 25 |
| 35 | 85% | 15% | 120 - 35 |
| 45 | 75% | 25% | 120 - 45 |
| 55 | 65% | 35% | 120 - 55 |
| 65 | 55% | 45% | 120 - 65 |
| 75 | 45% | 55% | 120 - 75 |

**Modern Adjustment:** "130 minus your age" (accounts for longer lifespans, low interest rates)

---

## Using Target Allocations in Portfolio Analysis

### 1. Identify Current Allocation
Calculate actual portfolio percentages across:
- Asset classes (stocks/bonds/cash)
- Sectors (within stocks)
- Geographic regions
- Market caps

### 2. Compare to Target Model
Select appropriate model based on:
- Investor risk tolerance assessment
- Time horizon
- Financial situation
- Goals

### 3. Calculate Deviations
```
Deviation = Current % - Target %

Example:
Target (Moderate): 60% stocks
Current: 68% stocks
Deviation: +8% (overweight stocks)
```

### 4. Generate Rebalancing Plan
- Trim overweight positions/sectors
- Add to underweight positions/sectors
- Prioritize based on magnitude of deviation

### 5. Adjust for Individual Circumstances
Templates are starting points, not rigid rules:
- Tax situation may favor certain holdings
- Unique expertise may justify sector overweight
- Employer stock may create concentration
- Real estate holdings (home) affect allocation

---

## Summary

**Key Takeaways:**

1. **Target allocations are guidelines,** not mandates - customize to individual circumstances
2. **Risk profile drives allocation** - match stocks/bonds to risk tolerance and time horizon
3. **Sector allocation matters** - within equity allocation, sector mix drives risk and return
4. **Position sizing discipline** - enforce maximum position sizes to control concentration
5. **Rebalance systematically** - maintain target allocation over time, don't drift unintentionally
6. **Lifecycle matters** - adjust allocation as you age and circumstances change

**Remember:** The best allocation is one you can stick with through market cycles. Don't choose an aggressive allocation if you'll panic-sell in a 30% drawdown. Match allocation to your true risk tolerance, not your aspirational risk tolerance.
