# Scenario Playbooks

このリファレンスは、18ヶ月シナリオを構築するためのテンプレートとベストプラクティスを提供します。
シナリオ分析時に、一貫性のある質の高いシナリオを作成するために使用します。

## シナリオ構築の基本原則

### 1. MECE原則（Mutually Exclusive, Collectively Exhaustive）

シナリオは以下の条件を満たすべき：
- **相互排他**: 各シナリオは重複しない
- **網羅的**: 主要な可能性を全てカバー

### 2. 確率配分ガイドライン

| シナリオ | 典型的範囲 | 配分の根拠 |
|---------|----------|-----------|
| Base Case | 50-65% | 最も蓋然性の高い展開 |
| Bull Case | 15-25% | ポジティブな上振れ |
| Bear Case | 20-30% | ネガティブな下振れ |
| 合計 | 100% | 必ず100%になるよう調整 |

**非対称配分が適切な場合:**
- Bull > Bear: 強気材料が多い環境
- Bear > Bull: リスク要因が多い環境
- Base > 60%: 不確実性が低い状況
- Base < 50%: 不確実性が極めて高い状況（Base Caseも不確実）

### 3. タイムライン区切り

**3フェーズ構造:**
- **0-6ヶ月**: 短期的反応、初動
- **6-12ヶ月**: 中期的展開、トレンド形成
- **12-18ヶ月**: 長期的帰結、新しい均衡

---

## シナリオテンプレート

### Base Case テンプレート

```markdown
### Base Case（XX%確率）

**概要**:
[1-2文でシナリオを要約。最も蓋然性の高い展開を記述]

**仮定条件**:
- [仮定1]: [具体的な条件]
- [仮定2]: [具体的な条件]
- [仮定3]: [具体的な条件]

**タイムライン**:

**0-6ヶ月:**
- [主要な展開1]
- [主要な展開2]
- [市場の反応予想]

**6-12ヶ月:**
- [中期的な展開1]
- [中期的な展開2]
- [トレンドの方向性]

**12-18ヶ月:**
- [長期的な帰結1]
- [新しい均衡状態]
- [構造的変化（あれば）]

**経済指標への影響**:
| 指標 | 現状 | 6ヶ月後予想 | 12ヶ月後予想 | 18ヶ月後予想 |
|------|------|------------|-------------|-------------|
| GDP成長率 | X% | X% | X% | X% |
| インフレ率 | X% | X% | X% | X% |
| 政策金利 | X% | X% | X% | X% |
| 失業率 | X% | X% | X% | X% |

**主要カタリスト**:
- [このシナリオを後押しする要因1]
- [このシナリオを後押しする要因2]

**無効化シグナル**:
- [このシナリオが崩れる兆候1]
- [このシナリオが崩れる兆候2]
```

### Bull Case テンプレート

```markdown
### Bull Case（XX%確率）

**概要**:
[1-2文で楽観シナリオを要約。どのような上振れが起きるか]

**仮定条件**:
- [楽観的仮定1]: [具体的な条件]
- [楽観的仮定2]: [具体的な条件]
- [楽観的仮定3]: [具体的な条件]

**タイムライン**:

**0-6ヶ月:**
- [ポジティブな展開1]
- [ポジティブな展開2]
- [市場の好反応予想]

**6-12ヶ月:**
- [上振れトレンドの継続]
- [追加のポジティブ要因]
- [市場心理の改善]

**12-18ヶ月:**
- [楽観シナリオの帰結]
- [達成される状態]
- [持続可能性の評価]

**経済指標への影響**:
[Base Caseより良い数値を想定]

**上振れカタリスト**:
- [このシナリオを実現させる要因1]
- [このシナリオを実現させる要因2]

**このシナリオの確率を上げる条件**:
- [条件1]
- [条件2]
```

### Bear Case テンプレート

```markdown
### Bear Case（XX%確率）

**概要**:
[1-2文でリスクシナリオを要約。どのような下振れが起きるか]

**仮定条件**:
- [リスク仮定1]: [具体的な条件]
- [リスク仮定2]: [具体的な条件]
- [リスク仮定3]: [具体的な条件]

**タイムライン**:

**0-6ヶ月:**
- [ネガティブな展開1]
- [ネガティブな展開2]
- [市場の悪反応予想]

**6-12ヶ月:**
- [下振れトレンドの継続/深化]
- [二次的な問題の顕在化]
- [市場心理の悪化]

**12-18ヶ月:**
- [リスクシナリオの帰結]
- [最悪の場合の状態]
- [回復の道筋（あれば）]

**経済指標への影響**:
[Base Caseより悪い数値を想定]

**下振れリスク要因**:
- [このシナリオを引き起こす要因1]
- [このシナリオを引き起こす要因2]

**このシナリオの確率を上げる条件**:
- [条件1]
- [条件2]

**リスク緩和要因**:
- [このシナリオを軽減する可能性のある要因1]
- [このシナリオを軽減する可能性のある要因2]
```

---

## イベントタイプ別シナリオプレイブック

### 1. 金融政策イベント（利上げ）

**Base Case（55%）:**
- 想定通りの利上げ実施
- 市場は概ね織り込み済み
- 軽微な株安、債券利回り小幅上昇

**Bull Case（20%）:**
- 利上げ幅が予想より小さい
- ハト派的なフォワードガイダンス
- 株式市場ラリー

**Bear Case（25%）:**
- 利上げ幅が予想より大きい
- タカ派的なフォワードガイダンス
- 株式市場急落、信用スプレッド拡大

### 2. 地政学イベント（紛争勃発）

**Base Case（50%）:**
- 紛争の限定的拡大
- 短期的なコモディティ価格上昇
- 数ヶ月で状況安定化

**Bull Case（15%）:**
- 早期停戦・和平合意
- コモディティ価格正常化
- 市場は早期に回復

**Bear Case（35%）:**
- 紛争の長期化・拡大
- コモディティ供給の重大な混乱
- グローバルインフレ加速、景気後退リスク

### 3. テクノロジーシフト（AI規制）

**Base Case（50%）:**
- 緩やかな規制導入
- 業界自主規制が主体
- イノベーションへの影響限定的

**Bull Case（25%）:**
- 規制が業界に有利な形で策定
- 規制の明確化でむしろ投資加速
- 大手に有利な参入障壁形成

**Bear Case（25%）:**
- 厳格な規制導入
- AI開発の大幅な制限
- 米国企業の競争力低下

### 4. 企業イベント（大型M&A）

**Base Case（60%）:**
- 規制当局の承認取得
- 予定通りのクロージング
- 統合シナジーの段階的実現

**Bull Case（15%）:**
- 予想を上回るシナジー実現
- 統合が順調
- 追加のM&A戦略が奏功

**Bear Case（25%）:**
- 規制当局の阻止または条件付き承認
- 統合の遅延・失敗
- シナジー未達成

---

## シナリオ品質チェックリスト

### 内部整合性
- [ ] 各シナリオの仮定条件は論理的に整合しているか
- [ ] タイムラインの展開は因果関係が明確か
- [ ] 経済指標の予想は相互に整合しているか

### 外部妥当性
- [ ] 過去の類似事象と整合的か
- [ ] 現在の市場環境を適切に反映しているか
- [ ] 専門家の見解と大きく乖離していないか

### 実用性
- [ ] 投資判断に役立つ具体性があるか
- [ ] モニタリング可能なカタリストが特定されているか
- [ ] 無効化シグナルが明確か

### 網羅性
- [ ] 主要なリスクシナリオが含まれているか
- [ ] 上振れ可能性が適切に考慮されているか
- [ ] テールリスクへの言及があるか

---

## よくある間違いと回避方法

### 1. 現状維持バイアス
**問題**: Base Caseに過度な確率を割り当て（70%以上）
**回避**: 歴史的に見て「何も変わらない」確率は低いことを認識

### 2. 最新バイアス
**問題**: 直近のイベントの影響を過大評価
**回避**: 長期的な視点を維持、過去のパターンを参照

### 3. 確証バイアス
**問題**: ヘッドラインに沿った解釈のみ採用
**回避**: 意図的に反対意見を探す

### 4. 過度の精度
**問題**: 18ヶ月先の数値を小数点以下まで予想
**回避**: 不確実性を認め、レンジで表現

### 5. シナリオの重複
**問題**: Base/Bull/Bearが部分的に重なっている
**回避**: 各シナリオの境界条件を明確化

---

## 確率更新のガイドライン

新しい情報が入った際の確率調整:

| 新情報の性質 | 確率調整の方向 |
|-------------|---------------|
| シナリオを支持するデータ | +5-15% |
| シナリオに反するデータ | -5-15% |
| 決定的な証拠 | +20-30% or -20-30% |
| 新しいリスク要因の出現 | Bear Case +5-10% |
| リスク要因の解消 | Bear Case -5-10% |

**調整後は必ず合計100%に再調整**

---

## 出力品質基準

高品質なシナリオの特徴:
1. **具体性**: 抽象的でなく、数値・日付・名称が含まれる
2. **論理性**: 因果関係が明確
3. **検証可能性**: 後から正否を判断できる
4. **実用性**: 投資判断に直結する情報を含む
5. **謙虚さ**: 不確実性を適切に表現
