# Sector Rotation Knowledge Base

## Market Cycle Framework

The economic cycle can be divided into four primary phases, each characterized by distinct economic conditions and sector performance patterns.

### 1. Early Cycle Recovery

**Economic Characteristics:**
- Economy begins recovering from recession
- GDP growth accelerates from negative/low to positive
- Interest rates remain low
- Central banks maintain accommodative policy
- Credit conditions begin to ease
- Consumer and business confidence starts improving

**Outperforming Sectors:**
- **Technology**: Benefits from improving economic outlook and investment spending
- **Consumer Cyclical/Discretionary**: Rebounds as consumer confidence returns
- **Industrials**: Early beneficiary of economic recovery and capital spending
- **Financials**: Benefits from steepening yield curve and improving credit conditions
- **Real Estate**: Low interest rates support property valuations

**Underperforming Sectors:**
- **Utilities**: Low growth characteristics become less attractive
- **Consumer Defensive/Staples**: Defensive qualities less valued in recovery
- **Healthcare**: Stable growth profile less appealing in early recovery

### 2. Mid Cycle Expansion

**Economic Characteristics:**
- Strong GDP growth continues
- Corporate earnings growth robust
- Employment gains accelerating
- Interest rates begin rising from lows
- Credit spreads narrow
- Inflation remains moderate

**Outperforming Sectors:**
- **Technology**: Continued strong earnings growth
- **Industrials**: Peak capital spending and economic activity
- **Consumer Discretionary**: Strong consumer spending continues
- **Materials**: Strong demand from construction and manufacturing
- **Energy**: Rising economic activity drives energy demand

**Underperforming Sectors:**
- **Utilities**: Rising rates pressure valuations
- **Consumer Staples**: Growth acceleration favors cyclical exposure
- **Telecommunications**: Low growth profile less attractive

### 3. Late Cycle

**Economic Characteristics:**
- GDP growth begins decelerating but remains positive
- Interest rates peak or plateau at higher levels
- Inflation pressures build
- Labor markets tight, wage pressures increase
- Credit conditions begin tightening
- Economic indicators show signs of slowing

**Outperforming Sectors:**
- **Energy**: Benefits from inflation and commodity price strength
- **Materials**: Inflation hedge characteristics
- **Financials**: Higher interest rates support net interest margins
- **Healthcare**: Defensive qualities become attractive as growth slows
- **Consumer Staples**: Defensive positioning as uncertainty rises

**Underperforming Sectors:**
- **Technology**: High valuations pressured by rising rates
- **Consumer Discretionary**: Weakening consumer confidence
- **Real Estate**: High interest rates pressure valuations
- **Industrials**: Capital spending begins to slow

### 4. Recession

**Economic Characteristics:**
- GDP contracts (negative growth)
- Rising unemployment
- Interest rates cut by central banks
- Credit spreads widen significantly
- Corporate earnings decline
- Consumer and business confidence deteriorate

**Outperforming Sectors:**
- **Utilities**: Defensive, stable cash flows attractive
- **Consumer Staples**: Essential goods demand remains stable
- **Healthcare**: Non-discretionary spending, defensive characteristics
- **Telecommunications/Communication Services**: Stable revenue streams

**Underperforming Sectors:**
- **Financials**: Credit losses and economic stress
- **Consumer Discretionary**: Discretionary spending cuts
- **Industrials**: Sharp decline in capital spending
- **Materials**: Demand destruction
- **Energy**: Economic weakness reduces demand
- **Real Estate**: Economic stress and potential defaults

## Sector Characteristics Summary

### Cyclical Sectors (Outperform in Early/Mid Cycle)
- Technology
- Consumer Discretionary
- Industrials
- Materials
- Financials (with varying timing)
- Energy (stronger in Mid/Late Cycle)

### Defensive Sectors (Outperform in Late Cycle/Recession)
- Utilities
- Consumer Staples
- Healthcare
- Communication Services

### Interest Rate Sensitive Sectors
- **Benefit from Rising Rates**: Financials (banks)
- **Hurt by Rising Rates**: Utilities, Real Estate, Technology (high growth)

## Industry-Level Nuances

Within each sector, industry-level performance can vary:

### Technology Sector
- **Early/Mid Cycle Leaders**: Software, Semiconductors, Hardware
- **Late Cycle/Defensive**: IT Services, Enterprise Software (recurring revenue models)

### Consumer Discretionary
- **Early/Mid Cycle Leaders**: Auto Manufacturers, Homebuilders, Retail, Leisure
- **More Resilient**: Education, Entertainment (streaming)

### Financials
- **Early Cycle**: Diversified Banks, Investment Banks
- **Mid/Late Cycle**: Insurance, Asset Managers
- **Recession Vulnerable**: Regional Banks, Consumer Finance

### Industrials
- **Early/Mid Cycle**: Construction, Machinery, Transportation
- **More Defensive**: Aerospace & Defense, Waste Management

### Healthcare
- **Cyclical Elements**: Elective procedures, Medical Devices
- **Defensive Elements**: Pharmaceuticals, Healthcare Plans, Hospitals

### Materials
- **Early/Mid Cycle**: Construction Materials, Chemicals
- **Late Cycle/Inflation Hedge**: Precious Metals (Gold, Silver)

## Key Analysis Principles

1. **No Cycle is Identical**: While patterns repeat, timing and magnitude vary
2. **Multiple Indicators**: Combine sector performance with economic indicators
3. **Rotation is Gradual**: Transitions between cycles occur over months, not days
4. **Relative Performance**: Focus on relative strength vs absolute returns
5. **Leading vs Lagging**: Some sectors lead cycle transitions, others lag
6. **Global Factors**: International economic conditions affect sector performance
7. **Policy Impact**: Central bank and fiscal policy can accelerate or delay rotations

## Probability Assessment Framework

When assessing future scenarios, consider:

- **Strong Evidence (70-85% probability)**: Multiple confirming indicators across sectors
- **Moderate Evidence (50-70% probability)**: Some confirming signals but mixed data
- **Weak Evidence (30-50% probability)**: Limited or conflicting signals
- **Speculative (15-30% probability)**: Contrary to current indicators but possible

Probabilities should reflect:
- Consistency of sector rotation signals
- Breadth of performance patterns
- Alignment with economic indicators
- Historical precedent strength
