# ドラッケンミラーの投資哲学と戦略

## 1. ポジション構築とリスク管理の原則

### 集中投資の哲学
- **"ブタ（pig）になる"**: 確信度の高い機会には大胆に集中投資する
- **分散投資の否定**: 「分散投資はビジネススクールで教える最も誤った概念」
- **待つ戦略**: 年に1-2回の絶好の機会を待ち、その時に大きく張る
- **格言**: 「卵を一つのかごに入れ、そのかごを注意深く見張れ」

### 資金管理の鉄則
- **資本保全が最優先**: 大きなドローダウンは絶対に避ける
- **損失の数学**: 「50%の損失を取り戻すには100%の利益が必要」
- **メリハリのある投資**: 
  - 平時: 損失ゼロ～数%に抑える
  - 確信時: +50～60%の大勝を狙う
- **確信度に応じたポジションサイズ**: 見えない時はバットを振らない

### 損切りの徹底
- **即座の撤退**: 投資理由が崩れたら即座にポジションを解消
- **ソロスの教え**: 「史上最高の損失の切り手」から学んだ損切りの重要性
- **ヘッジの否定**: 「ヘッジが必要なポジションなら、そもそも持つべきではない」
- **勝ちトレードの追加**: 利益が乗っている時はより攻める

## 2. 相場観形成のプロセス

### マクロ経済分析の視点
- **18か月先を見る**: 「現在に投資するな、未来に投資せよ」
- **流動性重視**: 「市場を動かすのは企業収益ではなく中央銀行と流動性」
- **期待の重要性**: 「大事なのは人々がその企業についてこれから何を期待しているか」

### 中央銀行の政策分析
- **政策ミスの察知**: 中央銀行の行き過ぎた政策を見抜く
- **転換点の予測**: 金融政策の大きな転換点を先読み
- **歴史的事例**:
  - 1980年代初頭: ボルカー議長のインフレ抑制を確信し長期国債に集中投資
  - 2003-2004年: FRBの低金利政策の行き過ぎを警戒
  - 2007-2008年: 住宅バブル崩壊を予見し準備

### グローバル・マルチアセット視点
- **5-6つの資産バスケット**: 株式・債券・通貨・コモディティを俯瞰
- **最適な戦場選び**: 最も有利な市場・資産を選択
- **待つも相場**: 明確な機会がない時は現金比率を高める
- **ボラティリティ管理**: 日次変動を0.3-0.4%程度に抑える

## 3. ベアマーケット戦略

### 弱気相場での優位性
- **実績**: 「利益の約80%はベアマーケットで稼いだ」
- **機会の源泉**: 中央銀行の政策ミスによる市場の歪みを突く

### 具体的戦術
- **空売りの難しさ**: 「株式の空売りは非常に難しい」と認識
- **債券ロング**: 景気後退局面では長期国債で利益を狙う
- **安全資産シフト**: 国債、金、安定通貨への乗り換え
- **歪みの活用**: 過剰な悲観から生じる価格歪みを攻めの機会とする

### ベアマーケットの鉄則
1. **早期察知**: 危機の兆候をいち早く捉える
2. **防御態勢**: 株式エクスポージャーを急減
3. **逆張りの勇気**: 過剰反応による歪みに賭ける
4. **生存最優先**: 大損を避け、次の機会まで生き残る

## 4. 投資判断の心構え

### オープンマインドと柔軟性
- **市場の声を聴く**: 自分の予測に固執しない
- **即座の修正**: 誤りに気づいたら即座に方向転換
- **謙虚さ**: 市場に対する謙虚な姿勢を保つ

### メンタル管理
- **自己認識**: 「調子が良い時と悪い時を自覚せよ」
- **調子による調整**:
  - 不調時: バント程度にとどめる
  - 好調時: ホームランを狙う

### 長期的成功の秘訣
- **大胆さと慎重さの両立**: 攻めと守りのメリハリ
- **忍耐力**: 機会を待つ力
- **決断力**: チャンスと見たら最大限のリスクを取る勇気
