# Financial Metrics Reference

## Profitability Metrics

**Gross Profit Margin**
- Formula: (Revenue - COGS) / Revenue × 100
- Measures: Production efficiency and pricing power
- Higher is better; compare to industry average

**Operating Profit Margin**
- Formula: Operating Income / Revenue × 100
- Measures: Operational efficiency
- Excludes financing and tax effects

**Net Profit Margin**
- Formula: Net Income / Revenue × 100
- Measures: Overall profitability after all expenses
- Bottom line efficiency

**Return on Equity (ROE)**
- Formula: Net Income / Shareholders' Equity × 100
- Measures: Profitability relative to shareholder investment
- DuPont Analysis: ROE = Net Margin × Asset Turnover × Equity Multiplier

**Return on Assets (ROA)**
- Formula: Net Income / Total Assets × 100
- Measures: Efficiency in using assets to generate profit

**Return on Invested Capital (ROIC)**
- Formula: NOPAT / Invested Capital × 100
- NOPAT = Net Operating Profit After Tax
- Invested Capital = Total Debt + Total Equity - Cash
- Measures: Return on all capital (debt + equity)

## Valuation Metrics

**Price-to-Earnings (P/E) Ratio**
- Formula: Stock Price / Earnings Per Share
- Trailing P/E: Uses past 12 months earnings
- Forward P/E: Uses estimated future earnings
- Interpretation: Higher P/E = higher growth expectations or overvaluation

**Price-to-Earnings-to-Growth (PEG) Ratio**
- Formula: P/E Ratio / Earnings Growth Rate
- Interpretation: PEG < 1 potentially undervalued; PEG > 1 potentially overvalued

**Price-to-Book (P/B) Ratio**
- Formula: Stock Price / Book Value Per Share
- Book Value = Total Assets - Total Liabilities
- Useful for asset-heavy industries

**Price-to-Sales (P/S) Ratio**
- Formula: Market Cap / Total Revenue
- Useful for unprofitable companies or comparing revenue multiples

**Enterprise Value (EV)**
- Formula: Market Cap + Total Debt - Cash
- Represents total company value

**EV/EBITDA**
- Formula: Enterprise Value / EBITDA
- EBITDA = Earnings Before Interest, Tax, Depreciation, Amortization
- Capital structure neutral valuation metric

**EV/Sales**
- Formula: Enterprise Value / Revenue
- Useful when comparing companies with different profitability

**Dividend Yield**
- Formula: Annual Dividend Per Share / Stock Price × 100
- Measures: Income return from stock

## Growth Metrics

**Revenue Growth Rate**
- Formula: (Current Revenue - Prior Revenue) / Prior Revenue × 100
- YoY (Year-over-Year), QoQ (Quarter-over-Quarter)

**Earnings Per Share (EPS) Growth**
- Formula: (Current EPS - Prior EPS) / Prior EPS × 100
- Track both reported and adjusted EPS

**Compound Annual Growth Rate (CAGR)**
- Formula: (Ending Value / Beginning Value)^(1/Years) - 1
- Smoothed growth rate over multiple years

## Liquidity Metrics

**Current Ratio**
- Formula: Current Assets / Current Liabilities
- Measures: Short-term liquidity
- > 1.5 generally considered healthy

**Quick Ratio (Acid-Test)**
- Formula: (Current Assets - Inventory) / Current Liabilities
- More conservative than current ratio
- > 1.0 generally considered healthy

**Cash Ratio**
- Formula: Cash and Cash Equivalents / Current Liabilities
- Most conservative liquidity measure

## Leverage Metrics

**Debt-to-Equity (D/E) Ratio**
- Formula: Total Debt / Total Equity
- Measures: Financial leverage
- Industry-dependent; lower generally safer

**Debt-to-Assets Ratio**
- Formula: Total Debt / Total Assets
- Shows proportion of assets financed by debt

**Interest Coverage Ratio**
- Formula: EBIT / Interest Expense
- Measures: Ability to pay interest
- > 2.5 generally considered safe

## Efficiency Metrics

**Asset Turnover**
- Formula: Revenue / Average Total Assets
- Measures: Efficiency in using assets to generate sales

**Inventory Turnover**
- Formula: COGS / Average Inventory
- Higher = more efficient inventory management

**Receivables Turnover**
- Formula: Revenue / Average Accounts Receivable
- Days Sales Outstanding (DSO) = 365 / Receivables Turnover

## Cash Flow Metrics

**Free Cash Flow (FCF)**
- Formula: Operating Cash Flow - Capital Expenditures
- Available cash for dividends, buybacks, debt repayment

**FCF Yield**
- Formula: Free Cash Flow Per Share / Stock Price × 100
- Similar to dividend yield but for total cash generation

**Cash Conversion Rate**
- Formula: Free Cash Flow / Net Income
- Should be close to or > 100%
- Lower ratio may indicate earnings quality issues

## Per Share Metrics

**Earnings Per Share (EPS)**
- Formula: Net Income / Weighted Average Shares Outstanding
- Basic EPS vs Diluted EPS (includes options, convertibles)

**Book Value Per Share**
- Formula: (Total Assets - Total Liabilities) / Shares Outstanding

**Cash Flow Per Share**
- Formula: Operating Cash Flow / Shares Outstanding

## Share Metrics

**Shares Outstanding**
- Total shares issued and held by investors
- Track dilution over time

**Float**
- Shares available for public trading
- Excludes insider and restricted shares

**Share Buybacks**
- Track net share reduction/increase
- Buybacks can boost EPS without earnings growth
