# Stock Analysis Report Template

## Report Structure

### 1. Executive Summary
Brief 2-3 paragraph overview that can stand alone:
- Company overview (1 sentence)
- Investment thesis (bull case in 2-3 sentences)
- Key risks (1-2 sentences)
- Valuation summary (current vs fair value estimate)
- Recommendation (Buy/Hold/Sell) with conviction level

### 2. Company Overview
- **Business Description**: What the company does, main products/services
- **Industry**: Sector classification and industry dynamics
- **Market Position**: Market cap, rank in industry
- **Key Statistics**: Quick reference table
  - Ticker, Exchange
  - Market Cap
  - Current Price
  - 52-Week Range
  - Average Volume

### 3. Investment Thesis
**Bull Case** (Why to invest):
- 3-5 strongest positive factors
- Support each with data/evidence
- Quantify when possible

**Bear Case** (Risks and concerns):
- 3-5 main risk factors
- Alternative scenarios where investment doesn't work
- Probability assessment when possible

### 4. Fundamental Analysis

**Business Quality**
- Competitive advantages/moats
- Management quality assessment
- Business model sustainability

**Financial Performance** (Use tables for clarity)
- Revenue trends (3-5 years)
- Profitability metrics trends
- Balance sheet strength
- Cash flow analysis
- Key ratios

**Growth Analysis**
- Historical growth rates
- Growth drivers
- Future growth prospects
- Market opportunity size

### 5. Valuation Analysis

**Current Valuation Metrics** (Table format)
- P/E (current, forward, 5-year avg)
- PEG
- P/B
- P/S
- EV/EBITDA
- EV/Sales
- Dividend Yield (if applicable)

**Peer Comparison** (Table format)
Compare key metrics against 3-5 direct competitors

**Fair Value Estimate**
- Valuation methodology used
- Key assumptions
- Fair value range (conservative to optimistic)
- Margin of safety vs current price
- Target price with timeframe

### 6. Technical Analysis

**Trend Analysis**
- Current trend direction
- Key support/resistance levels
- Moving average positions

**Indicator Summary**
- RSI reading and interpretation
- MACD status
- Volume trends
- Other relevant indicators

**Chart Patterns**
- Notable patterns forming or completed
- Breakout/breakdown levels to watch

**Technical Outlook**
- Short-term (1-3 months)
- Medium-term (3-6 months)

### 7. Risk Assessment

**Company-Specific Risks** (Prioritized)
1. [Highest risk with impact and probability]
2. [Second risk]
3. [Third risk]

**Market/Macro Risks**
- Economic sensitivity
- Interest rate impact
- Regulatory changes
- Industry disruption

**Risk Mitigation**
- Company's risk management
- Diversification considerations
- Position sizing recommendations

### 8. Catalysts and Timeline

**Positive Catalysts** (with expected timing)
- Upcoming events that could drive price up
- Product launches, earnings, regulatory approvals

**Negative Risks** (with timing)
- Events that could drive price down
- Lockup expirations, debt maturities

### 9. Recommendation

**Rating**: Buy / Hold / Sell
**Conviction Level**: High / Medium / Low
**Target Price**: $XX (timeframe: X months)
**Upside/Downside**: +/-XX%

**For Buy Recommendations**:
- Entry strategy (all at once, DCA, wait for pullback)
- Position sizing suggestion
- Stop-loss consideration
- Target prices (multiple levels)

**For Hold Recommendations**:
- Conditions to upgrade to Buy
- Conditions to downgrade to Sell
- Monitoring priorities

**For Sell Recommendations**:
- Exit strategy (immediate, gradual)
- Alternative investments to consider

### 10. Conclusion
- Summarize key points (3-4 bullets)
- Reiterate recommendation
- Next review date or monitoring triggers

---

## Formatting Guidelines

**Use Tables for:**
- Financial data comparisons
- Peer comparisons
- Key statistics
- Valuation metrics

**Use Bullet Points for:**
- Lists of factors/risks
- Key highlights
- Qualitative assessments

**Use Headers to:**
- Clearly separate sections
- Make report scannable
- Enable quick navigation

**Data Presentation:**
- Always include timeframe context
- Show trends (arrows, YoY%)
- Cite sources for all data
- Use consistent formatting (e.g., $B for billions)

**Writing Style:**
- Be direct and concise
- Quantify when possible
- Avoid jargon unless necessary
- Support opinions with evidence
- Balance bullish and bearish perspectives

## Comparison Report Structure

For "Compare Stock A vs Stock B" requests:

### 1. Side-by-Side Overview Table
Company metrics in columns for easy comparison

### 2. Relative Strengths Analysis
- Where each company excels
- Quantified advantages

### 3. Valuation Comparison
- Metrics comparison table
- Which appears cheaper and why

### 4. Technical Comparison
- Relative strength analysis
- Chart pattern comparison

### 5. Recommendation
- Which to buy/prefer and why
- Portfolio allocation suggestion
- Risk-adjusted return assessment
